/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.AbstractSchemaObjectReader;
import com.sqlapp.data.db.metadata.CheckConstraintReader;
import com.sqlapp.data.db.metadata.ColumnReader;
import com.sqlapp.data.db.metadata.ExcludeConstraintReader;
import com.sqlapp.data.db.metadata.ForeignKeyConstraintReader;
import com.sqlapp.data.db.metadata.IndexReader;
import com.sqlapp.data.db.metadata.MetadataReader;
import com.sqlapp.data.db.metadata.MetadataReaderUtils;
import com.sqlapp.data.db.metadata.TableObjectReader;
import com.sqlapp.data.db.metadata.UniqueConstraintReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.AbstractSchemaObject;
import com.sqlapp.data.schemas.CheckConstraint;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.ExcludeConstraint;
import com.sqlapp.data.schemas.ForeignKeyConstraint;
import com.sqlapp.data.schemas.Index;
import com.sqlapp.data.schemas.SchemaObjectProperties;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.UniqueConstraint;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.TripleKeyMap;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;

public abstract class TableReader
extends AbstractSchemaObjectReader<Table> {
    protected TableReader(Dialect dialect) {
        super(dialect);
    }

    @Override
    protected SchemaObjectProperties getSchemaObjectProperties() {
        return SchemaObjectProperties.TABLES;
    }

    @Override
    protected void setMetadataDetail(Connection connection, ParametersContext context, List<Table> tableList) throws SQLException {
        if (CommonUtils.isEmpty(tableList)) {
            return;
        }
        this.setFilter(tableList, context);
        TripleKeyMap<String, String, String, List<Column>> columnMap = this.getTableObjectKeyMap(connection, context, this.getColumnReader());
        TripleKeyMap<String, String, String, List<Index>> indexMap = this.getTableObjectKeyMap(connection, context, this.getIndexReader());
        TripleKeyMap<String, String, String, List<UniqueConstraint>> ucMap = this.getTableObjectKeyMap(connection, context, this.getUniqueConstraintReader());
        TripleKeyMap<String, String, String, List<ExcludeConstraint>> ecMap = this.getTableObjectKeyMap(connection, context, this.getExcludeConstraintReader());
        TripleKeyMap<String, String, String, List<CheckConstraint>> ccMap = this.getTableObjectKeyMap(connection, context, this.getCheckConstraintReader());
        TripleKeyMap<String, String, String, List<ForeignKeyConstraint>> fcMap = this.getTableObjectKeyMap(connection, context, this.getForeignKeyConstraintReader());
        for (Table table : tableList) {
            table.setDialect(this.getDialect());
            List<Column> columns = columnMap.get(table.getCatalogName(), table.getSchemaName(), table.getName());
            if (CommonUtils.isEmpty(columns)) continue;
            table.getColumns().addAll(columns);
            columnMap.remove(table.getCatalogName(), table.getSchemaName(), table.getName());
        }
        for (Table table : tableList) {
            List<ForeignKeyConstraint> foreignKeyConstraint;
            List<CheckConstraint> checkConstraints;
            List<ExcludeConstraint> excludeConstraints;
            List<UniqueConstraint> uniqueConstraints;
            List<Index> indexes = indexMap.get(table.getCatalogName(), table.getSchemaName(), table.getName());
            if (!CommonUtils.isEmpty(indexes)) {
                table.getIndexes().addAll(indexes);
            }
            if (!CommonUtils.isEmpty(uniqueConstraints = ucMap.get(table.getCatalogName(), table.getSchemaName(), table.getName()))) {
                table.getConstraints().addAll(uniqueConstraints);
            }
            if (!CommonUtils.isEmpty(excludeConstraints = ecMap.get(table.getCatalogName(), table.getSchemaName(), table.getName()))) {
                table.getConstraints().addAll(excludeConstraints);
            }
            if (!CommonUtils.isEmpty(checkConstraints = ccMap.get(table.getCatalogName(), table.getSchemaName(), table.getName()))) {
                table.getConstraints().addAll(checkConstraints);
            }
            if (CommonUtils.isEmpty(foreignKeyConstraint = fcMap.get(table.getCatalogName(), table.getSchemaName(), table.getName()))) continue;
            table.getConstraints().addAll(foreignKeyConstraint);
        }
    }

    protected void setFilter(List<Table> tableList, ParametersContext context) {
        Set catalogNames = CommonUtils.treeSet();
        Set schemaNames = CommonUtils.treeSet();
        Set tableNames = CommonUtils.treeSet();
        for (Table table : tableList) {
            if (table.getCatalogName() != null) {
                catalogNames.add(table.getCatalogName());
            }
            if (table.getSchemaName() != null) {
                schemaNames.add(table.getSchemaName());
            }
            if (table.getName() == null) continue;
            tableNames.add(table.getName());
        }
        if (!catalogNames.isEmpty()) {
            context.put("catalogName", (Object)catalogNames);
        }
        if (!schemaNames.isEmpty()) {
            context.put("schemaName", (Object)schemaNames);
        }
        if (!tableNames.isEmpty()) {
            context.put("tableName", (Object)tableNames);
        }
    }

    protected <T extends AbstractSchemaObject<? super T>> TripleKeyMap<String, String, String, List<T>> getTableObjectKeyMap(Connection connection, ParametersContext context, TableObjectReader<T> reader) {
        if (reader == null) {
            return new TripleKeyMap<String, String, String, List<T>>();
        }
        List ccList = reader.getAllFull(connection, context);
        TripleKeyMap<String, String, String, List<T>> ccMap = reader.toKeyMap(ccList);
        return ccMap;
    }

    protected void setTableObjects(Connection connection, TableObjectReader<?> reader, Table table) {
        if (reader != null) {
            reader.loadFull(connection, table);
        }
    }

    @Override
    protected String getNameLabel() {
        return SchemaProperties.TABLE_NAME.getLabel();
    }

    protected void setReaderParameter(TableObjectReader<?> reader) {
        if (reader != null) {
            reader.setCatalogName(this.getCatalogName());
            reader.setSchemaName(this.getSchemaName());
            reader.setObjectName(this.getObjectName());
            this.initializeChild(reader);
        }
    }

    public ColumnReader getColumnReader() {
        ColumnReader reader = this.newColumnReader();
        this.setReaderParameter(reader);
        return reader;
    }

    protected abstract ColumnReader newColumnReader();

    protected IndexReader getIndexReader() {
        IndexReader reader = this.newIndexReader();
        this.setReaderParameter(reader);
        return reader;
    }

    protected abstract IndexReader newIndexReader();

    public UniqueConstraintReader getUniqueConstraintReader() {
        UniqueConstraintReader reader = this.newUniqueConstraintReader();
        this.setReaderParameter(reader);
        return reader;
    }

    protected abstract UniqueConstraintReader newUniqueConstraintReader();

    public ExcludeConstraintReader getExcludeConstraintReader() {
        ExcludeConstraintReader reader = this.newExcludeConstraintReader();
        this.setReaderParameter(reader);
        return reader;
    }

    protected abstract ExcludeConstraintReader newExcludeConstraintReader();

    public CheckConstraintReader getCheckConstraintReader() {
        CheckConstraintReader reader = this.newCheckConstraintReader();
        this.setReaderParameter(reader);
        return reader;
    }

    protected abstract CheckConstraintReader newCheckConstraintReader();

    public ForeignKeyConstraintReader getForeignKeyConstraintReader() {
        ForeignKeyConstraintReader reader = this.newForeignKeyConstraintReader();
        this.setReaderParameter(reader);
        return reader;
    }

    protected abstract ForeignKeyConstraintReader newForeignKeyConstraintReader();

    protected <T extends MetadataReader<?, ?>> T getMetadataReader(String name) {
        if ("table".equalsIgnoreCase(name) || "tables".equalsIgnoreCase(name)) {
            return (T)this;
        }
        return MetadataReaderUtils.getMetadataReader(this, name);
    }

    protected Table createTable(String name) {
        Table table = new Table(name);
        table.setDialect(this.getDialect());
        return table;
    }
}

