/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.AbstractSchemaObjectReader;
import com.sqlapp.data.db.metadata.TypeColumnReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.DbObjects;
import com.sqlapp.data.schemas.SchemaObjectProperties;
import com.sqlapp.data.schemas.Type;
import com.sqlapp.data.schemas.TypeColumn;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.TripleKeyMap;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public abstract class TypeReader
extends AbstractSchemaObjectReader<Type> {
    protected static final String TYPE_NAME = "type_name";

    protected TypeReader(Dialect dialect) {
        super(dialect);
    }

    @Override
    protected SchemaObjectProperties getSchemaObjectProperties() {
        return SchemaObjectProperties.TYPES;
    }

    @Override
    protected void setMetadataDetail(Connection connection, ParametersContext context, List<Type> typeList) throws SQLException {
        TripleKeyMap<String, String, String, List<TypeColumn>> columnMap = this.getTableObjectKeyMap(connection, this.getColumnReader());
        for (Type type : typeList) {
            type.setDialect(this.getDialect());
            List<TypeColumn> columns = columnMap.get(type.getCatalogName(), type.getSchemaName(), type.getName());
            if (CommonUtils.isEmpty(columns)) continue;
            type.getColumns().addAll(columns);
            columnMap.remove(type.getCatalogName(), type.getSchemaName(), type.getName());
        }
    }

    protected TripleKeyMap<String, String, String, List<TypeColumn>> getTableObjectKeyMap(Connection connection, TypeColumnReader reader) {
        if (reader == null) {
            return new TripleKeyMap<String, String, String, List<TypeColumn>>();
        }
        List<TypeColumn> ccList = reader.getAllFull(connection);
        TripleKeyMap<String, String, String, List<TypeColumn>> ccMap = reader.toKeyMap(ccList);
        return ccMap;
    }

    @Override
    protected String getNameLabel() {
        return DbObjects.TYPE.getCamelCaseNameLabel();
    }

    protected TypeColumnReader getColumnReader() {
        TypeColumnReader reader = this.newColumnFactory();
        if (reader != null) {
            reader.setCatalogName(this.getCatalogName());
            reader.setSchemaName(this.getSchemaName());
            reader.setObjectName(this.getObjectName());
            this.initializeChild(reader);
        }
        return reader;
    }

    protected abstract TypeColumnReader newColumnFactory();
}

