/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.sql;

import com.sqlapp.data.db.sql.SimpleAlterSqlFactory;
import com.sqlapp.data.db.sql.SqlOperation;
import com.sqlapp.data.schemas.DbObjectDifference;
import com.sqlapp.data.schemas.DbObjectDifferenceCollection;
import com.sqlapp.data.schemas.Difference;
import com.sqlapp.data.schemas.Schema;
import com.sqlapp.data.schemas.SchemaObjectProperties;
import com.sqlapp.util.AbstractSqlBuilder;
import com.sqlapp.util.CommonUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractAlterCatalogFactory<S extends AbstractSqlBuilder<?>>
extends SimpleAlterSqlFactory<Schema, S> {
    private Set<String> ALTER_COLLECTION_ORDERS = CommonUtils.set();

    public AbstractAlterCatalogFactory() {
        this.initialize();
    }

    protected void initialize() {
        this.addCollectionOrder(SchemaObjectProperties.TABLE_SPACES.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.ROLES.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.USERS.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.DIRECTORIES.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.PARTITION_FUNCTIONS.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.PARTITION_SCHEMES.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.ASSEMBLIES.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.SCHEMAS.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.SCHEMA_PRIVILEGES.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.PUBLIC_DB_LINKS.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.PUBLIC_SYNONYMS.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.USER_PRIVILEGES.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.OBJECT_PRIVILEGES.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.ROLE_PRIVILEGES.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.ROLE_MEMBERS.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.COLUMN_PRIVILEGES.getLabel());
    }

    protected void addCollectionOrder(String name) {
        this.ALTER_COLLECTION_ORDERS.add(name);
    }

    protected Set<String> getAlterCollectionOrder() {
        return this.ALTER_COLLECTION_ORDERS;
    }

    @Override
    public List<SqlOperation> createDiffSql(DbObjectDifference difference) {
        List<SqlOperation> sqlList = CommonUtils.list();
        Map<String, Difference<?>> allDiff = difference.toDifference().getChangedProperties(this.getDialect());
        for (String name : this.getAlterCollectionOrder()) {
            DbObjectDifferenceCollection collectionDiff = (DbObjectDifferenceCollection)allDiff.get(name);
            if (collectionDiff == null) continue;
            this.addAlterObjects(name, collectionDiff, sqlList);
        }
        return sqlList;
    }

    protected void addAlterObjects(String propertyName, DbObjectDifferenceCollection collectionDiff, List<SqlOperation> sqlList) {
        this.addAlterObjects(collectionDiff, sqlList);
    }

    protected void addAlterObjects(DbObjectDifferenceCollection collectionDiff, List<SqlOperation> sqlList) {
        List<SqlOperation> ret = this.createDiffSql(collectionDiff.getList());
        sqlList.addAll(ret);
    }

    @Override
    public List<SqlOperation> createSql(Schema obj) {
        return Collections.EMPTY_LIST;
    }
}

