/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.sql;

import com.sqlapp.data.db.sql.AbstractTableFactory;
import com.sqlapp.data.db.sql.AddTableObjectDetailFactory;
import com.sqlapp.data.db.sql.SqlOperation;
import com.sqlapp.data.db.sql.SqlType;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.Constraint;
import com.sqlapp.data.schemas.DbObjectDifference;
import com.sqlapp.data.schemas.DbObjectDifferenceCollection;
import com.sqlapp.data.schemas.Difference;
import com.sqlapp.data.schemas.Index;
import com.sqlapp.data.schemas.SchemaObjectProperties;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.State;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.util.AbstractSqlBuilder;
import com.sqlapp.util.CommonUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public abstract class AbstractAlterTableFactory<S extends AbstractSqlBuilder<?>>
extends AbstractTableFactory<S> {
    @Override
    public List<SqlOperation> createDiffSql(DbObjectDifference difference) {
        DbObjectDifferenceCollection colsDiff;
        DbObjectDifferenceCollection indexesDiff;
        DbObjectDifferenceCollection consDiff;
        List<SqlOperation> result = CommonUtils.list();
        Map<String, Difference<?>> allDiff = difference.toDifference().getChangedProperties(this.getDialect());
        Table originalTable = difference.getOriginal(Table.class);
        Table table = difference.getTarget(Table.class);
        Difference<?> tableProp = allDiff.get(SchemaProperties.NAME.getLabel());
        if (tableProp != null) {
            Object builder = this.createSqlBuilder();
            ((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)builder).alter()).table()).name(originalTable, this.getOptions().isDecorateSchemaName());
            this.addTableComment(table, builder);
            ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).rename()).to();
            ((AbstractSqlBuilder)builder).name(table, this.getOptions().isDecorateSchemaName());
            this.add(result, this.createOperation(((AbstractSqlBuilder)builder).toString(), SqlType.ALTER, originalTable, table));
        }
        if ((consDiff = (DbObjectDifferenceCollection)allDiff.get(SchemaObjectProperties.CONSTRAINTS.getLabel())) != null) {
            this.addConstraintDefinitions(allDiff, originalTable, table, consDiff.getList(State.Deleted), result);
        }
        if ((indexesDiff = (DbObjectDifferenceCollection)allDiff.get(SchemaObjectProperties.INDEXES.getLabel())) != null) {
            this.addIndexDefinitions(allDiff, originalTable, table, indexesDiff.getList(State.Deleted), result);
        }
        if ((colsDiff = (DbObjectDifferenceCollection)allDiff.get(SchemaObjectProperties.COLUMNS.getLabel())) != null) {
            this.addColumnDefinitions(allDiff, originalTable, table, colsDiff, result);
        }
        if (consDiff != null) {
            this.addConstraintDefinitions(allDiff, originalTable, table, consDiff.getList(State.Added, State.Modified), result);
        }
        if (indexesDiff != null) {
            this.addIndexDefinitions(allDiff, originalTable, table, indexesDiff.getList(State.Added, State.Modified), result);
        }
        if ((tableProp = allDiff.get(SchemaObjectProperties.PARTITIONING.getLabel())) != null) {
            this.addPartitionDefinition(allDiff, originalTable, table, (DbObjectDifference)tableProp, result);
        }
        this.addOtherDefinitions(allDiff, originalTable, table, result);
        return result;
    }

    protected void addOtherDefinitions(Map<String, Difference<?>> allDiff, Table originalTable, Table table, List<SqlOperation> result) {
    }

    protected void addColumnDefinitions(Map<String, Difference<?>> allDiff, Table originalTable, Table table, DbObjectDifferenceCollection colsDiff, List<SqlOperation> result) {
        for (DbObjectDifference diff : colsDiff.getList(State.Deleted)) {
            this.addDeleteColumn(originalTable, table, diff, result);
        }
        List<DbObjectDifference> columnDiffList = colsDiff.getList(State.Added, State.Modified);
        this.sortColumnDiff(columnDiffList);
        for (DbObjectDifference diff : columnDiffList) {
            if (diff.getState() == State.Added) {
                this.addAddColumn(originalTable, table, diff, result);
                continue;
            }
            this.addRenameOrAlterColumn(originalTable, table, diff, result);
        }
    }

    protected void sortColumnDiff(List<DbObjectDifference> columnDiffList) {
        Collections.sort(columnDiffList, new Comparator<DbObjectDifference>(){

            @Override
            public int compare(DbObjectDifference o1, DbObjectDifference o2) {
                Column column1 = o1.getTarget(Column.class);
                Column column2 = o2.getTarget(Column.class);
                return column1.getOrdinal() - column2.getOrdinal();
            }
        });
    }

    protected void addDeleteColumn(Table originalTable, Table table, DbObjectDifference diff, List<SqlOperation> result) {
        Object builder = this.createSqlBuilder();
        Column column = diff.getOriginal(Column.class);
        ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).alter()).table();
        ((AbstractSqlBuilder)builder).name(table, this.getOptions().isDecorateSchemaName());
        ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).drop()).column();
        ((AbstractSqlBuilder)builder).name(column);
        this.add(result, this.createOperation(((AbstractSqlBuilder)builder).toString(), SqlType.ALTER, column));
    }

    protected void addAddColumn(Table originalTable, Table table, DbObjectDifference diff, List<SqlOperation> result) {
        Column column = diff.getTarget(Column.class);
        Object builder = this.createSqlBuilder();
        ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).alter()).table();
        ((AbstractSqlBuilder)builder).name(table, this.getOptions().isDecorateSchemaName());
        ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).add()).column();
        ((AbstractSqlBuilder)builder).name(column);
        ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).space()).definition(column, this.getOptions().getTableOptions().getWithColumnRemarks().test(column));
        this.add(result, this.createOperation(((AbstractSqlBuilder)builder).toString(), SqlType.ALTER, null, column));
    }

    protected void addRenameOrAlterColumn(Table originalTable, Table table, DbObjectDifference diff, List<SqlOperation> result) {
        Column oldColumn = diff.getOriginal(Column.class);
        Column column = diff.getTarget(Column.class);
        Map<String, Difference<?>> colDiff = diff.toDifference().getProperties(this.getDialect(), State.Added, State.Modified);
        Difference<?> nameDiff = colDiff.get(SchemaProperties.NAME.getLabel());
        if (colDiff.size() > 1 || nameDiff == null && colDiff.size() == 1) {
            this.addAlterColumn(originalTable, table, oldColumn, column, diff, result);
        }
        if (nameDiff != null) {
            this.addRenameColumn(originalTable, table, oldColumn, column, diff, result);
        }
    }

    protected void addAlterColumn(Table originalTable, Table table, Column oldColumn, Column column, DbObjectDifference diff, List<SqlOperation> result) {
        Object builder = this.createSqlBuilder();
        ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).alter()).table();
        ((AbstractSqlBuilder)builder).name(table, this.getOptions().isDecorateSchemaName());
        ((AbstractSqlBuilder)builder).alterColumn();
        ((AbstractSqlBuilder)builder).name(column);
        ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).space()).definitionForAlterColumn(column);
        this.add(result, this.createOperation(((AbstractSqlBuilder)builder).toString(), SqlType.ALTER, oldColumn, column));
    }

    protected void addRenameColumn(Table originalTable, Table table, Column oldColumn, Column column, DbObjectDifference diff, List<SqlOperation> result) {
        Object builder = this.createSqlBuilder();
        ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).alter()).table();
        ((AbstractSqlBuilder)builder).name(table, this.getOptions().isDecorateSchemaName());
        ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).rename()).column();
        ((AbstractSqlBuilder)builder).name(oldColumn);
        ((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)builder).space()).to()).space();
        ((AbstractSqlBuilder)builder).name(column);
        this.add(result, this.createOperation(((AbstractSqlBuilder)builder).toString(), SqlType.ALTER, oldColumn, column));
    }

    protected void addIndexDefinitions(Map<String, Difference<?>> allDiff, Table originalTable, Table table, List<DbObjectDifference> indexesDiff, List<SqlOperation> result) {
        for (DbObjectDifference diff : indexesDiff) {
            Index index = diff.getTarget(Index.class);
            Index originalIndex = diff.getOriginal(Index.class);
            this.addIndexDefinition(originalTable, table, originalIndex, index, diff, result);
        }
    }

    protected void addIndexDefinition(Table originalTable, Table table, Index originalIndex, Index index, DbObjectDifference diff, List<SqlOperation> result) {
        if (diff.getState() == State.Added) {
            this.addCreateIndexDefinition(originalTable, table, originalIndex, index, diff, result);
        } else if (diff.getState() == State.Modified) {
            this.addDropIndexDefinition(originalTable, table, originalIndex, index, diff, result);
            this.addCreateIndexDefinition(originalTable, table, originalIndex, index, diff, result);
        } else if (diff.getState() == State.Deleted) {
            this.addDropIndexDefinition(originalTable, table, originalIndex, index, diff, result);
        }
    }

    protected void addCreateIndexDefinition(Table originalTable, Table table, Index originalIndex, Index index, DbObjectDifference diff, List<SqlOperation> result) {
        Object builder = this.createSqlBuilder();
        this.addCreateIndexDefinition(index, builder);
        this.add(result, this.createOperation(((AbstractSqlBuilder)builder).toString(), SqlType.CREATE, index));
    }

    protected void addDropIndexDefinition(Table originalTable, Table table, Index originalIndex, Index index, DbObjectDifference diff, List<SqlOperation> result) {
        Object builder = this.createSqlBuilder();
        this.addDropIndexDefinition(originalIndex, builder);
        this.add(result, this.createOperation(((AbstractSqlBuilder)builder).toString(), SqlType.DROP, originalIndex));
    }

    protected void addConstraintDefinitions(Map<String, Difference<?>> allDiff, Table originalTable, Table table, List<DbObjectDifference> consDiff, List<SqlOperation> result) {
        for (DbObjectDifference diff : consDiff) {
            Constraint originalConstraint = diff.getOriginal(Constraint.class);
            Constraint constraint = diff.getTarget(Constraint.class);
            this.addConstraintDefinition(originalTable, table, originalConstraint, constraint, diff, result);
        }
    }

    protected void addConstraintDefinition(Table originalTable, Table table, Constraint originalConstraint, Constraint constraint, DbObjectDifference diff, List<SqlOperation> result) {
        if (diff.getState() == State.Deleted) {
            this.addDropConstraintDefinition(originalTable, table, originalConstraint, constraint, diff, result);
        } else if (diff.getState() == State.Modified) {
            this.addDropConstraintDefinition(originalTable, table, originalConstraint, constraint, diff, result);
            this.addCreateConstraintDefinition(originalTable, table, originalConstraint, constraint, diff, result);
        } else if (diff.getState() == State.Added) {
            this.addCreateConstraintDefinition(originalTable, table, originalConstraint, constraint, diff, result);
        }
    }

    protected void addCreateConstraintDefinition(Table originalTable, Table table, Constraint originalConstraint, Constraint constraint, DbObjectDifference diff, List<SqlOperation> result) {
        Object builder = this.createSqlBuilder();
        this.addConstraintDefinition(originalTable, table, constraint, builder);
        this.add(result, this.createOperation(((AbstractSqlBuilder)builder).toString(), SqlType.CREATE, constraint));
    }

    protected void addDropConstraintDefinition(Table originalTable, Table table, Constraint originalConstraint, Constraint constraint, DbObjectDifference diff, List<SqlOperation> result) {
        Object builder = this.createSqlBuilder();
        this.dropConstraintDefinition(originalConstraint, builder);
        this.add(result, this.createOperation(((AbstractSqlBuilder)builder).toString(), SqlType.ALTER, originalConstraint));
    }

    protected void addConstraintDefinition(Table originalTable, Table table, Constraint obj, S builder) {
        if (obj == null) {
            return;
        }
        AddTableObjectDetailFactory<Constraint, AbstractSqlBuilder<?>> sqlFactory = this.getAddTableObjectDetailOperationFactory(obj);
        if (sqlFactory != null) {
            this.addConstraintDefinition(table, obj, sqlFactory, builder);
        }
    }

    protected void addConstraintDefinition(Table table, Constraint constraint, AddTableObjectDetailFactory<Constraint, AbstractSqlBuilder<?>> sqlFactory, S builder) {
        ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).alter()).table();
        ((AbstractSqlBuilder)builder).name(table, this.getOptions().isDecorateSchemaName());
        ((AbstractSqlBuilder)builder).add();
        sqlFactory.addObjectDetail(constraint, table, (AbstractSqlBuilder<?>)builder);
    }

    protected void addDropIndexDefinition(Index obj, S builder) {
        ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).drop()).index();
        ((AbstractSqlBuilder)builder).name(obj);
    }

    protected void dropConstraintDefinition(Constraint obj, S builder) {
        ((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)builder).alter()).table()).name(obj.getParent().getTable(), this.getOptions().isDecorateSchemaName())).drop()).constraint();
        ((AbstractSqlBuilder)builder).name(obj, false);
    }

    protected void addAlterTable(Table obj, S builder) {
        ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).alter()).table();
        ((AbstractSqlBuilder)builder).name(obj, this.getOptions().isDecorateSchemaName());
    }

    protected void addPartitionDefinition(Map<String, Difference<?>> allDiff, Table originalTable, Table table, DbObjectDifference partitioningProp, List<SqlOperation> result) {
    }

    @Override
    public List<SqlOperation> createSql(Table table) {
        return Collections.EMPTY_LIST;
    }
}

