/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.sql;

import com.sqlapp.data.db.sql.SimpleSqlFactory;
import com.sqlapp.data.db.sql.SqlOperation;
import com.sqlapp.data.db.sql.SqlType;
import com.sqlapp.data.schemas.AbstractDbObject;
import com.sqlapp.data.schemas.AbstractDbObjectCollection;
import com.sqlapp.data.schemas.Catalog;
import com.sqlapp.data.schemas.SchemaObjectProperties;
import com.sqlapp.util.AbstractSqlBuilder;
import com.sqlapp.util.CommonUtils;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractCreateCatalogFactory<S extends AbstractSqlBuilder<?>>
extends SimpleSqlFactory<Catalog, S> {
    private static final Set<String> createCollectionOrder = CommonUtils.linkedSet();

    public AbstractCreateCatalogFactory() {
        this.initialize();
    }

    protected void initialize() {
        this.addCollectionOrder(SchemaObjectProperties.TABLE_SPACES.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.ROLES.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.USERS.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.DIRECTORIES.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.PARTITION_FUNCTIONS.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.PARTITION_SCHEMES.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.ASSEMBLIES.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.SCHEMAS.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.SCHEMA_PRIVILEGES.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.PUBLIC_DB_LINKS.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.PUBLIC_SYNONYMS.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.USER_PRIVILEGES.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.OBJECT_PRIVILEGES.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.ROLE_PRIVILEGES.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.ROLE_MEMBERS.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.COLUMN_PRIVILEGES.getLabel());
    }

    protected void addCollectionOrder(String name) {
        createCollectionOrder.add(name);
    }

    protected Set<String> getCreateCollectionOrder() {
        return createCollectionOrder;
    }

    @Override
    public List<SqlOperation> createSql(Catalog catalog) {
        List<SqlOperation> sqlList = CommonUtils.list();
        Map map = catalog.toMap();
        for (String name : this.getCreateCollectionOrder()) {
            AbstractDbObjectCollection sc = (AbstractDbObjectCollection)map.get(name);
            if (sc == null) continue;
            this.addCreateDbObjectCollection(name, sc, sqlList);
        }
        return sqlList;
    }

    protected void addCreateDbObjectCollection(String propertyName, AbstractDbObjectCollection<?> sc, List<SqlOperation> sqlList) {
        for (AbstractDbObject schemaObject : sc) {
            Object sqlFactory = this.getSqlFactoryRegistry().getSqlFactory(schemaObject, SqlType.CREATE);
            List<SqlOperation> operations = sqlFactory.createSql((AbstractDbObject)schemaObject);
            sqlList.addAll(operations);
        }
    }
}

