/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.sql;

import com.sqlapp.data.db.sql.AbstractSqlFactory;
import com.sqlapp.data.db.sql.SimpleSqlFactory;
import com.sqlapp.data.db.sql.SqlOperation;
import com.sqlapp.data.db.sql.SqlType;
import com.sqlapp.data.schemas.AbstractSchemaObject;
import com.sqlapp.data.schemas.AbstractSchemaObjectCollection;
import com.sqlapp.data.schemas.Schema;
import com.sqlapp.data.schemas.SchemaObjectProperties;
import com.sqlapp.util.AbstractSqlBuilder;
import com.sqlapp.util.CommonUtils;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractCreateSchemaFactory<S extends AbstractSqlBuilder<?>>
extends SimpleSqlFactory<Schema, S> {
    private static final Set<String> createCollectionOrder = CommonUtils.set();

    public AbstractCreateSchemaFactory() {
        this.initialize();
    }

    protected void initialize() {
        this.addCollectionOrder(SchemaObjectProperties.CONSTANTS.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.SEQUENCES.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.OPERATORS.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.OPERATOR_CLASSES.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.PACKAGES.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.TYPES.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.DOMAINS.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.FUNCTIONS.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.PROCEDURES.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.EXTERNAL_TABLES.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.DB_LINKS.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.TABLES.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.TABLE_LINKS.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.VIEWS.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.MVIEW_LOGS.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.MVIEWS.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.RULES.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.PACKAGE_BODIES.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.TYPE_BODIES.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.TRIGGERS.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.SYNONYMS.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.DIMENSIONS.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.XML_SCHEMAS.getLabel());
        this.addCollectionOrder(SchemaObjectProperties.EVENTS.getLabel());
    }

    protected void addCollectionOrder(String name) {
        createCollectionOrder.add(name);
    }

    protected Set<String> getCreateCollectionOrder() {
        return createCollectionOrder;
    }

    @Override
    public List<SqlOperation> createSql(Schema schema) {
        List<SqlOperation> sqlList = CommonUtils.list();
        this.addCreateSchema(schema, sqlList);
        Map map = schema.toMap();
        for (String name : this.getCreateCollectionOrder()) {
            AbstractSchemaObjectCollection sc = (AbstractSchemaObjectCollection)map.get(name);
            if (sc == null) continue;
            this.addCreateSchemaObjectCollection(name, sc, sqlList);
        }
        return sqlList;
    }

    protected void addCreateSchema(Schema schema, List<SqlOperation> sqlList) {
        Object builder = this.createSqlBuilder();
        this.addCreateObject(schema, builder);
        this.addSql(sqlList, (AbstractSqlBuilder<?>)builder, SqlType.CREATE, schema);
    }

    protected void addCreateObject(Schema obj, S builder) {
        ((AbstractSqlBuilder)((AbstractSqlBuilder)builder).create()).schema();
        ((AbstractSqlBuilder)builder).name(obj);
    }

    protected void addCreateSchemaObjectCollection(String propertyName, AbstractSchemaObjectCollection<?> sc, List<SqlOperation> sqlList) {
        AbstractSchemaObject s = (AbstractSchemaObject)CommonUtils.first(sc);
        if (s == null) {
            return;
        }
        Object sqlFactory = this.getSqlFactoryRegistry().getSqlFactory(s, SqlType.CREATE);
        if (sqlFactory instanceof AbstractSqlFactory) {
            List<?> sorted = CommonUtils.list(sc);
            sorted = ((AbstractSqlFactory)sqlFactory).sort(sorted);
            this.addCreateSortedSchemaObjectCollection(propertyName, sorted, sqlList);
        } else {
            this.addCreateSchemaObjectCollection(propertyName, sc, sqlList);
        }
    }

    protected void addCreateSortedSchemaObjectCollection(String propertyName, List<? extends AbstractSchemaObject<?>> sc, List<SqlOperation> sqlList) {
        for (AbstractSchemaObject<?> schemaObject : sc) {
            Object sqlFactory = this.getSqlFactoryRegistry().getSqlFactory(schemaObject, SqlType.CREATE);
            List<SqlOperation> operations = sqlFactory.createSql(schemaObject);
            sqlList.addAll(operations);
        }
    }
}

