/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.sql;

import com.sqlapp.data.db.sql.SqlExecutor;
import com.sqlapp.data.db.sql.SqlOperation;
import java.io.IOException;

public abstract class AbstractSqlExecutor
implements SqlExecutor {
    @Override
    public void execute(SqlOperation ... operations) throws Exception {
        for (SqlOperation operation : operations) {
            if (operation.getSqlType() == null) {
                this.writeStartStatementTerminator(operation);
                this.write(operation.getSqlText());
                this.write(";");
                this.write("\n");
                this.writeEndStatementTerminator(operation);
            } else if (operation.getSqlType().isEmptyLine()) {
                this.write("\n");
            } else if (operation.getSqlType().isComment()) {
                this.write(operation.getSqlText());
                this.write("\n");
            } else {
                this.writeStartStatementTerminator(operation);
                this.write(operation.getSqlText());
                this.write(";");
                this.write("\n");
                this.writeEndStatementTerminator(operation);
            }
            this.write("\n");
        }
    }

    private void writeStartStatementTerminator(SqlOperation operation) throws Exception {
        if (operation.getStartStatementTerminator() != null) {
            this.write(operation.getStartStatementTerminator());
            this.write("\n");
        }
    }

    protected abstract void write(String var1) throws IOException;

    private void writeEndStatementTerminator(SqlOperation operation) throws Exception {
        if (operation.getEndStatementTerminator() != null) {
            this.write(operation.getEndStatementTerminator());
            this.write("\n");
        }
    }
}

