/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.sql;

import com.sqlapp.data.db.sql.SqlExecutor;
import com.sqlapp.data.db.sql.SqlOperation;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.DbUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import javax.sql.DataSource;

public class DataSourceSqlExecutor
implements SqlExecutor {
    private DataSource dataSource = null;

    public DataSourceSqlExecutor() {
    }

    public DataSourceSqlExecutor(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Collection<SqlOperation> operations) throws SQLException {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.getConnection();
            statement = connection.createStatement();
            for (SqlOperation operation : operations) {
                if (CommonUtils.isEmpty(operation.getSqlText())) continue;
                statement.execute(operation.getSqlText());
            }
        }
        catch (Throwable throwable) {
            DbUtils.close(statement);
            DbUtils.close(connection);
            throw throwable;
        }
        DbUtils.close(statement);
        DbUtils.close(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(SqlOperation ... operations) throws SQLException {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.getConnection();
            statement = connection.createStatement();
            for (SqlOperation operation : operations) {
                if (CommonUtils.isEmpty(operation.getSqlText())) continue;
                statement.execute(operation.getSqlText());
            }
        }
        catch (Throwable throwable) {
            DbUtils.close(statement);
            DbUtils.close(connection);
            throw throwable;
        }
        DbUtils.close(statement);
        DbUtils.close(connection);
    }

    protected Connection getConnection() throws SQLException {
        Connection connection = this.getDataSource().getConnection();
        return connection;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

