/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.sql;

import com.sqlapp.data.db.sql.AbstractBean;
import com.sqlapp.data.db.sql.SqlType;
import com.sqlapp.data.db.sql.TableLockMode;
import com.sqlapp.data.schemas.Index;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.function.ColumnFunction;
import com.sqlapp.data.schemas.function.ColumnPredicate;
import com.sqlapp.data.schemas.function.ColumnStringFunction;
import com.sqlapp.data.schemas.function.RowColumnStringFunction;
import com.sqlapp.data.schemas.function.SerializableFunction;
import com.sqlapp.data.schemas.function.SerializablePredicate;
import com.sqlapp.data.schemas.function.StringPredicate;
import com.sqlapp.data.schemas.function.StringSupplier;
import com.sqlapp.data.schemas.function.TableBiPredicate;
import com.sqlapp.data.schemas.function.TableFunction;
import com.sqlapp.data.schemas.function.TableIntegerFunction;
import com.sqlapp.data.schemas.function.TablePredicate;
import com.sqlapp.data.schemas.function.TableSqlBuilder;
import com.sqlapp.data.schemas.function.TableStringFunction;
import com.sqlapp.util.AbstractSqlBuilder;
import java.io.Serializable;
import java.util.function.Function;

public class TableOptions
extends AbstractBean
implements Serializable {
    private static final long serialVersionUID = 7979457626849940402L;
    private TablePredicate withForeignKeyConstraint = table -> true;
    private TablePredicate withUniqueConstraint = table -> true;
    private TableBiPredicate<Index> onlineIndex = (table, index) -> false;
    private TablePredicate withCheckConstraint = table -> true;
    private TablePredicate withExcludeConstraint = table -> true;
    private TablePredicate allowDropPartition = table -> true;
    private TablePredicate allowAddPartition = table -> true;
    private TablePredicate commitPerTable = table -> false;
    private ColumnStringFunction parameterExpression = (column, def) -> {
        if (def == null) {
            return "/*" + column.getName() + "*/1";
        }
        if (def.contains("(")) {
            return "/*" + column.getName() + "*/''";
        }
        return "/*" + column.getName() + "*/" + def;
    };
    private SerializableFunction<String, String> ifStartExpression = condition -> "/*if " + condition + " */";
    private SerializableFunction<String, String> isNotEmptyExpression = condition -> "isNotEmpty(" + condition + ")";
    private StringSupplier endIfExpression = () -> "/*end*/";
    private SerializablePredicate<SqlType> commitPerSqlType = sqlType -> false;
    private TablePredicate mergeAllWithDelete = table -> false;
    private static int DEFAULT_DML_BATCH_SIZE = 1;
    private TableIntegerFunction dmlBatchSize = t -> DEFAULT_DML_BATCH_SIZE;
    private TableStringFunction temporaryAlias = t -> "_target";
    private ColumnPredicate createdAtColumn = c -> c.getDataType().isDateTime() && c.getName().equalsIgnoreCase("created_at");
    private ColumnPredicate updatedAtColumn = c -> c.getDataType().isDateTime() && c.getName().equalsIgnoreCase("updated_at");
    private ColumnPredicate optimisticLockColumn = c -> c.getName().equalsIgnoreCase("lock_version") || c.getName().equalsIgnoreCase("version_no");
    private ColumnPredicate insertableColumn = c -> true;
    private ColumnPredicate updateableColumn = c -> true;
    private ColumnFunction<String> insertTableColumnValue = c -> c.getName();
    private ColumnFunction<String> updateTableColumnValue = c -> c.getName();
    private RowColumnStringFunction insertRowSqlValue = (r, c, v) -> v;
    private StringPredicate dynamicValue = v -> v != null && v.startsWith("${") && v.endsWith("}");
    private RowColumnStringFunction updateRowSqlValue = (r, c, v) -> v;
    private ColumnPredicate withCoalesceAtInsert = c -> false;
    private TableStringFunction tempTableName = t -> t.getName() + "_temp";
    private ColumnPredicate withColumnRemarks = c -> false;
    private TablePredicate selectAllColumnASAsterisk = t -> true;
    private ColumnPredicate withCoalesceAtUpdate = c -> false;
    private ColumnPredicate autoIncrementColumn = c -> c.isIdentity() || c.getDataType().isAutoIncrementable();
    private TableSqlBuilder<AbstractSqlBuilder<?>> selectAllCondition = null;
    private TableSqlBuilder<AbstractSqlBuilder<?>> updateAllCondition = null;
    private TableSqlBuilder<AbstractSqlBuilder<?>> deleteAllCondition = null;
    private SqlType insertSqlType = SqlType.INSERT;
    private SqlType updateSqlType = SqlType.UPDATE;
    private SqlType deleteSqlType = SqlType.DELETE_BY_PK;
    private SqlType truncateSqlType = SqlType.TRUNCATE;
    private Function<Table, TableLockMode> lockMode = t -> TableLockMode.EXCLUSIVE;
    private ColumnFunction<String> columnComment = c -> c.getRemarks();
    private ColumnFunction<String> selectColumnComment = c -> null;
    private ColumnFunction<String> insertColumnComment = c -> null;
    private ColumnFunction<String> updateColumnComment = c -> null;
    private ColumnFunction<String> whereColumnComment = c -> null;
    private TableFunction<String> tableComment = t -> null;

    public void setWithForeignKeyConstraint(TablePredicate withForeignKeyConstraint) {
        this.withForeignKeyConstraint = withForeignKeyConstraint;
    }

    public void setWithForeignKeyConstraint(boolean bool) {
        this.withForeignKeyConstraint = table -> bool;
    }

    public void setOnlineIndex(boolean bool) {
        this.onlineIndex = (table, index) -> bool;
    }

    public void setWithUniqueConstraint(boolean bool) {
        this.withUniqueConstraint = table -> bool;
    }

    public void setWithUniqueConstraint(TablePredicate withUniqueConstraint) {
        this.withUniqueConstraint = withUniqueConstraint;
    }

    public void setWithCheckConstraint(boolean bool) {
        this.withCheckConstraint = table -> bool;
    }

    public void setWithCheckConstraint(TablePredicate withCheckConstraint) {
        this.withCheckConstraint = withCheckConstraint;
    }

    public void setWithExcludeConstraint(boolean bool) {
        this.withExcludeConstraint = table -> bool;
    }

    public void setWithExcludeConstraint(TablePredicate withExcludeConstraint) {
        this.withExcludeConstraint = withExcludeConstraint;
    }

    public void setAllowDropPartition(boolean bool) {
        this.allowDropPartition = table -> bool;
    }

    public void setAllowDropPartition(TablePredicate allowDropPartition) {
        this.allowDropPartition = allowDropPartition;
    }

    public void setAllowAddPartition(boolean bool) {
        this.allowAddPartition = table -> bool;
    }

    public void setAllowAddPartition(TablePredicate allowAddPartition) {
        this.allowAddPartition = allowAddPartition;
    }

    public void setEndIfExpression(StringSupplier endIfExpression) {
        this.endIfExpression = endIfExpression;
    }

    public void setEndIfExpression(String expression) {
        this.endIfExpression = () -> expression;
    }

    public void setCommitPerTable(TablePredicate commitPerTable) {
        this.commitPerTable = commitPerTable;
    }

    public void setCommitPerTable(boolean bool) {
        this.commitPerTable = table -> bool;
    }

    public void setCommitPerSqlType(SerializablePredicate<SqlType> commitPerSqlType) {
        this.commitPerSqlType = commitPerSqlType;
    }

    public void setCommitPerSqlType(boolean bool) {
        this.commitPerSqlType = sqlType -> bool;
    }

    public void setMergeAllWithDelete(TablePredicate mergeAllWithDelete) {
        this.mergeAllWithDelete = mergeAllWithDelete;
    }

    public void setMergeAllWithDelete(boolean bool) {
        this.mergeAllWithDelete = table -> bool;
    }

    public void setDmlBatchSize(TableIntegerFunction dmlBatchSize) {
        this.dmlBatchSize = dmlBatchSize;
    }

    public void setDmlBatchSize(int value) {
        this.dmlBatchSize = table -> value;
    }

    public void setTemporaryAlias(TableStringFunction temporaryAlias) {
        this.temporaryAlias = temporaryAlias;
    }

    public void setTemporaryAlias(String value) {
        this.temporaryAlias = table -> value;
    }

    public void setCreatedAtColumn(ColumnPredicate createdAtColumn) {
        this.createdAtColumn = createdAtColumn;
    }

    public void setCreatedAtColumn(String columnName) {
        this.createdAtColumn = c -> c.getDataType().isDateTime() && c.getName().equalsIgnoreCase(columnName);
    }

    public void setUpdatedAtColumn(ColumnPredicate updatedAtColumn) {
        this.updatedAtColumn = updatedAtColumn;
    }

    public void setUpdatedAtColumn(String columnName) {
        this.updatedAtColumn = c -> c.getDataType().isDateTime() && c.getName().equalsIgnoreCase(columnName);
    }

    public void setOptimisticLockColumn(ColumnPredicate optimisticLockColumn) {
        this.optimisticLockColumn = optimisticLockColumn;
    }

    public void setOptimisticLockColumn(String columnName) {
        this.optimisticLockColumn = c -> c.getName().equalsIgnoreCase(columnName);
    }

    public void setInsertableColumnn(ColumnPredicate insertableColumn) {
        this.insertableColumn = insertableColumn;
    }

    public void setInsertableColumnn(boolean bool) {
        this.insertableColumn = c -> bool;
    }

    public void setUpdateableColumn(ColumnPredicate updateableColumn) {
        this.updateableColumn = updateableColumn;
    }

    public void setUpdateableColumn(boolean bool) {
        this.updateableColumn = c -> bool;
    }

    public void setWithCoalesceAtInsert(boolean bool) {
        this.withCoalesceAtInsert = c -> bool;
    }

    public void setWithCoalesceAtInsert(ColumnPredicate withCoalesceAtInsert) {
        this.withCoalesceAtInsert = withCoalesceAtInsert;
    }

    public void setWithColumnRemarks(boolean bool) {
        this.withColumnRemarks = c -> bool;
    }

    public void setWithColumnRemarks(ColumnPredicate withColumnRemarks) {
        this.withColumnRemarks = withColumnRemarks;
    }

    public void setSelectAllColumnASAsterisk(boolean bool) {
        this.selectAllColumnASAsterisk = t -> bool;
    }

    public void setSelectAllColumnASAsterisk(TablePredicate selectAllColumnASAsterisk) {
        this.selectAllColumnASAsterisk = selectAllColumnASAsterisk;
    }

    public ColumnPredicate getWithCoalesceAtUpdate() {
        return this.withCoalesceAtUpdate;
    }

    public void setWithCoalesceAtUpdate(boolean bool) {
        this.withCoalesceAtUpdate = c -> bool;
    }

    public void setWithCoalesceAtUpdate(ColumnPredicate withCoalesceAtUpdate) {
        this.withCoalesceAtUpdate = withCoalesceAtUpdate;
    }

    public void setTempTableName(TableStringFunction tempTableName) {
        this.tempTableName = tempTableName;
    }

    public void setSelectAllCondition(TableSqlBuilder<AbstractSqlBuilder<?>> selectAllCondition) {
        this.selectAllCondition = selectAllCondition;
    }

    public void setUpdateAllCondition(TableSqlBuilder<AbstractSqlBuilder<?>> updateAllCondition) {
        this.updateAllCondition = updateAllCondition;
    }

    public void setDeleteAllCondition(TableSqlBuilder<AbstractSqlBuilder<?>> deleteAllCondition) {
        this.deleteAllCondition = deleteAllCondition;
    }

    @Override
    public TableOptions clone() {
        return (TableOptions)super.clone();
    }

    public TablePredicate getWithForeignKeyConstraint() {
        return this.withForeignKeyConstraint;
    }

    public TablePredicate getWithUniqueConstraint() {
        return this.withUniqueConstraint;
    }

    public TableBiPredicate<Index> getOnlineIndex() {
        return this.onlineIndex;
    }

    public TablePredicate getWithCheckConstraint() {
        return this.withCheckConstraint;
    }

    public TablePredicate getWithExcludeConstraint() {
        return this.withExcludeConstraint;
    }

    public TablePredicate getAllowDropPartition() {
        return this.allowDropPartition;
    }

    public TablePredicate getAllowAddPartition() {
        return this.allowAddPartition;
    }

    public TablePredicate getCommitPerTable() {
        return this.commitPerTable;
    }

    public ColumnStringFunction getParameterExpression() {
        return this.parameterExpression;
    }

    public SerializableFunction<String, String> getIfStartExpression() {
        return this.ifStartExpression;
    }

    public SerializableFunction<String, String> getIsNotEmptyExpression() {
        return this.isNotEmptyExpression;
    }

    public StringSupplier getEndIfExpression() {
        return this.endIfExpression;
    }

    public SerializablePredicate<SqlType> getCommitPerSqlType() {
        return this.commitPerSqlType;
    }

    public TablePredicate getMergeAllWithDelete() {
        return this.mergeAllWithDelete;
    }

    public TableIntegerFunction getDmlBatchSize() {
        return this.dmlBatchSize;
    }

    public TableStringFunction getTemporaryAlias() {
        return this.temporaryAlias;
    }

    public ColumnPredicate getCreatedAtColumn() {
        return this.createdAtColumn;
    }

    public ColumnPredicate getUpdatedAtColumn() {
        return this.updatedAtColumn;
    }

    public ColumnPredicate getOptimisticLockColumn() {
        return this.optimisticLockColumn;
    }

    public ColumnPredicate getInsertableColumn() {
        return this.insertableColumn;
    }

    public ColumnPredicate getUpdateableColumn() {
        return this.updateableColumn;
    }

    public ColumnFunction<String> getInsertTableColumnValue() {
        return this.insertTableColumnValue;
    }

    public ColumnFunction<String> getUpdateTableColumnValue() {
        return this.updateTableColumnValue;
    }

    public RowColumnStringFunction getInsertRowSqlValue() {
        return this.insertRowSqlValue;
    }

    public StringPredicate getDynamicValue() {
        return this.dynamicValue;
    }

    public RowColumnStringFunction getUpdateRowSqlValue() {
        return this.updateRowSqlValue;
    }

    public ColumnPredicate getWithCoalesceAtInsert() {
        return this.withCoalesceAtInsert;
    }

    public TableStringFunction getTempTableName() {
        return this.tempTableName;
    }

    public ColumnPredicate getWithColumnRemarks() {
        return this.withColumnRemarks;
    }

    public TablePredicate getSelectAllColumnASAsterisk() {
        return this.selectAllColumnASAsterisk;
    }

    public ColumnPredicate getAutoIncrementColumn() {
        return this.autoIncrementColumn;
    }

    public TableSqlBuilder<AbstractSqlBuilder<?>> getSelectAllCondition() {
        return this.selectAllCondition;
    }

    public TableSqlBuilder<AbstractSqlBuilder<?>> getUpdateAllCondition() {
        return this.updateAllCondition;
    }

    public TableSqlBuilder<AbstractSqlBuilder<?>> getDeleteAllCondition() {
        return this.deleteAllCondition;
    }

    public SqlType getInsertSqlType() {
        return this.insertSqlType;
    }

    public SqlType getUpdateSqlType() {
        return this.updateSqlType;
    }

    public SqlType getDeleteSqlType() {
        return this.deleteSqlType;
    }

    public SqlType getTruncateSqlType() {
        return this.truncateSqlType;
    }

    public Function<Table, TableLockMode> getLockMode() {
        return this.lockMode;
    }

    public ColumnFunction<String> getColumnComment() {
        return this.columnComment;
    }

    public ColumnFunction<String> getSelectColumnComment() {
        return this.selectColumnComment;
    }

    public ColumnFunction<String> getInsertColumnComment() {
        return this.insertColumnComment;
    }

    public ColumnFunction<String> getUpdateColumnComment() {
        return this.updateColumnComment;
    }

    public ColumnFunction<String> getWhereColumnComment() {
        return this.whereColumnComment;
    }

    public TableFunction<String> getTableComment() {
        return this.tableComment;
    }

    public void setParameterExpression(ColumnStringFunction parameterExpression) {
        this.parameterExpression = parameterExpression;
    }

    public void setIfStartExpression(SerializableFunction<String, String> ifStartExpression) {
        this.ifStartExpression = ifStartExpression;
    }

    public void setIsNotEmptyExpression(SerializableFunction<String, String> isNotEmptyExpression) {
        this.isNotEmptyExpression = isNotEmptyExpression;
    }

    public void setInsertableColumn(ColumnPredicate insertableColumn) {
        this.insertableColumn = insertableColumn;
    }

    public void setInsertTableColumnValue(ColumnFunction<String> insertTableColumnValue) {
        this.insertTableColumnValue = insertTableColumnValue;
    }

    public void setUpdateTableColumnValue(ColumnFunction<String> updateTableColumnValue) {
        this.updateTableColumnValue = updateTableColumnValue;
    }

    public void setInsertRowSqlValue(RowColumnStringFunction insertRowSqlValue) {
        this.insertRowSqlValue = insertRowSqlValue;
    }

    public void setDynamicValue(StringPredicate dynamicValue) {
        this.dynamicValue = dynamicValue;
    }

    public void setUpdateRowSqlValue(RowColumnStringFunction updateRowSqlValue) {
        this.updateRowSqlValue = updateRowSqlValue;
    }

    public void setAutoIncrementColumn(ColumnPredicate autoIncrementColumn) {
        this.autoIncrementColumn = autoIncrementColumn;
    }

    public void setInsertSqlType(SqlType insertSqlType) {
        this.insertSqlType = insertSqlType;
    }

    public void setUpdateSqlType(SqlType updateSqlType) {
        this.updateSqlType = updateSqlType;
    }

    public void setDeleteSqlType(SqlType deleteSqlType) {
        this.deleteSqlType = deleteSqlType;
    }

    public void setTruncateSqlType(SqlType truncateSqlType) {
        this.truncateSqlType = truncateSqlType;
    }

    public void setLockMode(Function<Table, TableLockMode> lockMode) {
        this.lockMode = lockMode;
    }

    public void setColumnComment(ColumnFunction<String> columnComment) {
        this.columnComment = columnComment;
    }

    public void setSelectColumnComment(ColumnFunction<String> selectColumnComment) {
        this.selectColumnComment = selectColumnComment;
    }

    public void setInsertColumnComment(ColumnFunction<String> insertColumnComment) {
        this.insertColumnComment = insertColumnComment;
    }

    public void setUpdateColumnComment(ColumnFunction<String> updateColumnComment) {
        this.updateColumnComment = updateColumnComment;
    }

    public void setWhereColumnComment(ColumnFunction<String> whereColumnComment) {
        this.whereColumnComment = whereColumnComment;
    }

    public void setTableComment(TableFunction<String> tableComment) {
        this.tableComment = tableComment;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableOptions)) {
            return false;
        }
        TableOptions other = (TableOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TablePredicate this$withForeignKeyConstraint = this.getWithForeignKeyConstraint();
        TablePredicate other$withForeignKeyConstraint = other.getWithForeignKeyConstraint();
        if (this$withForeignKeyConstraint == null ? other$withForeignKeyConstraint != null : !this$withForeignKeyConstraint.equals(other$withForeignKeyConstraint)) {
            return false;
        }
        TablePredicate this$withUniqueConstraint = this.getWithUniqueConstraint();
        TablePredicate other$withUniqueConstraint = other.getWithUniqueConstraint();
        if (this$withUniqueConstraint == null ? other$withUniqueConstraint != null : !this$withUniqueConstraint.equals(other$withUniqueConstraint)) {
            return false;
        }
        TableBiPredicate<Index> this$onlineIndex = this.getOnlineIndex();
        TableBiPredicate<Index> other$onlineIndex = other.getOnlineIndex();
        if (this$onlineIndex == null ? other$onlineIndex != null : !this$onlineIndex.equals(other$onlineIndex)) {
            return false;
        }
        TablePredicate this$withCheckConstraint = this.getWithCheckConstraint();
        TablePredicate other$withCheckConstraint = other.getWithCheckConstraint();
        if (this$withCheckConstraint == null ? other$withCheckConstraint != null : !this$withCheckConstraint.equals(other$withCheckConstraint)) {
            return false;
        }
        TablePredicate this$withExcludeConstraint = this.getWithExcludeConstraint();
        TablePredicate other$withExcludeConstraint = other.getWithExcludeConstraint();
        if (this$withExcludeConstraint == null ? other$withExcludeConstraint != null : !this$withExcludeConstraint.equals(other$withExcludeConstraint)) {
            return false;
        }
        TablePredicate this$allowDropPartition = this.getAllowDropPartition();
        TablePredicate other$allowDropPartition = other.getAllowDropPartition();
        if (this$allowDropPartition == null ? other$allowDropPartition != null : !this$allowDropPartition.equals(other$allowDropPartition)) {
            return false;
        }
        TablePredicate this$allowAddPartition = this.getAllowAddPartition();
        TablePredicate other$allowAddPartition = other.getAllowAddPartition();
        if (this$allowAddPartition == null ? other$allowAddPartition != null : !this$allowAddPartition.equals(other$allowAddPartition)) {
            return false;
        }
        TablePredicate this$commitPerTable = this.getCommitPerTable();
        TablePredicate other$commitPerTable = other.getCommitPerTable();
        if (this$commitPerTable == null ? other$commitPerTable != null : !this$commitPerTable.equals(other$commitPerTable)) {
            return false;
        }
        ColumnStringFunction this$parameterExpression = this.getParameterExpression();
        ColumnStringFunction other$parameterExpression = other.getParameterExpression();
        if (this$parameterExpression == null ? other$parameterExpression != null : !this$parameterExpression.equals(other$parameterExpression)) {
            return false;
        }
        SerializableFunction<String, String> this$ifStartExpression = this.getIfStartExpression();
        SerializableFunction<String, String> other$ifStartExpression = other.getIfStartExpression();
        if (this$ifStartExpression == null ? other$ifStartExpression != null : !this$ifStartExpression.equals(other$ifStartExpression)) {
            return false;
        }
        SerializableFunction<String, String> this$isNotEmptyExpression = this.getIsNotEmptyExpression();
        SerializableFunction<String, String> other$isNotEmptyExpression = other.getIsNotEmptyExpression();
        if (this$isNotEmptyExpression == null ? other$isNotEmptyExpression != null : !this$isNotEmptyExpression.equals(other$isNotEmptyExpression)) {
            return false;
        }
        StringSupplier this$endIfExpression = this.getEndIfExpression();
        StringSupplier other$endIfExpression = other.getEndIfExpression();
        if (this$endIfExpression == null ? other$endIfExpression != null : !this$endIfExpression.equals(other$endIfExpression)) {
            return false;
        }
        SerializablePredicate<SqlType> this$commitPerSqlType = this.getCommitPerSqlType();
        SerializablePredicate<SqlType> other$commitPerSqlType = other.getCommitPerSqlType();
        if (this$commitPerSqlType == null ? other$commitPerSqlType != null : !this$commitPerSqlType.equals(other$commitPerSqlType)) {
            return false;
        }
        TablePredicate this$mergeAllWithDelete = this.getMergeAllWithDelete();
        TablePredicate other$mergeAllWithDelete = other.getMergeAllWithDelete();
        if (this$mergeAllWithDelete == null ? other$mergeAllWithDelete != null : !this$mergeAllWithDelete.equals(other$mergeAllWithDelete)) {
            return false;
        }
        TableIntegerFunction this$dmlBatchSize = this.getDmlBatchSize();
        TableIntegerFunction other$dmlBatchSize = other.getDmlBatchSize();
        if (this$dmlBatchSize == null ? other$dmlBatchSize != null : !this$dmlBatchSize.equals(other$dmlBatchSize)) {
            return false;
        }
        TableStringFunction this$temporaryAlias = this.getTemporaryAlias();
        TableStringFunction other$temporaryAlias = other.getTemporaryAlias();
        if (this$temporaryAlias == null ? other$temporaryAlias != null : !this$temporaryAlias.equals(other$temporaryAlias)) {
            return false;
        }
        ColumnPredicate this$createdAtColumn = this.getCreatedAtColumn();
        ColumnPredicate other$createdAtColumn = other.getCreatedAtColumn();
        if (this$createdAtColumn == null ? other$createdAtColumn != null : !this$createdAtColumn.equals(other$createdAtColumn)) {
            return false;
        }
        ColumnPredicate this$updatedAtColumn = this.getUpdatedAtColumn();
        ColumnPredicate other$updatedAtColumn = other.getUpdatedAtColumn();
        if (this$updatedAtColumn == null ? other$updatedAtColumn != null : !this$updatedAtColumn.equals(other$updatedAtColumn)) {
            return false;
        }
        ColumnPredicate this$optimisticLockColumn = this.getOptimisticLockColumn();
        ColumnPredicate other$optimisticLockColumn = other.getOptimisticLockColumn();
        if (this$optimisticLockColumn == null ? other$optimisticLockColumn != null : !this$optimisticLockColumn.equals(other$optimisticLockColumn)) {
            return false;
        }
        ColumnPredicate this$insertableColumn = this.getInsertableColumn();
        ColumnPredicate other$insertableColumn = other.getInsertableColumn();
        if (this$insertableColumn == null ? other$insertableColumn != null : !this$insertableColumn.equals(other$insertableColumn)) {
            return false;
        }
        ColumnPredicate this$updateableColumn = this.getUpdateableColumn();
        ColumnPredicate other$updateableColumn = other.getUpdateableColumn();
        if (this$updateableColumn == null ? other$updateableColumn != null : !this$updateableColumn.equals(other$updateableColumn)) {
            return false;
        }
        ColumnFunction<String> this$insertTableColumnValue = this.getInsertTableColumnValue();
        ColumnFunction<String> other$insertTableColumnValue = other.getInsertTableColumnValue();
        if (this$insertTableColumnValue == null ? other$insertTableColumnValue != null : !this$insertTableColumnValue.equals(other$insertTableColumnValue)) {
            return false;
        }
        ColumnFunction<String> this$updateTableColumnValue = this.getUpdateTableColumnValue();
        ColumnFunction<String> other$updateTableColumnValue = other.getUpdateTableColumnValue();
        if (this$updateTableColumnValue == null ? other$updateTableColumnValue != null : !this$updateTableColumnValue.equals(other$updateTableColumnValue)) {
            return false;
        }
        RowColumnStringFunction this$insertRowSqlValue = this.getInsertRowSqlValue();
        RowColumnStringFunction other$insertRowSqlValue = other.getInsertRowSqlValue();
        if (this$insertRowSqlValue == null ? other$insertRowSqlValue != null : !this$insertRowSqlValue.equals(other$insertRowSqlValue)) {
            return false;
        }
        StringPredicate this$dynamicValue = this.getDynamicValue();
        StringPredicate other$dynamicValue = other.getDynamicValue();
        if (this$dynamicValue == null ? other$dynamicValue != null : !this$dynamicValue.equals(other$dynamicValue)) {
            return false;
        }
        RowColumnStringFunction this$updateRowSqlValue = this.getUpdateRowSqlValue();
        RowColumnStringFunction other$updateRowSqlValue = other.getUpdateRowSqlValue();
        if (this$updateRowSqlValue == null ? other$updateRowSqlValue != null : !this$updateRowSqlValue.equals(other$updateRowSqlValue)) {
            return false;
        }
        ColumnPredicate this$withCoalesceAtInsert = this.getWithCoalesceAtInsert();
        ColumnPredicate other$withCoalesceAtInsert = other.getWithCoalesceAtInsert();
        if (this$withCoalesceAtInsert == null ? other$withCoalesceAtInsert != null : !this$withCoalesceAtInsert.equals(other$withCoalesceAtInsert)) {
            return false;
        }
        TableStringFunction this$tempTableName = this.getTempTableName();
        TableStringFunction other$tempTableName = other.getTempTableName();
        if (this$tempTableName == null ? other$tempTableName != null : !this$tempTableName.equals(other$tempTableName)) {
            return false;
        }
        ColumnPredicate this$withColumnRemarks = this.getWithColumnRemarks();
        ColumnPredicate other$withColumnRemarks = other.getWithColumnRemarks();
        if (this$withColumnRemarks == null ? other$withColumnRemarks != null : !this$withColumnRemarks.equals(other$withColumnRemarks)) {
            return false;
        }
        TablePredicate this$selectAllColumnASAsterisk = this.getSelectAllColumnASAsterisk();
        TablePredicate other$selectAllColumnASAsterisk = other.getSelectAllColumnASAsterisk();
        if (this$selectAllColumnASAsterisk == null ? other$selectAllColumnASAsterisk != null : !this$selectAllColumnASAsterisk.equals(other$selectAllColumnASAsterisk)) {
            return false;
        }
        ColumnPredicate this$withCoalesceAtUpdate = this.getWithCoalesceAtUpdate();
        ColumnPredicate other$withCoalesceAtUpdate = other.getWithCoalesceAtUpdate();
        if (this$withCoalesceAtUpdate == null ? other$withCoalesceAtUpdate != null : !this$withCoalesceAtUpdate.equals(other$withCoalesceAtUpdate)) {
            return false;
        }
        ColumnPredicate this$autoIncrementColumn = this.getAutoIncrementColumn();
        ColumnPredicate other$autoIncrementColumn = other.getAutoIncrementColumn();
        if (this$autoIncrementColumn == null ? other$autoIncrementColumn != null : !this$autoIncrementColumn.equals(other$autoIncrementColumn)) {
            return false;
        }
        TableSqlBuilder<AbstractSqlBuilder<?>> this$selectAllCondition = this.getSelectAllCondition();
        TableSqlBuilder<AbstractSqlBuilder<?>> other$selectAllCondition = other.getSelectAllCondition();
        if (this$selectAllCondition == null ? other$selectAllCondition != null : !this$selectAllCondition.equals(other$selectAllCondition)) {
            return false;
        }
        TableSqlBuilder<AbstractSqlBuilder<?>> this$updateAllCondition = this.getUpdateAllCondition();
        TableSqlBuilder<AbstractSqlBuilder<?>> other$updateAllCondition = other.getUpdateAllCondition();
        if (this$updateAllCondition == null ? other$updateAllCondition != null : !this$updateAllCondition.equals(other$updateAllCondition)) {
            return false;
        }
        TableSqlBuilder<AbstractSqlBuilder<?>> this$deleteAllCondition = this.getDeleteAllCondition();
        TableSqlBuilder<AbstractSqlBuilder<?>> other$deleteAllCondition = other.getDeleteAllCondition();
        if (this$deleteAllCondition == null ? other$deleteAllCondition != null : !this$deleteAllCondition.equals(other$deleteAllCondition)) {
            return false;
        }
        SqlType this$insertSqlType = this.getInsertSqlType();
        SqlType other$insertSqlType = other.getInsertSqlType();
        if (this$insertSqlType == null ? other$insertSqlType != null : !((Object)((Object)this$insertSqlType)).equals((Object)other$insertSqlType)) {
            return false;
        }
        SqlType this$updateSqlType = this.getUpdateSqlType();
        SqlType other$updateSqlType = other.getUpdateSqlType();
        if (this$updateSqlType == null ? other$updateSqlType != null : !((Object)((Object)this$updateSqlType)).equals((Object)other$updateSqlType)) {
            return false;
        }
        SqlType this$deleteSqlType = this.getDeleteSqlType();
        SqlType other$deleteSqlType = other.getDeleteSqlType();
        if (this$deleteSqlType == null ? other$deleteSqlType != null : !((Object)((Object)this$deleteSqlType)).equals((Object)other$deleteSqlType)) {
            return false;
        }
        SqlType this$truncateSqlType = this.getTruncateSqlType();
        SqlType other$truncateSqlType = other.getTruncateSqlType();
        if (this$truncateSqlType == null ? other$truncateSqlType != null : !((Object)((Object)this$truncateSqlType)).equals((Object)other$truncateSqlType)) {
            return false;
        }
        Function<Table, TableLockMode> this$lockMode = this.getLockMode();
        Function<Table, TableLockMode> other$lockMode = other.getLockMode();
        if (this$lockMode == null ? other$lockMode != null : !this$lockMode.equals(other$lockMode)) {
            return false;
        }
        ColumnFunction<String> this$columnComment = this.getColumnComment();
        ColumnFunction<String> other$columnComment = other.getColumnComment();
        if (this$columnComment == null ? other$columnComment != null : !this$columnComment.equals(other$columnComment)) {
            return false;
        }
        ColumnFunction<String> this$selectColumnComment = this.getSelectColumnComment();
        ColumnFunction<String> other$selectColumnComment = other.getSelectColumnComment();
        if (this$selectColumnComment == null ? other$selectColumnComment != null : !this$selectColumnComment.equals(other$selectColumnComment)) {
            return false;
        }
        ColumnFunction<String> this$insertColumnComment = this.getInsertColumnComment();
        ColumnFunction<String> other$insertColumnComment = other.getInsertColumnComment();
        if (this$insertColumnComment == null ? other$insertColumnComment != null : !this$insertColumnComment.equals(other$insertColumnComment)) {
            return false;
        }
        ColumnFunction<String> this$updateColumnComment = this.getUpdateColumnComment();
        ColumnFunction<String> other$updateColumnComment = other.getUpdateColumnComment();
        if (this$updateColumnComment == null ? other$updateColumnComment != null : !this$updateColumnComment.equals(other$updateColumnComment)) {
            return false;
        }
        ColumnFunction<String> this$whereColumnComment = this.getWhereColumnComment();
        ColumnFunction<String> other$whereColumnComment = other.getWhereColumnComment();
        if (this$whereColumnComment == null ? other$whereColumnComment != null : !this$whereColumnComment.equals(other$whereColumnComment)) {
            return false;
        }
        TableFunction<String> this$tableComment = this.getTableComment();
        TableFunction<String> other$tableComment = other.getTableComment();
        return !(this$tableComment == null ? other$tableComment != null : !this$tableComment.equals(other$tableComment));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TableOptions;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        TablePredicate $withForeignKeyConstraint = this.getWithForeignKeyConstraint();
        result = result * 59 + ($withForeignKeyConstraint == null ? 43 : $withForeignKeyConstraint.hashCode());
        TablePredicate $withUniqueConstraint = this.getWithUniqueConstraint();
        result = result * 59 + ($withUniqueConstraint == null ? 43 : $withUniqueConstraint.hashCode());
        TableBiPredicate<Index> $onlineIndex = this.getOnlineIndex();
        result = result * 59 + ($onlineIndex == null ? 43 : $onlineIndex.hashCode());
        TablePredicate $withCheckConstraint = this.getWithCheckConstraint();
        result = result * 59 + ($withCheckConstraint == null ? 43 : $withCheckConstraint.hashCode());
        TablePredicate $withExcludeConstraint = this.getWithExcludeConstraint();
        result = result * 59 + ($withExcludeConstraint == null ? 43 : $withExcludeConstraint.hashCode());
        TablePredicate $allowDropPartition = this.getAllowDropPartition();
        result = result * 59 + ($allowDropPartition == null ? 43 : $allowDropPartition.hashCode());
        TablePredicate $allowAddPartition = this.getAllowAddPartition();
        result = result * 59 + ($allowAddPartition == null ? 43 : $allowAddPartition.hashCode());
        TablePredicate $commitPerTable = this.getCommitPerTable();
        result = result * 59 + ($commitPerTable == null ? 43 : $commitPerTable.hashCode());
        ColumnStringFunction $parameterExpression = this.getParameterExpression();
        result = result * 59 + ($parameterExpression == null ? 43 : $parameterExpression.hashCode());
        SerializableFunction<String, String> $ifStartExpression = this.getIfStartExpression();
        result = result * 59 + ($ifStartExpression == null ? 43 : $ifStartExpression.hashCode());
        SerializableFunction<String, String> $isNotEmptyExpression = this.getIsNotEmptyExpression();
        result = result * 59 + ($isNotEmptyExpression == null ? 43 : $isNotEmptyExpression.hashCode());
        StringSupplier $endIfExpression = this.getEndIfExpression();
        result = result * 59 + ($endIfExpression == null ? 43 : $endIfExpression.hashCode());
        SerializablePredicate<SqlType> $commitPerSqlType = this.getCommitPerSqlType();
        result = result * 59 + ($commitPerSqlType == null ? 43 : $commitPerSqlType.hashCode());
        TablePredicate $mergeAllWithDelete = this.getMergeAllWithDelete();
        result = result * 59 + ($mergeAllWithDelete == null ? 43 : $mergeAllWithDelete.hashCode());
        TableIntegerFunction $dmlBatchSize = this.getDmlBatchSize();
        result = result * 59 + ($dmlBatchSize == null ? 43 : $dmlBatchSize.hashCode());
        TableStringFunction $temporaryAlias = this.getTemporaryAlias();
        result = result * 59 + ($temporaryAlias == null ? 43 : $temporaryAlias.hashCode());
        ColumnPredicate $createdAtColumn = this.getCreatedAtColumn();
        result = result * 59 + ($createdAtColumn == null ? 43 : $createdAtColumn.hashCode());
        ColumnPredicate $updatedAtColumn = this.getUpdatedAtColumn();
        result = result * 59 + ($updatedAtColumn == null ? 43 : $updatedAtColumn.hashCode());
        ColumnPredicate $optimisticLockColumn = this.getOptimisticLockColumn();
        result = result * 59 + ($optimisticLockColumn == null ? 43 : $optimisticLockColumn.hashCode());
        ColumnPredicate $insertableColumn = this.getInsertableColumn();
        result = result * 59 + ($insertableColumn == null ? 43 : $insertableColumn.hashCode());
        ColumnPredicate $updateableColumn = this.getUpdateableColumn();
        result = result * 59 + ($updateableColumn == null ? 43 : $updateableColumn.hashCode());
        ColumnFunction<String> $insertTableColumnValue = this.getInsertTableColumnValue();
        result = result * 59 + ($insertTableColumnValue == null ? 43 : $insertTableColumnValue.hashCode());
        ColumnFunction<String> $updateTableColumnValue = this.getUpdateTableColumnValue();
        result = result * 59 + ($updateTableColumnValue == null ? 43 : $updateTableColumnValue.hashCode());
        RowColumnStringFunction $insertRowSqlValue = this.getInsertRowSqlValue();
        result = result * 59 + ($insertRowSqlValue == null ? 43 : $insertRowSqlValue.hashCode());
        StringPredicate $dynamicValue = this.getDynamicValue();
        result = result * 59 + ($dynamicValue == null ? 43 : $dynamicValue.hashCode());
        RowColumnStringFunction $updateRowSqlValue = this.getUpdateRowSqlValue();
        result = result * 59 + ($updateRowSqlValue == null ? 43 : $updateRowSqlValue.hashCode());
        ColumnPredicate $withCoalesceAtInsert = this.getWithCoalesceAtInsert();
        result = result * 59 + ($withCoalesceAtInsert == null ? 43 : $withCoalesceAtInsert.hashCode());
        TableStringFunction $tempTableName = this.getTempTableName();
        result = result * 59 + ($tempTableName == null ? 43 : $tempTableName.hashCode());
        ColumnPredicate $withColumnRemarks = this.getWithColumnRemarks();
        result = result * 59 + ($withColumnRemarks == null ? 43 : $withColumnRemarks.hashCode());
        TablePredicate $selectAllColumnASAsterisk = this.getSelectAllColumnASAsterisk();
        result = result * 59 + ($selectAllColumnASAsterisk == null ? 43 : $selectAllColumnASAsterisk.hashCode());
        ColumnPredicate $withCoalesceAtUpdate = this.getWithCoalesceAtUpdate();
        result = result * 59 + ($withCoalesceAtUpdate == null ? 43 : $withCoalesceAtUpdate.hashCode());
        ColumnPredicate $autoIncrementColumn = this.getAutoIncrementColumn();
        result = result * 59 + ($autoIncrementColumn == null ? 43 : $autoIncrementColumn.hashCode());
        TableSqlBuilder<AbstractSqlBuilder<?>> $selectAllCondition = this.getSelectAllCondition();
        result = result * 59 + ($selectAllCondition == null ? 43 : $selectAllCondition.hashCode());
        TableSqlBuilder<AbstractSqlBuilder<?>> $updateAllCondition = this.getUpdateAllCondition();
        result = result * 59 + ($updateAllCondition == null ? 43 : $updateAllCondition.hashCode());
        TableSqlBuilder<AbstractSqlBuilder<?>> $deleteAllCondition = this.getDeleteAllCondition();
        result = result * 59 + ($deleteAllCondition == null ? 43 : $deleteAllCondition.hashCode());
        SqlType $insertSqlType = this.getInsertSqlType();
        result = result * 59 + ($insertSqlType == null ? 43 : ((Object)((Object)$insertSqlType)).hashCode());
        SqlType $updateSqlType = this.getUpdateSqlType();
        result = result * 59 + ($updateSqlType == null ? 43 : ((Object)((Object)$updateSqlType)).hashCode());
        SqlType $deleteSqlType = this.getDeleteSqlType();
        result = result * 59 + ($deleteSqlType == null ? 43 : ((Object)((Object)$deleteSqlType)).hashCode());
        SqlType $truncateSqlType = this.getTruncateSqlType();
        result = result * 59 + ($truncateSqlType == null ? 43 : ((Object)((Object)$truncateSqlType)).hashCode());
        Function<Table, TableLockMode> $lockMode = this.getLockMode();
        result = result * 59 + ($lockMode == null ? 43 : $lockMode.hashCode());
        ColumnFunction<String> $columnComment = this.getColumnComment();
        result = result * 59 + ($columnComment == null ? 43 : $columnComment.hashCode());
        ColumnFunction<String> $selectColumnComment = this.getSelectColumnComment();
        result = result * 59 + ($selectColumnComment == null ? 43 : $selectColumnComment.hashCode());
        ColumnFunction<String> $insertColumnComment = this.getInsertColumnComment();
        result = result * 59 + ($insertColumnComment == null ? 43 : $insertColumnComment.hashCode());
        ColumnFunction<String> $updateColumnComment = this.getUpdateColumnComment();
        result = result * 59 + ($updateColumnComment == null ? 43 : $updateColumnComment.hashCode());
        ColumnFunction<String> $whereColumnComment = this.getWhereColumnComment();
        result = result * 59 + ($whereColumnComment == null ? 43 : $whereColumnComment.hashCode());
        TableFunction<String> $tableComment = this.getTableComment();
        result = result * 59 + ($tableComment == null ? 43 : $tableComment.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "TableOptions(super=" + super.toString() + ", withForeignKeyConstraint=" + this.getWithForeignKeyConstraint() + ", withUniqueConstraint=" + this.getWithUniqueConstraint() + ", onlineIndex=" + this.getOnlineIndex() + ", withCheckConstraint=" + this.getWithCheckConstraint() + ", withExcludeConstraint=" + this.getWithExcludeConstraint() + ", allowDropPartition=" + this.getAllowDropPartition() + ", allowAddPartition=" + this.getAllowAddPartition() + ", commitPerTable=" + this.getCommitPerTable() + ", parameterExpression=" + this.getParameterExpression() + ", ifStartExpression=" + this.getIfStartExpression() + ", isNotEmptyExpression=" + this.getIsNotEmptyExpression() + ", endIfExpression=" + this.getEndIfExpression() + ", commitPerSqlType=" + this.getCommitPerSqlType() + ", mergeAllWithDelete=" + this.getMergeAllWithDelete() + ", dmlBatchSize=" + this.getDmlBatchSize() + ", temporaryAlias=" + this.getTemporaryAlias() + ", createdAtColumn=" + this.getCreatedAtColumn() + ", updatedAtColumn=" + this.getUpdatedAtColumn() + ", optimisticLockColumn=" + this.getOptimisticLockColumn() + ", insertableColumn=" + this.getInsertableColumn() + ", updateableColumn=" + this.getUpdateableColumn() + ", insertTableColumnValue=" + this.getInsertTableColumnValue() + ", updateTableColumnValue=" + this.getUpdateTableColumnValue() + ", insertRowSqlValue=" + this.getInsertRowSqlValue() + ", dynamicValue=" + this.getDynamicValue() + ", updateRowSqlValue=" + this.getUpdateRowSqlValue() + ", withCoalesceAtInsert=" + this.getWithCoalesceAtInsert() + ", tempTableName=" + this.getTempTableName() + ", withColumnRemarks=" + this.getWithColumnRemarks() + ", selectAllColumnASAsterisk=" + this.getSelectAllColumnASAsterisk() + ", withCoalesceAtUpdate=" + this.getWithCoalesceAtUpdate() + ", autoIncrementColumn=" + this.getAutoIncrementColumn() + ", selectAllCondition=" + this.getSelectAllCondition() + ", updateAllCondition=" + this.getUpdateAllCondition() + ", deleteAllCondition=" + this.getDeleteAllCondition() + ", insertSqlType=" + this.getInsertSqlType() + ", updateSqlType=" + this.getUpdateSqlType() + ", deleteSqlType=" + this.getDeleteSqlType() + ", truncateSqlType=" + this.getTruncateSqlType() + ", lockMode=" + this.getLockMode() + ", columnComment=" + this.getColumnComment() + ", selectColumnComment=" + this.getSelectColumnComment() + ", insertColumnComment=" + this.getInsertColumnComment() + ", updateColumnComment=" + this.getUpdateColumnComment() + ", whereColumnComment=" + this.getWhereColumnComment() + ", tableComment=" + this.getTableComment() + ")";
    }
}

