/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.interval;

import com.sqlapp.data.interval.Interval;
import com.sqlapp.data.interval.IntervalDayToSecond;
import com.sqlapp.util.CommonUtils;

public class IntervalDayToMinute
extends IntervalDayToSecond {
    private static final long serialVersionUID = -607286796441334304L;

    public IntervalDayToMinute() {
    }

    private IntervalDayToMinute(int days, int hours, int minutes, double seconds) {
        super(days, hours, minutes, seconds);
    }

    private IntervalDayToMinute(int days, int hours, int minutes, int seconds) {
        super(days, hours, minutes, seconds, 0L);
    }

    public IntervalDayToMinute(int days, int hours, int minutes) {
        super(days, hours, minutes, 0, 0L);
    }

    public static IntervalDayToMinute toDayToMinuteType(Interval interval) {
        if (interval == null) {
            return null;
        }
        IntervalDayToMinute result = new IntervalDayToMinute(interval.getDays(), interval.getHours(), interval.getMinutes());
        if (!interval.isPositive()) {
            result.scale(-1);
        }
        return result;
    }

    public static IntervalDayToMinute parse(String val) {
        if (CommonUtils.isEmpty(val)) {
            return null;
        }
        Interval interval = Interval.parseDetail(val);
        if (interval == null) {
            interval = Interval.parse(val, "DAY", "MINUTE");
        }
        return IntervalDayToMinute.toDayToMinuteType(interval);
    }

    @Override
    public void setSeconds(int seconds) {
        super.setSeconds(this.truncate(seconds, 60));
    }

    @Override
    public void setSeconds(double seconds) {
        this.setSeconds((int)seconds);
    }

    @Override
    public void setNanos(int nanos) {
        super.setNanos(0);
    }

    @Override
    public void setNanos(long nanos) {
        super.setNanos(0);
    }

    @Override
    public IntervalDayToMinute clone() {
        return (IntervalDayToMinute)super.clone();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("");
        if (!this.isPositive()) {
            builder.append("-");
        }
        builder.append(this.getDays());
        builder.append(" ");
        builder.append(this.getHours());
        builder.append(":");
        builder.append(this.getMinutes());
        return builder.toString();
    }
}

