/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.interval;

import com.sqlapp.data.interval.Interval;
import com.sqlapp.util.CommonUtils;

public class IntervalDayToSecond
extends Interval {
    private static final long serialVersionUID = -6661727596902448239L;

    public IntervalDayToSecond() {
    }

    private IntervalDayToSecond(int years, int months, int days, int hours, int minutes, int seconds, long nanos) {
        super(years, months, days, hours, minutes, seconds, nanos);
    }

    private IntervalDayToSecond(int years, int months, int days, int hours, int minutes, double seconds) {
        super(years, months, days, hours, minutes, seconds);
    }

    private IntervalDayToSecond(int years, int months, int days, int hours, int minutes, int seconds) {
        super(years, months, days, hours, minutes, seconds, 0L);
    }

    public IntervalDayToSecond(int days, int hours, int minutes, int seconds, long nanos) {
        super(0, 0, days, hours, minutes, seconds, nanos);
    }

    public IntervalDayToSecond(int days, int hours, int minutes, double seconds) {
        super(0, 0, days, hours, minutes, seconds);
    }

    public IntervalDayToSecond(int days, int hours, int minutes, int seconds) {
        super(0, 0, days, hours, minutes, seconds, 0L);
    }

    public static IntervalDayToSecond toDayToSecondType(Interval interval) {
        if (interval == null) {
            return null;
        }
        IntervalDayToSecond result = new IntervalDayToSecond(interval.getDays(), interval.getHours(), interval.getMinutes(), interval.getSeconds(), interval.getNanos());
        if (!interval.isPositive()) {
            result.scale(-1);
        }
        return result;
    }

    public static IntervalDayToSecond parse(String val) {
        if (CommonUtils.isEmpty(val)) {
            return null;
        }
        Interval interval = Interval.parseDetail(val);
        if (interval == null) {
            interval = Interval.parse(val, "DAY", "SECOND");
        }
        return IntervalDayToSecond.toDayToSecondType(interval);
    }

    @Override
    public void setYears(int years) {
    }

    @Override
    public void setYears(double years) {
    }

    @Override
    public void setMonths(int months) {
    }

    @Override
    public IntervalDayToSecond clone() {
        return (IntervalDayToSecond)super.clone();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("");
        if (!this.isPositive()) {
            builder.append("-");
        }
        builder.append(this.getDays());
        builder.append(" ");
        builder.append(this.getHours());
        builder.append(":");
        builder.append(this.getMinutes());
        builder.append(":");
        builder.append(this.getSeconds());
        if (this.getNanos() > 0) {
            builder.append(".");
            builder.append(this.getNanos() / 1000000000);
        }
        return builder.toString();
    }
}

