/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.interval;

import com.sqlapp.data.interval.Interval;
import com.sqlapp.util.CommonUtils;

public final class IntervalYearToDay
extends Interval {
    private static final long serialVersionUID = 5576144904244107604L;

    public IntervalYearToDay() {
    }

    public IntervalYearToDay(int years, int months, int days) {
        super(years, months, days, 0, 0, 0);
    }

    private IntervalYearToDay(int years, int months, int days, int hours, int minutes, int seconds, long nanos) {
        super(years, months, days, hours, minutes, seconds, nanos);
    }

    private IntervalYearToDay(int years, int months, int days, int hours, int minutes, double seconds) {
        super(years, months, days, hours, minutes, seconds);
    }

    private IntervalYearToDay(int years, int months, int days, int hours, int minutes, int seconds) {
        super(years, months, days, hours, minutes, seconds, 0L);
    }

    public static IntervalYearToDay toYearToDayType(Interval interval) {
        if (interval == null) {
            return null;
        }
        IntervalYearToDay result = new IntervalYearToDay(interval.getYears(), interval.getMonths(), interval.getDays());
        if (!interval.isPositive()) {
            result.scale(-1);
        }
        return result;
    }

    public static IntervalYearToDay parse(String val) {
        if (CommonUtils.isEmpty(val)) {
            return null;
        }
        Interval interval = Interval.parseDetail(val);
        if (interval == null) {
            interval = Interval.parse(val, "YEAR", "DAY");
        }
        return IntervalYearToDay.toYearToDayType(interval);
    }

    @Override
    public void setHours(int hours) {
        super.setHours(this.truncate(hours, 24));
    }

    @Override
    public void setHours(double hours) {
        this.setHours((int)hours);
    }

    @Override
    public void setMinutes(int minutes) {
        super.setMinutes(this.truncate(minutes, 1440));
    }

    @Override
    public void setMinutes(double minutes) {
        super.setMinutes(minutes);
    }

    @Override
    public void setSeconds(int seconds) {
        super.setSeconds(this.truncate(seconds, 86400));
    }

    @Override
    public void setSeconds(double seconds) {
        this.setSeconds((int)seconds);
    }

    @Override
    public void setNanos(long nanos) {
        super.setNanos(this.truncate(nanos, -1857093632L));
    }

    @Override
    public IntervalYearToDay clone() {
        return (IntervalYearToDay)super.clone();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("");
        if (!this.isPositive()) {
            builder.append("-");
        }
        builder.append(this.getYears());
        builder.append("-");
        builder.append(this.getMonths());
        builder.append("-");
        builder.append(this.getDays());
        builder.append("");
        return builder.toString();
    }
}

