/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.parameter;

import com.sqlapp.data.AbstractDto;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.HashCodeBuilder;
import com.sqlapp.util.ToStringBuilder;

public class ParameterDefinition
extends AbstractDto {
    private static final long serialVersionUID = -5239717055561918707L;
    public static final String ROW_KEY_PARANETER_NAME = "_row";
    public static final String OFFSET_KEY_PARANETER_NAME = "_offset";
    public static final String COUNTSQL_KEY_PARANETER_NAME = "_countSql";
    public static final String ORDER_BY_KEY_PARANETER_NAME = "_orderBy";
    private String name;
    private String type;

    public ParameterDefinition() {
    }

    public ParameterDefinition(String name) {
        this.name = this.normalize(name);
        this.type = null;
    }

    public ParameterDefinition(String name, String type) {
        this.name = this.normalize(name);
        this.type = type;
    }

    private String normalize(String name) {
        String[] vals;
        for (String val : vals = name.split("[+\\-/*]")) {
            if (CommonUtils.isEmpty(val = CommonUtils.trim(val)) || val.startsWith("'") && val.endsWith("'") || val.startsWith("\"") && val.endsWith("\"")) continue;
            return val;
        }
        return name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    protected void buildToString(ToStringBuilder builder) {
        builder.add("name", this.getName());
        builder.add("type", this.getType());
    }

    @Override
    protected void buildHashCode(HashCodeBuilder builder) {
        builder.append(this.getName());
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ParameterDefinition)) {
            return false;
        }
        ParameterDefinition cst = (ParameterDefinition)ParameterDefinition.class.cast(obj);
        if (!CommonUtils.eq(this.getName(), cst.getName())) {
            return false;
        }
        return CommonUtils.eq(this.getType(), cst.getType());
    }

    @Override
    public ParameterDefinition clone() {
        return (ParameterDefinition)super.clone();
    }
}

