/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractDbObject;
import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.DbObjectCollection;
import com.sqlapp.data.schemas.DbObjectDifference;
import com.sqlapp.data.schemas.DbObjectDifferenceCollection;
import com.sqlapp.data.schemas.Difference;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.HasParent;
import com.sqlapp.data.schemas.Row;
import com.sqlapp.data.schemas.State;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.HashCodeBuilder;
import com.sqlapp.util.ToStringBuilder;
import java.io.Serializable;

public abstract class AbstractDifference<T>
implements Serializable,
Difference<T>,
Comparable<Difference<?>> {
    private static final long serialVersionUID = -200061059583091166L;
    private final T original;
    private final T target;
    private String propertyName = null;
    private State state = State.Unchanged;
    private DbCommonObject<?> originalParent;
    private DbCommonObject<?> targetParent;
    private Difference<?> parentDifference;
    private EqualsHandler equalsHandler;

    protected AbstractDifference(String propertyName, T original, T target, EqualsHandler equalsHandler) {
        this.propertyName = propertyName;
        this.original = original;
        this.target = target;
        if (original instanceof HasParent) {
            this.setOriginalParent((DbCommonObject)((HasParent)original).getParent());
        }
        if (target instanceof HasParent) {
            this.setTargetParent((DbCommonObject)((HasParent)target).getParent());
        }
        this.equalsHandler = equalsHandler;
    }

    protected AbstractDifference(T original, T target, EqualsHandler equalsHandler) {
        this.original = original;
        this.target = target;
        this.equalsHandler = equalsHandler;
    }

    protected AbstractDifference(String propertyName, DbCommonObject<?> originalParent, T original, DbCommonObject<?> targetParent, T target, EqualsHandler equalsHandler) {
        this.propertyName = propertyName;
        this.originalParent = originalParent;
        this.original = original;
        this.targetParent = targetParent;
        this.target = target;
        this.equalsHandler = equalsHandler;
    }

    protected AbstractDifference(DbCommonObject<?> originalParent, T original, DbCommonObject<?> targetParent, T target, EqualsHandler equalsHandler) {
        this.originalParent = originalParent;
        this.original = original;
        this.targetParent = targetParent;
        this.target = target;
        this.equalsHandler = equalsHandler;
    }

    @Override
    public T getOriginal() {
        return this.original;
    }

    @Override
    public T getTarget() {
        return this.target;
    }

    protected void setOriginalParent(DbCommonObject<?> originalParent) {
        this.originalParent = originalParent;
    }

    protected void setTargetParent(DbCommonObject<?> targetParent) {
        this.targetParent = targetParent;
    }

    protected String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public DbCommonObject<?> getOriginalParent() {
        return this.originalParent;
    }

    @Override
    public DbCommonObject<?> getTargetParent() {
        return this.targetParent;
    }

    @Override
    public State getState() {
        return this.state;
    }

    protected EqualsHandler getEqualsHandler() {
        return this.equalsHandler;
    }

    protected void setState(State state) {
        this.state = state;
    }

    protected void setParentDifference(Difference<?> parentDifference) {
        this.parentDifference = parentDifference;
        if (parentDifference != null) {
            this.setOriginalParent((DbCommonObject)parentDifference.getOriginal());
            this.setTargetParent((DbCommonObject)parentDifference.getTarget());
        }
    }

    @Override
    public <S extends Difference<?>> S getParentDifference() {
        return (S)this.parentDifference;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append(this.original);
        builder.append(this.originalParent);
        builder.append(this.target);
        builder.append(this.targetParent);
        return builder.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractDifference)) {
            return false;
        }
        AbstractDifference cst = (AbstractDifference)obj;
        if (this.original != cst.original) {
            return false;
        }
        if (this.originalParent != cst.originalParent) {
            return false;
        }
        if (this.target != cst.target) {
            return false;
        }
        if (this.targetParent != cst.targetParent) {
            return false;
        }
        return this.state == cst.state;
    }

    public String toString() {
        if (this.state == State.Unchanged) {
            return "";
        }
        ToStringBuilder builder = new ToStringBuilder();
        builder.setOpenQuate("").setCloseQuate("").setSeparator("\n");
        this.toString(builder);
        return builder.toString();
    }

    protected abstract void toString(ToStringBuilder var1);

    protected static boolean isDbObject(Object ... args) {
        for (Object obj : args) {
            if (!(obj instanceof DbCommonObject)) continue;
            return true;
        }
        return false;
    }

    protected static boolean isDbObjectCollection(Object ... args) {
        for (Object obj : args) {
            if (!(obj instanceof DbObjectCollection)) continue;
            return true;
        }
        return false;
    }

    protected abstract void diff();

    @Override
    public DbObjectDifference toDifference() {
        return (DbObjectDifference)this;
    }

    @Override
    public DbObjectDifferenceCollection toDifferenceCollection() {
        return (DbObjectDifferenceCollection)this;
    }

    protected int getLevel() {
        return this.level(this, 0);
    }

    private int level(Difference<?> difference, int level) {
        if (difference == null) {
            return level;
        }
        if (difference.getParentDifference() == null || difference.getParentDifference() == this) {
            return level;
        }
        if (difference.getParentDifference() instanceof DbObjectDifferenceCollection) {
            return this.level((Difference<?>)difference.getParentDifference(), level);
        }
        return this.level((Difference<?>)difference.getParentDifference(), level + 1);
    }

    protected String getStateText(State state) {
        if (state == null) {
            return " ";
        }
        switch (state) {
            case Added: {
                return "+";
            }
            case Modified: {
                return "C";
            }
            case Deleted: {
                return "-";
            }
        }
        return " ";
    }

    protected String format(State state, Object value) {
        if (value instanceof AbstractDbObject) {
            return this.format(state, (AbstractDbObject)value);
        }
        int indentSize = this.getLevel();
        String indent = CommonUtils.getString('\t', indentSize);
        return "\n" + indent + this.getStateText(state) + ":" + value;
    }

    protected String format(State state, AbstractDbObject<?> value) {
        int indentSize = this.getLevel();
        String indent = CommonUtils.getString('\t', indentSize);
        return "\n" + indent + this.getStateText(state) + ":" + value.toStringSimple();
    }

    protected String getSimpleName(Object obj) {
        if (obj instanceof AbstractDbObject) {
            return ((AbstractDbObject)obj).getSimpleName();
        }
        if (obj instanceof Row) {
            return ((Row)obj).getSimpleName();
        }
        return obj.getClass().getSimpleName();
    }
}

