/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractBaseDbObject;
import com.sqlapp.data.schemas.AbstractBaseDbObjectCollectionXmlReaderHandler;
import com.sqlapp.data.schemas.AbstractDbObject;
import com.sqlapp.data.schemas.AbstractDbObjectCollection;
import com.sqlapp.data.schemas.AbstractNamedObject;
import com.sqlapp.data.schemas.AbstractNamedObjectCollectionXmlReaderHandler;
import com.sqlapp.data.schemas.Catalog;
import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.HasParent;
import com.sqlapp.data.schemas.NewElement;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.data.schemas.properties.CatalogNameProperty;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.util.CaseInsensitiveMap;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.EqualsUtils;
import com.sqlapp.util.SeparatedStringBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractNamedObjectCollection<T extends AbstractNamedObject<? super T>>
extends AbstractDbObjectCollection<T> {
    private static final long serialVersionUID = 4540018510759477211L;
    private transient Map<String, T> nameMap = null;
    private transient Map<String, T> specificNameMap = null;
    private boolean caseSensitive = true;

    protected AbstractNamedObjectCollection() {
    }

    protected AbstractNamedObjectCollection(DbCommonObject<?> parent) {
        super(parent);
    }

    protected AbstractNamedObjectCollection(Catalog catalog) {
        super(catalog);
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        if (this.caseSensitive != caseSensitive) {
            this.renew();
            int size = this.size();
            for (int i = 0; i < size; ++i) {
                ((AbstractNamedObject)this.get(i)).setCaseSensitive(caseSensitive);
            }
        }
        this.caseSensitive = caseSensitive;
    }

    protected Map<String, T> getNameMap() {
        if (this.nameMap == null) {
            this.nameMap = this.caseSensitive ? CommonUtils.map(this.size()) : CommonUtils.caseInsensitiveMap(this.size() * 4 / 3 + 1);
            this.renew();
        }
        return this.nameMap;
    }

    protected Map<String, T> getSpecificNameMap() {
        if (this.specificNameMap == null) {
            this.specificNameMap = this.caseSensitive ? CommonUtils.map(this.size() * 4 / 3 + 1) : new CaseInsensitiveMap(this.size() * 4 / 3 + 1);
            this.renew();
        }
        return this.specificNameMap;
    }

    @Override
    protected void renew() {
        Map<String, T> nameMap = this.getNameMap();
        Map<String, T> specificNameMap = this.getSpecificNameMap();
        nameMap.clear();
        specificNameMap.clear();
        int size = this.inner.size();
        for (int i = 0; i < size; ++i) {
            AbstractNamedObject obj = (AbstractNamedObject)this.inner.get(i);
            obj.setOrdinal(i);
            nameMap.put(obj.getName(), obj);
            specificNameMap.put(obj.getSpecificName(), obj);
        }
    }

    public T get(String name) {
        AbstractNamedObject obj = (AbstractNamedObject)this.getSpecificNameMap().get(name);
        if (obj != null) {
            this.setElementParent(obj);
        } else {
            obj = (AbstractNamedObject)this.getNameMap().get(name);
            if (obj != null) {
                this.setElementParent(obj);
            }
        }
        return (T)obj;
    }

    @Override
    public T find(T obj) {
        AbstractNamedObject ret = (AbstractNamedObject)this.getSpecificNameMap().get(((AbstractNamedObject)obj).getSpecificName());
        if (ret == null) {
            ret = (AbstractNamedObject)this.getNameMap().get(((AbstractNamedObject)obj).getName());
        }
        return (T)ret;
    }

    @Override
    public List<T> find(String name) {
        List result = CommonUtils.list();
        for (int i = 0; i < this.size(); ++i) {
            AbstractNamedObject obj = (AbstractNamedObject)this.get(i);
            if (!this.equalsIgnoreCase(obj.getName(), name)) continue;
            result.add(obj);
        }
        return result;
    }

    public List<T> getAll(String ... names) {
        int size = names.length;
        List list = CommonUtils.list(size);
        for (int i = 0; i < size; ++i) {
            list.add(this.get(names[i]));
        }
        return list;
    }

    public List<T> getAll(List<String> names) {
        int size = names.size();
        List list = CommonUtils.list(size);
        for (int i = 0; i < size; ++i) {
            list.add(this.get(names.get(i)));
        }
        return list;
    }

    public List<T> getAll(Collection<String> names) {
        List list = CommonUtils.list(names.size());
        for (String name : names) {
            T t = this.get(name);
            if (t == null) continue;
            list.add(t);
        }
        return list;
    }

    @Override
    public boolean add(T e) {
        if (!this.getAddDbObjectPredicate().test(this, e)) {
            return false;
        }
        boolean bool = false;
        this.beforeAdd(e);
        this.addSimple(e);
        this.initializeSchemaInfo(e);
        if (this.isValidateAtChange()) {
            this.renew();
        }
        this.afterAdd(e);
        ((AbstractBaseDbObject)e).validate();
        this.validate();
        return bool;
    }

    protected void initializeSchemaInfo(T e) {
        if (this.equalsIgnoreCase(((AbstractDbObject)e).getCatalogName(), this.getCatalogName())) {
            ((AbstractDbObject)e).setCatalogName(null);
        }
    }

    private String getCatalogName() {
        if (this instanceof HasParent) {
            String name;
            HasParent parent = (HasParent)((Object)this);
            if (parent.getParent() == null) {
                return null;
            }
            if (parent.getParent() instanceof CatalogNameProperty && (name = ((CatalogNameProperty)parent.getParent()).getCatalogName()) != null) {
                return name;
            }
        }
        return null;
    }

    protected boolean addSimple(T e) {
        boolean bool = false;
        Object org = null;
        org = ((AbstractNamedObject)e).getSpecificName() == null || CommonUtils.eq(((AbstractNamedObject)e).getName(), ((AbstractNamedObject)e).getSpecificName()) ? (Object)this.get(((AbstractNamedObject)e).getName()) : (Object)this.get(((AbstractNamedObject)e).getSpecificName());
        if (org != null) {
            ((AbstractBaseDbObject)e).cloneProperties(org);
        } else {
            bool = this.inner.add(e);
            this.getNameMap().put(((AbstractNamedObject)e).getName(), e);
            this.getSpecificNameMap().put(((AbstractNamedObject)e).getSpecificName(), e);
        }
        this.setElementParent(e);
        return bool;
    }

    void addSimple(int index, T e) {
        Object org = null;
        org = ((AbstractNamedObject)e).getSpecificName() == null || CommonUtils.eq(((AbstractNamedObject)e).getName(), ((AbstractNamedObject)e).getSpecificName()) ? (Object)this.get(((AbstractNamedObject)e).getName()) : (Object)this.get(((AbstractNamedObject)e).getSpecificName());
        if (org != null) {
            ((AbstractBaseDbObject)e).cloneProperties(org);
        } else {
            this.inner.add(index, e);
        }
        this.setElementParent(e);
    }

    @Override
    public void add(int index, T element) {
        if (!this.getAddDbObjectPredicate().test(this, element)) {
            return;
        }
        this.beforeAdd(element);
        this.addSimple(index, element);
        this.initializeSchemaInfo(element);
        if (this.isValidateAtChange()) {
            this.renew();
        }
        this.afterAdd(element);
        ((AbstractBaseDbObject)element).validate();
        this.validate();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        if (this == c) {
            return false;
        }
        for (AbstractNamedObject t : c) {
            if (!this.getAddDbObjectPredicate().test(this, t)) continue;
            this.beforeAdd(t);
            this.setElementParent(t);
            this.initializeSchemaInfo(t);
        }
        for (AbstractNamedObject t : c) {
            if (!this.getAddDbObjectPredicate().test(this, t)) continue;
            this.addSimple(t);
        }
        this.renew();
        for (AbstractNamedObject t : c) {
            if (!this.getAddDbObjectPredicate().test(this, t)) continue;
            this.afterAdd(t);
        }
        this.validate();
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        for (AbstractNamedObject t : c) {
            if (!this.getAddDbObjectPredicate().test(this, t)) continue;
            this.beforeAdd(t);
            this.setElementParent(t);
            this.initializeSchemaInfo(t);
        }
        for (AbstractNamedObject t : c) {
            if (!this.getAddDbObjectPredicate().test(this, t)) continue;
            this.addSimple(t);
        }
        this.renew();
        for (AbstractNamedObject t : c) {
            if (!this.getAddDbObjectPredicate().test(this, t)) continue;
            this.afterAdd(t);
        }
        this.validate();
        return true;
    }

    @Override
    public void clear() {
        super.clear();
        this.specificNameMap = null;
        this.nameMap = null;
    }

    public boolean contains(String name) {
        if (this.getSpecificNameMap().containsKey(name)) {
            return true;
        }
        return this.getNameMap().containsKey(name);
    }

    public boolean containsAll(String ... names) {
        for (int i = 0; i < names.length; ++i) {
            if (this.getNameMap().containsKey(names[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> args) {
        for (Object arg : args) {
            if (!(arg instanceof String ? !this.contains((String)arg) : !this.contains((T)((AbstractNamedObject)arg)))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(T o) {
        if (this.getSpecificNameMap().containsKey(((AbstractNamedObject)o).getSpecificName())) {
            return true;
        }
        return this.getNameMap().containsKey(((AbstractNamedObject)o).getName());
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof String) {
            return this.contains((String)o);
        }
        return this.contains((T)((AbstractNamedObject)o));
    }

    public boolean remove(String o) {
        T obj = this.get(o);
        this.beforeRemove(obj);
        boolean bool = this.inner.remove(obj);
        this.renew();
        this.afterRemove(obj);
        return bool;
    }

    public Set<String> getSpecificNames() {
        Set<String> result = CommonUtils.set();
        for (AbstractNamedObject obj : this) {
            result.add(obj.getSpecificName());
        }
        return result;
    }

    public Set<String> getNameSet() {
        return this.getNameMap().keySet();
    }

    public Set<Map.Entry<String, T>> entrySet() {
        return this.getNameMap().entrySet();
    }

    @Override
    public String toString() {
        SeparatedStringBuilder builder = new SeparatedStringBuilder("\n");
        builder.add(this.inner);
        return builder.toString();
    }

    @Override
    public AbstractNamedObjectCollection<T> clone() {
        return (AbstractNamedObjectCollection)CommonUtils.cast(super.clone());
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!(obj instanceof AbstractNamedObjectCollection)) {
            return false;
        }
        if (equalsHandler.referenceEquals(this, obj)) {
            return true;
        }
        if (!(obj instanceof AbstractNamedObjectCollection)) {
            return false;
        }
        AbstractNamedObjectCollection val = (AbstractNamedObjectCollection)obj;
        if (!this.equalsElements(val, equalsHandler)) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    protected boolean equalsElements(AbstractNamedObjectCollection<T> val, EqualsHandler equalsHandler) {
        if (!equalsHandler.valueEquals("size", this, val, this.inner.size(), val.inner.size(), EqualsUtils.getEqualsSupplier(this.inner.size(), val.inner.size()))) {
            return false;
        }
        int size = Math.max(this.size(), val.size());
        Set set = CommonUtils.set();
        for (int i = 0; i < size; ++i) {
            AbstractNamedObject thisObj1 = null;
            if (i < this.size()) {
                thisObj1 = (AbstractNamedObject)this.inner.get(i);
            }
            AbstractNamedObject thisObj2 = null;
            if (thisObj1 != null) {
                thisObj2 = val.find(thisObj1);
            } else if (i < val.size()) {
                thisObj2 = (AbstractNamedObject)val.inner.get(i);
            }
            if (thisObj2 != null) {
                if (set.contains(thisObj2)) continue;
                set.add(thisObj2);
                if (this.equalsElement(thisObj1, thisObj2, equalsHandler)) continue;
                return false;
            }
            if (this.equalsElement(thisObj1, thisObj2, equalsHandler)) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIgnoreCase(String obj1, String obj2) {
        if (this.isCaseSensitive()) {
            return CommonUtils.eq(obj1, obj2);
        }
        return CommonUtils.eqIgnoreCase(obj1, obj2);
    }

    @Override
    protected void setDiffAll(SeparatedStringBuilder builder) {
        SeparatedStringBuilder sepName = new SeparatedStringBuilder(",");
        sepName.setStart("{").setEnd("}");
        sepName.addNames(this);
        builder.add((Object)sepName.toString());
    }

    @Override
    protected void cloneProperties(AbstractNamedObjectCollection<T> obj) {
        int size = this.size();
        obj.caseSensitive = this.caseSensitive;
        for (int i = 0; i < size; ++i) {
            obj.add((AbstractNamedObject)((AbstractNamedObject)this.get(i)).clone());
        }
        Set<ISchemaProperty> properties = SchemaUtils.getAllSchemaProperties(this.getClass());
        for (ISchemaProperty prop : properties) {
            Object value = prop.getCloneValue(this);
            prop.setValue(obj, value);
        }
    }

    @Override
    protected AbstractNamedObjectCollectionXmlReaderHandler<?> getDbObjectXmlReaderHandler() {
        if (this instanceof NewElement) {
            NewElement newElement = (NewElement)((Object)this);
            final AbstractBaseDbObject dbObject = (AbstractBaseDbObject)newElement.newElement();
            return new AbstractNamedObjectCollectionXmlReaderHandler(this.newInstance()){

                @Override
                protected void initializeSetValue() {
                    super.initializeSetValue();
                    ((AbstractBaseDbObjectCollectionXmlReaderHandler)this).setChild(dbObject.getDbObjectXmlReaderHandler());
                }
            };
        }
        return null;
    }
}

