/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.EnumProperties;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum CascadeRule implements EnumProperties
{
    Cascade(0, "CASCADE", "c.*"){

        @Override
        public String getAbbrName() {
            return "CASC";
        }
    }
    ,
    None(3, "NONE", "no.*"),
    SetDefault(4, "SET DEFAULT", ".*default.*"){

        @Override
        public String getAbbrName() {
            return "DEFAULT";
        }
    }
    ,
    SetNull(2, "SET NULL", ".*null.*"){

        @Override
        public String getAbbrName() {
            return "NULL";
        }
    }
    ,
    Restrict(1, "RESTRICT", "r.*"){

        @Override
        public String getAbbrName() {
            return "RESTRICT";
        }

        @Override
        public boolean isRestrict() {
            return true;
        }
    };

    private final int value;
    private final Pattern pattern;
    private final String text;

    private CascadeRule(int value, String text, String patternText) {
        this.value = value;
        this.text = text;
        this.pattern = Pattern.compile(patternText, 2);
    }

    public boolean isRestrict() {
        return false;
    }

    public static CascadeRule parse(int value) {
        for (CascadeRule rule : CascadeRule.values()) {
            if (rule.value != value) continue;
            return rule;
        }
        return null;
    }

    public static CascadeRule parse(String text) {
        if (text == null) {
            return null;
        }
        for (CascadeRule rule : CascadeRule.values()) {
            Matcher matcher = rule.pattern.matcher(text);
            if (!matcher.matches()) continue;
            return rule;
        }
        return null;
    }

    public String getAbbrName() {
        return this.getDisplayName();
    }

    @Override
    public String getDisplayName() {
        return this.text;
    }

    @Override
    public String getDisplayName(Locale locale) {
        return this.text;
    }

    @Override
    public String getSqlValue() {
        return this.text;
    }
}

