/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractSchemaObjectCollection;
import com.sqlapp.data.schemas.CheckConstraint;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.ColumnCollection;
import com.sqlapp.data.schemas.Constraint;
import com.sqlapp.data.schemas.ConstraintCollectionXmlReaderHandler;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.ExcludeConstraint;
import com.sqlapp.data.schemas.ForeignKeyConstraint;
import com.sqlapp.data.schemas.HasParent;
import com.sqlapp.data.schemas.ReferenceColumn;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.UniqueConstraint;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.StaxWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;

public final class ConstraintCollection
extends AbstractSchemaObjectCollection<Constraint>
implements Cloneable,
HasParent<Table> {
    private static final long serialVersionUID = 6835895264159969740L;

    protected ConstraintCollection() {
    }

    protected ConstraintCollection(Table table) {
        super(table);
    }

    @Override
    protected Supplier<ConstraintCollection> newInstance() {
        return () -> new ConstraintCollection();
    }

    @Override
    public ConstraintCollection clone() {
        return (ConstraintCollection)super.clone();
    }

    public UniqueConstraint addPrimaryKeyConstraint(String constraintName, Column ... columns) {
        return this.addUniqueConstraint(constraintName, true, columns);
    }

    public UniqueConstraint addPrimaryKeyConstraint(String constraintName, String ... columnNames) {
        List<Column> columns = CommonUtils.list();
        for (String columnName : columnNames) {
            Column column = (Column)this.getParent().getColumns().get(columnName);
            if (column == null) {
                throw new IllegalArgumentException("columnName=" + columnName);
            }
            columns.add(column);
        }
        return this.addUniqueConstraint(constraintName, true, columns);
    }

    public UniqueConstraint addPrimaryKeyConstraint(String constraintName, Collection<Column> columns) {
        return this.addUniqueConstraint(constraintName, true, columns);
    }

    public UniqueConstraint addUniqueConstraint(String constraintName, boolean primaryKey, Collection<Column> columns) {
        return this.addUniqueConstraint(constraintName, primaryKey, columns.toArray(new Column[0]));
    }

    public UniqueConstraint addUniqueConstraint(String constraintName, boolean primaryKey, Column ... columns) {
        UniqueConstraint uc = new UniqueConstraint(constraintName, primaryKey, columns);
        if (primaryKey) {
            UniqueConstraint pk = this.getPrimaryKeyConstraint();
            if (pk != null) {
                pk.setPrimaryKey(primaryKey);
            }
            for (Column column : columns) {
                column.setNotNull(true);
            }
        }
        this.add(uc);
        return uc;
    }

    public UniqueConstraint addUniqueConstraint(String constraintName, boolean primaryKey, ReferenceColumn ... columns) {
        UniqueConstraint uc = new UniqueConstraint(constraintName, primaryKey, columns);
        if (primaryKey) {
            UniqueConstraint pk = this.getPrimaryKeyConstraint();
            if (pk != null) {
                pk.setPrimaryKey(primaryKey);
            }
            for (ReferenceColumn column : columns) {
                if (column.getColumn() == null) continue;
                column.getColumn().setNotNull(true);
            }
        }
        this.add(uc);
        return uc;
    }

    public UniqueConstraint addUniqueConstraint(String constraintName, Column ... columns) {
        return this.addUniqueConstraint(constraintName, false, columns);
    }

    public UniqueConstraint addUniqueConstraint(String constraintName, ReferenceColumn ... columns) {
        return this.addUniqueConstraint(constraintName, false, columns);
    }

    public UniqueConstraint addUniqueConstraint(String constraintName, Collection<Column> columns) {
        return this.addUniqueConstraint(constraintName, false, columns);
    }

    public CheckConstraint addCheckConstraint(String constraintName, String expression, Column ... columns) {
        CheckConstraint c = new CheckConstraint(constraintName, expression, columns);
        this.add(c);
        return c;
    }

    public CheckConstraint addCheckConstraint(String constraintName, String expression, Collection<Column> columns) {
        return this.addCheckConstraint(constraintName, expression, columns.toArray(new Column[0]));
    }

    public ForeignKeyConstraint addForeignKeyConstraint(String constraintName, Column[] columns, Column[] parentColumns) {
        ForeignKeyConstraint fc = new ForeignKeyConstraint(constraintName, columns, parentColumns);
        this.add(fc);
        return fc;
    }

    public ForeignKeyConstraint addForeignKeyConstraint(String constraintName, Column column, Column parentColumn) {
        ForeignKeyConstraint fc = new ForeignKeyConstraint(constraintName, column, parentColumn);
        this.add(fc);
        return fc;
    }

    public void add(UniqueConstraint uc) {
        super.add(uc);
        if (this.getTable() == null) {
            return;
        }
        uc.setTableName(null);
        this.resetColumns(uc);
        this.sort();
    }

    public void add(ExcludeConstraint uc) {
        super.add(uc);
        if (this.getTable() == null) {
            return;
        }
        uc.setTableName(null);
        this.resetColumns(uc);
        this.sort();
    }

    protected void resetColumns(ExcludeConstraint constraint) {
        constraint.getColumns().setTable(this.getParent());
    }

    protected void resetColumns(UniqueConstraint uc) {
        uc.getColumns().setTable(this.getParent());
    }

    public void add(CheckConstraint cc) {
        super.add(cc);
        if (this.getTable() == null) {
            return;
        }
        this.resetColumns(cc);
        this.sort();
    }

    @Override
    protected void afterAdd(Constraint c) {
        if (c instanceof UniqueConstraint) {
            this.resetColumns((UniqueConstraint)c);
        } else if (c instanceof CheckConstraint) {
            this.resetColumns((CheckConstraint)c);
        } else if (c instanceof ForeignKeyConstraint) {
            ((ForeignKeyConstraint)c).validate();
        } else if (c instanceof ExcludeConstraint) {
            this.resetColumns((ExcludeConstraint)c);
        }
    }

    protected void resetColumns(CheckConstraint cc) {
        if (CommonUtils.size(cc.getColumns()) != 1) {
            cc.setColumns(new Column[0]);
        }
        int size = cc.getColumns().length;
        if (this.getParent() != null) {
            ColumnCollection columns = this.getParent().getColumns();
            for (int i = 0; i < size; ++i) {
                Column orgColumn;
                Column column = cc.getColumns()[i];
                if (column == (orgColumn = (Column)columns.get(column.getName()))) continue;
                cc.getColumns()[i] = orgColumn;
                if (orgColumn == null) continue;
                orgColumn.setCheckConstraint(cc);
            }
        }
    }

    public void add(ForeignKeyConstraint fc) {
        super.add(fc);
        if (this.getTable() == null) {
            return;
        }
        fc.validate();
        this.sort();
    }

    public List<CheckConstraint> getCheckConstraints() {
        return this.getCheckConstraints(c -> true);
    }

    public List<CheckConstraint> getCheckConstraints(Predicate<CheckConstraint> p) {
        List<CheckConstraint> result = CommonUtils.list(this.size());
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            CheckConstraint cc;
            Constraint c = (Constraint)this.get(i);
            if (!(c instanceof CheckConstraint) || !p.test(cc = (CheckConstraint)CommonUtils.cast(c))) continue;
            result.add(cc);
        }
        return result;
    }

    public List<UniqueConstraint> getUniqueConstraints() {
        return this.getUniqueConstraints((UniqueConstraint c) -> true);
    }

    public List<UniqueConstraint> getUniqueConstraints(Predicate<UniqueConstraint> p) {
        List<UniqueConstraint> result = CommonUtils.list(this.size());
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            UniqueConstraint cc;
            Constraint c = (Constraint)this.get(i);
            if (!(c instanceof UniqueConstraint) || !p.test(cc = (UniqueConstraint)CommonUtils.cast(c))) continue;
            result.add(cc);
        }
        return result;
    }

    public List<UniqueConstraint> getUniqueConstraints(Column ... columns) {
        List<UniqueConstraint> list = this.getUniqueConstraints((UniqueConstraint c) -> true);
        Map columnMap = CommonUtils.map();
        for (Column column : columns) {
            columnMap.put(column.getName(), column);
        }
        return list.stream().filter(con -> {
            boolean match = true;
            for (ReferenceColumn fkcol : con.getColumns()) {
                Column column = (Column)columnMap.get(con.getName());
                if (column == null) {
                    match = false;
                    break;
                }
                if (SchemaUtils.nameEquals(column, fkcol)) continue;
                match = false;
                break;
            }
            return match;
        }).collect(Collectors.toList());
    }

    public UniqueConstraint getUniqueConstraint(Column ... columns) {
        List<UniqueConstraint> list = this.getUniqueConstraints((UniqueConstraint c) -> true);
        Map columnMap = CommonUtils.map();
        for (Column column : columns) {
            columnMap.put(column.getName(), column);
        }
        return list.stream().filter(con -> {
            if (columns.length != con.getColumns().size()) {
                return false;
            }
            boolean match = true;
            for (ReferenceColumn fkcol : con.getColumns()) {
                Column column = (Column)columnMap.get(fkcol.getName());
                if (column == null) {
                    match = false;
                    break;
                }
                if (SchemaUtils.nameEquals(column, fkcol)) continue;
                match = false;
                break;
            }
            return match;
        }).findFirst().orElse(null);
    }

    public List<ForeignKeyConstraint> getForeignKeyConstraints() {
        return this.getForeinKeyConstraints(c -> true);
    }

    public List<ForeignKeyConstraint> getForeignKeyConstraints(Column ... columns) {
        List<ForeignKeyConstraint> list = this.getForeinKeyConstraints(c -> true);
        Map columnMap = CommonUtils.map();
        for (Column column : columns) {
            columnMap.put(column.getName(), column);
        }
        return list.stream().filter(fk -> {
            boolean match = true;
            for (Column fkcol : fk.getColumns()) {
                Column column = (Column)columnMap.get(fkcol.getName());
                if (column == null) {
                    match = false;
                    break;
                }
                if (SchemaUtils.nameEquals(column, fkcol)) continue;
                match = false;
                break;
            }
            return match;
        }).collect(Collectors.toList());
    }

    public ForeignKeyConstraint getForeignKeyConstraint(Column ... columns) {
        List<ForeignKeyConstraint> list = this.getForeinKeyConstraints(c -> true);
        Map columnMap = CommonUtils.map();
        for (Column column : columns) {
            columnMap.put(column.getName(), column);
        }
        return list.stream().filter(fk -> {
            if (columns.length != fk.getColumns().length) {
                return false;
            }
            boolean match = true;
            for (Column fkcol : fk.getColumns()) {
                Column column = (Column)columnMap.get(fkcol.getName());
                if (column == null) {
                    match = false;
                    break;
                }
                if (SchemaUtils.nameEquals(column, fkcol)) continue;
                match = false;
                break;
            }
            return match;
        }).findFirst().orElse(null);
    }

    public List<ForeignKeyConstraint> getForeinKeyConstraints(Predicate<ForeignKeyConstraint> p) {
        List<ForeignKeyConstraint> result = CommonUtils.list(this.size());
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            ForeignKeyConstraint cc;
            Constraint c = (Constraint)this.get(i);
            if (!(c instanceof ForeignKeyConstraint) || !p.test(cc = (ForeignKeyConstraint)CommonUtils.cast(c))) continue;
            result.add(cc);
        }
        return result;
    }

    public List<ExcludeConstraint> getExcludeConstraints() {
        List<ExcludeConstraint> result = CommonUtils.list(this.size());
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            Constraint c = (Constraint)this.get(i);
            if (!(c instanceof ExcludeConstraint)) continue;
            ExcludeConstraint cc = (ExcludeConstraint)CommonUtils.cast(c);
            result.add(cc);
        }
        return result;
    }

    public List<ExcludeConstraint> getExcludeConstraints(Predicate<ExcludeConstraint> p) {
        List<ExcludeConstraint> result = CommonUtils.list(this.size());
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            ExcludeConstraint cc;
            Constraint c = (Constraint)this.get(i);
            if (!(c instanceof ExcludeConstraint) || !p.test(cc = (ExcludeConstraint)CommonUtils.cast(c))) continue;
            result.add(cc);
        }
        return result;
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!(obj instanceof ConstraintCollection)) {
            return false;
        }
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    @Override
    public void writeXml(StaxWriter stax) throws XMLStreamException {
        stax.newLine();
        stax.indent();
        stax.writeStartElement(this.getSimpleName());
        stax.addIndentLevel(1);
        int size = this.size();
        this.sort();
        for (int i = 0; i < size; ++i) {
            Constraint c = (Constraint)this.get(i);
            if (c instanceof UniqueConstraint) {
                UniqueConstraint uc = (UniqueConstraint)c;
                if (uc.isPrimaryKey()) {
                    uc.writeXmlAsPrimary(stax);
                    continue;
                }
                c.writeXml(stax);
                continue;
            }
            c.writeXml(stax);
        }
        stax.addIndentLevel(-1);
        stax.newLine();
        stax.indent();
        stax.writeEndElement();
    }

    public Table getTable() {
        return (Table)super.getParent();
    }

    public UniqueConstraint getPrimaryKeyConstraint() {
        UniqueConstraint uc;
        if (this.inner.size() == 0) {
            return null;
        }
        Constraint obj = (Constraint)this.get(0);
        if (obj instanceof UniqueConstraint && (uc = (UniqueConstraint)obj).isPrimaryKey()) {
            return uc;
        }
        return null;
    }

    @Override
    protected void validateAllElement() {
        int size = this.inner.size();
        for (int i = 0; i < size; ++i) {
            Constraint constraint = (Constraint)this.inner.get(i);
            if (constraint instanceof UniqueConstraint) {
                UniqueConstraint uc = (UniqueConstraint)constraint;
                this.resetColumns(uc);
                continue;
            }
            if (constraint instanceof CheckConstraint) {
                CheckConstraint cc = (CheckConstraint)constraint;
                this.resetColumns(cc);
                continue;
            }
            if (!(constraint instanceof ForeignKeyConstraint)) continue;
            ForeignKeyConstraint fc = (ForeignKeyConstraint)constraint;
            fc.validate();
        }
        this.sort();
    }

    @Override
    public void sort() {
        Collections.sort(this.inner);
    }

    @Override
    public Constraint find(Constraint obj) {
        for (Constraint con : this) {
            if (!con.like(obj)) continue;
            return con;
        }
        return null;
    }

    @Override
    public Table getParent() {
        return (Table)super.getParent();
    }

    @Override
    protected ConstraintCollectionXmlReaderHandler getDbObjectXmlReaderHandler() {
        return new ConstraintCollectionXmlReaderHandler();
    }

    @Override
    protected Supplier<Constraint> getElementSupplier() {
        return null;
    }
}

