/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.schemas.State;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.HashCodeBuilder;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public final class DbInfo
implements Map<String, String>,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private Map<String, String> innerMap = CommonUtils.caseInsensitiveTreeMap();

    public String get(String key) {
        return this.innerMap.get(key);
    }

    public <T> T get(String key, Class<T> clazz) {
        return Converters.getDefault().convertObject(this.get(key), clazz);
    }

    public Map<String, DiffValue> getDiffDbInfo(DbInfo dbInfo) {
        if (dbInfo == null) {
            return this.getDiffDbInfo(this, null);
        }
        return this.getDiffDbInfo(this, dbInfo);
    }

    private Map<String, DiffValue> getDiffDbInfo(Map<String, String> originalMap, Map<String, String> targetMap) {
        Map<String, DiffValue> map = CommonUtils.linkedMap();
        Set<String> keys = CommonUtils.linkedSet();
        if (originalMap != null) {
            keys.addAll(originalMap.keySet());
        }
        if (targetMap != null) {
            keys.addAll(targetMap.keySet());
        }
        for (String key : keys) {
            String original = null;
            String target = null;
            if (originalMap != null) {
                original = originalMap.get(key);
            }
            if (targetMap != null) {
                target = targetMap.get(key);
            }
            DiffValue diffValue = new DiffValue(original, target, State.getState(original, target));
            map.put(key, diffValue);
        }
        return map;
    }

    @Override
    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append(this.innerMap);
        return builder.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DbInfo)) {
            return false;
        }
        DbInfo val = (DbInfo)CommonUtils.cast(obj);
        if (this.innerMap.size() != val.innerMap.size()) {
            return false;
        }
        boolean ret = this.innerMap.equals(val.innerMap);
        return ret;
    }

    public DbInfo clone() {
        DbInfo clone = new DbInfo();
        clone.putAll(this);
        return clone;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        builder.append("{");
        for (Map.Entry<String, String> entry : this.innerMap.entrySet()) {
            if (!first) {
                builder.append(", ");
            }
            builder.append(entry.getKey());
            builder.append("=");
            builder.append(entry.getValue());
            first = false;
        }
        builder.append("}");
        return builder.toString();
    }

    @Override
    public int size() {
        return this.innerMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.innerMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.innerMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.innerMap.containsValue(value);
    }

    @Override
    public String get(Object key) {
        return this.innerMap.get(key);
    }

    @Override
    public String put(String key, String value) {
        return this.innerMap.put(key, value);
    }

    @Override
    public String put(String key, Object value) {
        if (value == null) {
            return this.innerMap.put(key, null);
        }
        return this.innerMap.put(key, value.toString());
    }

    @Override
    public String remove(Object key) {
        return this.innerMap.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        this.innerMap.putAll(m);
    }

    @Override
    public void clear() {
        this.innerMap.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.innerMap.keySet();
    }

    @Override
    public Collection<String> values() {
        return this.innerMap.values();
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.innerMap.entrySet();
    }

    public static class DiffValue
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = 1L;
        private final String original;
        private final String target;
        private final State state;

        protected DiffValue(String original, String target, State state) {
            this.original = original;
            this.target = target;
            this.state = state;
        }

        public String getOriginal() {
            return this.original;
        }

        public String getTarget() {
            return this.target;
        }

        public State getState() {
            return this.state;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            if (this.state == State.Added) {
                builder.append("+:");
            } else if (this.state == State.Modified) {
                builder.append("c:");
            } else if (this.state == State.Deleted) {
                builder.append("+:");
            }
            builder.append("(");
            builder.append(this.original);
            builder.append(" -> ");
            builder.append(this.target);
            builder.append(")");
            return builder.toString();
        }
    }
}

