/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.schemas.AbstractColumn;
import com.sqlapp.data.schemas.AbstractDifference;
import com.sqlapp.data.schemas.AbstractNamedObject;
import com.sqlapp.data.schemas.AbstractNamedObjectCollection;
import com.sqlapp.data.schemas.AbstractSchemaObject;
import com.sqlapp.data.schemas.AbstractSchemaObjectCollection;
import com.sqlapp.data.schemas.DbObject;
import com.sqlapp.data.schemas.DbObjectCollection;
import com.sqlapp.data.schemas.DbObjectDiff;
import com.sqlapp.data.schemas.DbObjectDifference;
import com.sqlapp.data.schemas.DbObjectPropertyDifference;
import com.sqlapp.data.schemas.Difference;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.State;
import com.sqlapp.data.schemas.properties.NameProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.SeparatedStringBuilder;
import com.sqlapp.util.ToStringBuilder;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;

public class DbObjectDifferenceCollection
extends AbstractDifference<DbObjectCollection<?>> {
    private static final long serialVersionUID = 6634332562149007807L;
    private List<DbObjectDifference> list = CommonUtils.list();

    protected DbObjectDifferenceCollection(DbObjectCollection<?> original, DbObjectCollection<?> target) {
        this((String)null, original, target, new EqualsHandler());
    }

    protected DbObjectDifferenceCollection(String propertyName, DbObjectCollection<?> original, DbObjectCollection<?> target) {
        this(propertyName, original, target, new EqualsHandler());
    }

    protected DbObjectDifferenceCollection(String propertyName, DbObjectCollection<?> original, DbObjectCollection<?> target, EqualsHandler equalsHandler, boolean skipDiff) {
        super(propertyName, original, target, equalsHandler);
        if (!skipDiff) {
            this.diff();
        }
    }

    protected DbObjectDifferenceCollection(DbObjectCollection<?> original, DbObjectCollection<?> target, EqualsHandler equalsHandler) {
        this(null, original, target, equalsHandler, false);
    }

    protected DbObjectDifferenceCollection(String propertyName, DbObjectCollection<?> original, DbObjectCollection<?> target, EqualsHandler equalsHandler) {
        this(propertyName, original, target, equalsHandler, false);
    }

    public DbObjectDifferenceCollection reverse() {
        DbObjectDifferenceCollection reverse = new DbObjectDifferenceCollection(this.getPropertyName(), (DbObjectCollection)this.getTarget(), (DbObjectCollection)this.getOriginal(), this.getEqualsHandler(), true);
        return reverse;
    }

    public List<DbObjectPropertyDifference> findModifiedProperties(Dialect dialect, String propertyName, Class<? extends DbObject<?>> clazz) {
        List<DbObjectPropertyDifference> result = CommonUtils.list();
        for (DbObjectDifference diff : this.getList()) {
            List<DbObjectPropertyDifference> childResult = diff.findModifiedProperties(dialect, propertyName, clazz);
            result.addAll(childResult);
        }
        return result;
    }

    @Override
    protected void diff() {
        if (!DbObjectDifferenceCollection.isDbObject(this.getOriginal(), this.getTarget())) {
            return;
        }
        if (this.isColumns(this.getOriginal(), this.getTarget())) {
            this.diffColumns();
            return;
        }
        this.diffObjects();
    }

    protected void diffObjects() {
        DbObjectDiff diff = new DbObjectDiff((List)this.getOriginal(), (List)this.getTarget(), this.getEqualsHandler());
        int osize = ((DbObjectCollection)this.getOriginal()).size();
        int tsize = ((DbObjectCollection)this.getTarget()).size();
        int i = 0;
        int j = 0;
        while (i < osize || j < tsize) {
            DbObjectDifference dbObjectDifference;
            DbObject oobj = null;
            DbObject tobj = null;
            while (i < osize) {
                oobj = (DbObject)((DbObjectCollection)this.getOriginal()).get(i);
                if (diff.getLcs1().containsKey(++i - 1)) break;
                dbObjectDifference = new DbObjectDifference(oobj, null, this.getEqualsHandler());
                this.addDbObjectDifference(dbObjectDifference);
                oobj = null;
            }
            while (j < tsize) {
                if (oobj != null) {
                    if (this.getTarget() instanceof AbstractNamedObjectCollection) {
                        tobj = ((AbstractNamedObjectCollection)this.getTarget()).find((AbstractNamedObject)oobj);
                    }
                    if (tobj != null) break;
                }
                tobj = (DbObject)((DbObjectCollection)this.getTarget()).get(j);
                if (diff.getLcs2().containsKey(++j - 1)) break;
                dbObjectDifference = new DbObjectDifference(null, tobj, this.getEqualsHandler());
                this.addDbObjectDifference(dbObjectDifference);
            }
            if (oobj == null || tobj == null) continue;
            dbObjectDifference = new DbObjectDifference(oobj, tobj, this.getEqualsHandler());
            this.addDbObjectDifference(dbObjectDifference);
        }
        this.setState(DbObjectDifferenceCollection.getState(this.list));
    }

    protected void diffColumns() {
        if (!this.isColumns(this.getOriginal(), this.getTarget())) {
            return;
        }
        DbObjectDiff diff = new DbObjectDiff((List)this.getOriginal(), (List)this.getTarget(), this.getEqualsHandler());
        int osize = ((DbObjectCollection)this.getOriginal()).size();
        int tsize = ((DbObjectCollection)this.getTarget()).size();
        int i = 0;
        int j = 0;
        List added1 = CommonUtils.list();
        List added2 = CommonUtils.list();
        while (i < osize || j < tsize) {
            DbObjectDifference dbObjectDifference;
            AbstractColumn oobj = null;
            AbstractColumn tobj = null;
            while (i < osize) {
                oobj = (AbstractColumn)((DbObjectCollection)this.getOriginal()).get(i);
                if (diff.getLcs1().containsKey(++i - 1)) break;
                AbstractColumn<?> tColumn = this.getColumn((List)this.getTarget(), oobj.getName());
                if (tColumn != null && !diff.getLcs2().containsValue(tColumn) && !added2.contains(tColumn)) {
                    dbObjectDifference = new DbObjectDifference(oobj, (DbObject<?>)tColumn, this.getEqualsHandler());
                    this.addDbObjectDifferenceForColumn(dbObjectDifference);
                    added2.add(tColumn);
                    continue;
                }
                dbObjectDifference = new DbObjectDifference(oobj, null, this.getEqualsHandler());
                this.addDbObjectDifferenceForColumn(dbObjectDifference);
            }
            while (j < tsize) {
                tobj = (AbstractColumn)((DbObjectCollection)this.getTarget()).get(j);
                if (diff.getLcs2().containsKey(++j - 1)) break;
                AbstractColumn<?> oColumn = this.getColumn((List)this.getOriginal(), tobj.getName());
                if (oColumn != null && !diff.getLcs1().containsValue(oColumn) && !added1.contains(oColumn)) {
                    dbObjectDifference = new DbObjectDifference((DbObject<?>)oColumn, tobj, this.getEqualsHandler());
                    this.addDbObjectDifferenceForColumn(dbObjectDifference);
                    added1.add(oColumn);
                    continue;
                }
                dbObjectDifference = new DbObjectDifference(null, tobj, this.getEqualsHandler());
                this.addDbObjectDifferenceForColumn(dbObjectDifference);
            }
            if (added1.contains(oobj) || added2.contains(tobj) || oobj == null || tobj == null) continue;
            added1.add(oobj);
            added2.add(tobj);
            DbObjectDifference dbObjectDifference2 = new DbObjectDifference(oobj, tobj, this.getEqualsHandler());
            this.addDbObjectDifferenceForColumn(dbObjectDifference2);
        }
        this.setState(DbObjectDifferenceCollection.getState(this.list));
    }

    private AbstractColumn<?> getColumn(Collection<AbstractColumn<?>> columns, String name) {
        for (AbstractColumn<?> column : columns) {
            if (!name.equals(column.getName())) continue;
            return column;
        }
        return null;
    }

    protected boolean isColumns(Object ... args) {
        for (Object obj : args) {
            if (!(obj instanceof AbstractSchemaObjectCollection)) continue;
            for (AbstractSchemaObject o : (AbstractSchemaObjectCollection)obj) {
                if (!(o instanceof AbstractColumn)) continue;
                return true;
            }
        }
        return false;
    }

    private void addDbObjectDifference(DbObjectDifference dbObjectDifference) {
        dbObjectDifference.setParentDifference(this);
        this.getList().add(dbObjectDifference);
    }

    private void addDbObjectDifferenceForColumn(DbObjectDifference dbObjectDifference) {
        dbObjectDifference.setParentDifference(this);
        if (!this.getList().contains(dbObjectDifference)) {
            this.getList().add(dbObjectDifference);
        }
    }

    public static State getState(Collection<DbObjectDifference> c) {
        EnumSet<State> stateSet = EnumSet.noneOf(State.class);
        for (DbObjectDifference obj : c) {
            if (!obj.getState().isChanged()) continue;
            stateSet.add(obj.getState());
        }
        if (stateSet.size() == 0) {
            return State.Unchanged;
        }
        return State.Modified;
    }

    public static List<DbObjectDifference> getByStates(Collection<DbObjectDifference> c, State ... states) {
        Set<State[]> set = CommonUtils.set(states);
        List<DbObjectDifference> result = CommonUtils.list();
        for (DbObjectDifference diff : c) {
            if (!set.contains((Object)diff.getState())) continue;
            result.add(diff);
        }
        return result;
    }

    public List<DbObjectDifference> getList() {
        return this.list;
    }

    public List<DbObjectDifference> getList(State ... states) {
        return DbObjectDifferenceCollection.getByStates(this.list, states);
    }

    public DbObjectDifference find(Function<DbObjectDifference, Boolean> func) {
        for (DbObjectDifference obj : this.list) {
            if (!func.apply(obj).booleanValue()) continue;
            return obj;
        }
        return null;
    }

    public Map<String, DbObjectDifference> toMap() {
        return this.toMap(obj -> true);
    }

    public Map<String, DbObjectDifference> toMap(Function<DbObjectDifference, Boolean> func) {
        Map<String, DbObjectDifference> map = CommonUtils.linkedMap();
        this.list.stream().filter(obj -> (Boolean)func.apply((DbObjectDifference)obj)).forEach(obj -> {
            NameProperty nameProperty;
            Object original = obj.getOriginal();
            Object target = obj.getTarget();
            if (original instanceof NameProperty) {
                nameProperty = (NameProperty)original;
                map.put(nameProperty.getName(), (DbObjectDifference)obj);
            }
            if (target instanceof NameProperty) {
                nameProperty = (NameProperty)original;
                map.put(nameProperty.getName(), (DbObjectDifference)obj);
            }
        });
        return map;
    }

    @Override
    protected void toString(ToStringBuilder builder) {
        SeparatedStringBuilder sepBuilder = new SeparatedStringBuilder("");
        for (DbObjectDifference diff : this.list) {
            if (!diff.getState().isChanged()) continue;
            sepBuilder.add((Object)diff);
        }
        builder.add(sepBuilder.toString());
    }

    @Override
    public int compareTo(Difference<?> o) {
        if (o instanceof DbObjectDifference) {
            return 1;
        }
        if (o instanceof DbObjectPropertyDifference) {
            return 1;
        }
        return 0;
    }

    @Override
    public void removeRecursive(BiPredicate<String, Difference<?>> predicate) {
        Set<DbObjectDifference> children = CommonUtils.set();
        for (DbObjectDifference child : this.list) {
            if (!predicate.test(null, child)) continue;
            children.add(child);
        }
        for (DbObjectDifference child : children) {
            this.list.remove(child);
        }
        for (DbObjectDifference child : this.list) {
            if (child.getState().isChanged()) continue;
            children.add(child);
        }
        for (DbObjectDifference child : children) {
            this.list.remove(child);
        }
        if (this.list.size() == 0) {
            this.setState(State.Unchanged);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof DbObjectDifferenceCollection)) {
            return false;
        }
        DbObjectDifferenceCollection cst = (DbObjectDifferenceCollection)obj;
        return this.getList().equals(cst.getList());
    }
}

