/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.Assembly;
import com.sqlapp.data.schemas.AssemblyCollection;
import com.sqlapp.data.schemas.Catalog;
import com.sqlapp.data.schemas.CheckConstraint;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.ColumnCollection;
import com.sqlapp.data.schemas.ColumnPrivilegeCollection;
import com.sqlapp.data.schemas.Constant;
import com.sqlapp.data.schemas.ConstantCollection;
import com.sqlapp.data.schemas.ConstraintCollection;
import com.sqlapp.data.schemas.DbLink;
import com.sqlapp.data.schemas.DbLinkCollection;
import com.sqlapp.data.schemas.Dimension;
import com.sqlapp.data.schemas.DimensionCollection;
import com.sqlapp.data.schemas.Directory;
import com.sqlapp.data.schemas.DirectoryCollection;
import com.sqlapp.data.schemas.Domain;
import com.sqlapp.data.schemas.DomainCollection;
import com.sqlapp.data.schemas.Event;
import com.sqlapp.data.schemas.EventCollection;
import com.sqlapp.data.schemas.ExternalTable;
import com.sqlapp.data.schemas.ExternalTableCollection;
import com.sqlapp.data.schemas.ForeignKeyConstraint;
import com.sqlapp.data.schemas.Function;
import com.sqlapp.data.schemas.FunctionCollection;
import com.sqlapp.data.schemas.Index;
import com.sqlapp.data.schemas.IndexCollection;
import com.sqlapp.data.schemas.Mask;
import com.sqlapp.data.schemas.MaskCollection;
import com.sqlapp.data.schemas.Mview;
import com.sqlapp.data.schemas.MviewCollection;
import com.sqlapp.data.schemas.MviewLog;
import com.sqlapp.data.schemas.MviewLogCollection;
import com.sqlapp.data.schemas.ObjectPrivilege;
import com.sqlapp.data.schemas.ObjectPrivilegeCollection;
import com.sqlapp.data.schemas.Operator;
import com.sqlapp.data.schemas.OperatorClass;
import com.sqlapp.data.schemas.OperatorClassCollection;
import com.sqlapp.data.schemas.OperatorCollection;
import com.sqlapp.data.schemas.Package;
import com.sqlapp.data.schemas.PackageBodyCollection;
import com.sqlapp.data.schemas.PackageCollection;
import com.sqlapp.data.schemas.Partition;
import com.sqlapp.data.schemas.PartitionCollection;
import com.sqlapp.data.schemas.PartitionFunction;
import com.sqlapp.data.schemas.PartitionFunctionCollection;
import com.sqlapp.data.schemas.PartitionScheme;
import com.sqlapp.data.schemas.PartitionSchemeCollection;
import com.sqlapp.data.schemas.Procedure;
import com.sqlapp.data.schemas.ProcedureCollection;
import com.sqlapp.data.schemas.PublicDbLink;
import com.sqlapp.data.schemas.PublicDbLinkCollection;
import com.sqlapp.data.schemas.PublicSynonym;
import com.sqlapp.data.schemas.PublicSynonymCollection;
import com.sqlapp.data.schemas.Role;
import com.sqlapp.data.schemas.RoleCollection;
import com.sqlapp.data.schemas.RoleMember;
import com.sqlapp.data.schemas.RoleMemberCollection;
import com.sqlapp.data.schemas.RolePrivilege;
import com.sqlapp.data.schemas.RolePrivilegeCollection;
import com.sqlapp.data.schemas.RoutinePrivilege;
import com.sqlapp.data.schemas.RoutinePrivilegeCollection;
import com.sqlapp.data.schemas.Rule;
import com.sqlapp.data.schemas.RuleCollection;
import com.sqlapp.data.schemas.Schema;
import com.sqlapp.data.schemas.SchemaCollection;
import com.sqlapp.data.schemas.SchemaPrivilege;
import com.sqlapp.data.schemas.SchemaPrivilegeCollection;
import com.sqlapp.data.schemas.Sequence;
import com.sqlapp.data.schemas.SequenceCollection;
import com.sqlapp.data.schemas.Setting;
import com.sqlapp.data.schemas.SettingCollection;
import com.sqlapp.data.schemas.SubPartition;
import com.sqlapp.data.schemas.SubPartitionCollection;
import com.sqlapp.data.schemas.Synonym;
import com.sqlapp.data.schemas.SynonymCollection;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.TableCollection;
import com.sqlapp.data.schemas.TableLink;
import com.sqlapp.data.schemas.TableLinkCollection;
import com.sqlapp.data.schemas.TableSpace;
import com.sqlapp.data.schemas.TableSpaceCollection;
import com.sqlapp.data.schemas.Trigger;
import com.sqlapp.data.schemas.TriggerCollection;
import com.sqlapp.data.schemas.Type;
import com.sqlapp.data.schemas.TypeBody;
import com.sqlapp.data.schemas.TypeBodyCollection;
import com.sqlapp.data.schemas.TypeCollection;
import com.sqlapp.data.schemas.UniqueConstraint;
import com.sqlapp.data.schemas.User;
import com.sqlapp.data.schemas.UserCollection;
import com.sqlapp.data.schemas.UserPrivilege;
import com.sqlapp.data.schemas.UserPrivilegeCollection;
import com.sqlapp.data.schemas.View;
import com.sqlapp.data.schemas.ViewCollection;
import com.sqlapp.data.schemas.XmlSchema;
import com.sqlapp.data.schemas.XmlSchemaCollection;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.StringUtils;
import com.sqlapp.util.ToStringBuilder;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public enum DbObjects {
    CATALOG(Catalog.class),
    PUBLIC_SYNONYMS((Class)PublicSynonymCollection.class){

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public DbObjects getParentType() {
            return CATALOG;
        }
    }
    ,
    PUBLIC_SYNONYM((Class)PublicSynonym.class){

        @Override
        public DbObjects getCollectionType() {
            return PUBLIC_SYNONYMS;
        }

        @Override
        public DbObjects[] getDepends() {
            return DbObjects.array(TABLE, VIEW, MVIEW, FUNCTION, PROCEDURE, PACKAGE);
        }
    }
    ,
    PUBLIC_DB_LINKS((Class)PublicDbLinkCollection.class){

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public DbObjects getParentType() {
            return CATALOG;
        }
    }
    ,
    PUBLIC_DB_LINK((Class)PublicDbLink.class){

        @Override
        public DbObjects getCollectionType() {
            return PUBLIC_DB_LINKS;
        }

        @Override
        public DbObjects[] getDepends() {
            return DbObjects.array(TABLE, VIEW);
        }
    }
    ,
    USERS((Class)UserCollection.class){

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public DbObjects getParentType() {
            return CATALOG;
        }
    }
    ,
    USER((Class)User.class){

        @Override
        public DbObjects getCollectionType() {
            return USERS;
        }
    }
    ,
    ROLES((Class)RoleCollection.class){

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public DbObjects getParentType() {
            return CATALOG;
        }
    }
    ,
    ROLE((Class)Role.class){

        @Override
        public DbObjects getCollectionType() {
            return ROLES;
        }
    }
    ,
    TABLE_SPACES((Class)TableSpaceCollection.class){

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public DbObjects getParentType() {
            return CATALOG;
        }
    }
    ,
    TABLE_SPACE((Class)TableSpace.class){

        @Override
        public DbObjects getCollectionType() {
            return TABLE_SPACES;
        }
    }
    ,
    DIRECTORIES((Class)DirectoryCollection.class){

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public DbObjects getParentType() {
            return CATALOG;
        }
    }
    ,
    DIRECTORY((Class)Directory.class){

        @Override
        public DbObjects getCollectionType() {
            return DIRECTORIES;
        }
    }
    ,
    PARTITION_FUNCTIONS((Class)PartitionFunctionCollection.class){

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public DbObjects getParentType() {
            return CATALOG;
        }
    }
    ,
    PARTITION_FUNCTION((Class)PartitionFunction.class){

        @Override
        public DbObjects getCollectionType() {
            return PARTITION_FUNCTIONS;
        }
    }
    ,
    PARTITION_SCHEMES((Class)PartitionSchemeCollection.class){

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public DbObjects getParentType() {
            return CATALOG;
        }
    }
    ,
    PARTITION_SCHEME((Class)PartitionScheme.class){

        @Override
        public DbObjects getCollectionType() {
            return PARTITION_SCHEMES;
        }

        @Override
        public DbObjects[] getDepends() {
            return DbObjects.array(PARTITION_FUNCTION);
        }
    }
    ,
    ASSEMBLIES((Class)AssemblyCollection.class){

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public DbObjects getParentType() {
            return CATALOG;
        }
    }
    ,
    ASSEMBLY((Class)Assembly.class){

        @Override
        public DbObjects getCollectionType() {
            return ASSEMBLIES;
        }
    }
    ,
    OBJECT_PRIVILEGES((Class)ObjectPrivilegeCollection.class){

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public DbObjects getParentType() {
            return CATALOG;
        }
    }
    ,
    OBJECT_PRIVILEGE((Class)ObjectPrivilege.class){

        @Override
        public DbObjects getCollectionType() {
            return OBJECT_PRIVILEGES;
        }

        @Override
        public DbObjects[] getDepends() {
            return DbObjects.array(TABLE, VIEW, MVIEW, FUNCTION, PROCEDURE, PACKAGE);
        }
    }
    ,
    ROUTINE_PRIVILEGES((Class)RoutinePrivilegeCollection.class){

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public DbObjects getParentType() {
            return CATALOG;
        }
    }
    ,
    ROUTINE_PRIVILEGE((Class)RoutinePrivilege.class){

        @Override
        public DbObjects getCollectionType() {
            return ROUTINE_PRIVILEGES;
        }

        @Override
        public DbObjects[] getDepends() {
            return DbObjects.array(FUNCTION, PROCEDURE, PACKAGE);
        }
    }
    ,
    COLUMN_PRIVILEGES((Class)ColumnPrivilegeCollection.class){

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public DbObjects getParentType() {
            return CATALOG;
        }
    }
    ,
    COLUMN_PRIVILEGE((Class)ObjectPrivilege.class){

        @Override
        public DbObjects getCollectionType() {
            return COLUMN_PRIVILEGES;
        }

        @Override
        public DbObjects[] getDepends() {
            return DbObjects.array(TABLE, VIEW, MVIEW, COLUMN);
        }
    }
    ,
    USER_PRIVILEGES((Class)UserPrivilegeCollection.class){

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public DbObjects getParentType() {
            return CATALOG;
        }
    }
    ,
    USER_PRIVILEGE((Class)UserPrivilege.class){

        @Override
        public DbObjects getCollectionType() {
            return USER_PRIVILEGES;
        }

        @Override
        public DbObjects[] getDepends() {
            return DbObjects.array(USER);
        }
    }
    ,
    ROLE_PRIVILEGES((Class)RolePrivilegeCollection.class){

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public DbObjects getParentType() {
            return CATALOG;
        }
    }
    ,
    ROLE_PRIVILEGE((Class)RolePrivilege.class){

        @Override
        public DbObjects getCollectionType() {
            return ROLE_PRIVILEGES;
        }

        @Override
        public DbObjects[] getDepends() {
            return DbObjects.array(ROLE);
        }
    }
    ,
    SCHEMA_PRIVILEGES((Class)SchemaPrivilegeCollection.class){

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public DbObjects getParentType() {
            return CATALOG;
        }
    }
    ,
    SCHEMA_PRIVILEGE((Class)SchemaPrivilege.class){

        @Override
        public DbObjects getCollectionType() {
            return SCHEMA_PRIVILEGES;
        }

        @Override
        public DbObjects[] getDepends() {
            return DbObjects.array(SCHEMA);
        }
    }
    ,
    ROLE_MEMBERS((Class)RoleMemberCollection.class){

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public DbObjects getParentType() {
            return CATALOG;
        }
    }
    ,
    ROLE_MEMBER((Class)RoleMember.class){

        @Override
        public DbObjects getCollectionType() {
            return ROLE_MEMBERS;
        }

        @Override
        public DbObjects[] getDepends() {
            return DbObjects.array(ROLE);
        }
    }
    ,
    SETTINGS((Class)SettingCollection.class){

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public DbObjects getParentType() {
            return CATALOG;
        }
    }
    ,
    SETTING((Class)Setting.class){

        @Override
        public DbObjects getCollectionType() {
            return SETTINGS;
        }

        @Override
        public DbObjects[] getDepends() {
            return DbObjects.array(CATALOG);
        }
    }
    ,
    SCHEMAS((Class)SchemaCollection.class){

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public DbObjects getParentType() {
            return CATALOG;
        }
    }
    ,
    SCHEMA((Class)Schema.class){

        @Override
        public DbObjects getCollectionType() {
            return SCHEMAS;
        }

        @Override
        public DbObjects[] getDepends() {
            return DbObjects.array(CATALOG, TABLE_SPACES);
        }
    }
    ,
    TABLES((Class)TableCollection.class){

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public DbObjects getParentType() {
            return SCHEMA;
        }
    }
    ,
    TABLE((Class)Table.class){

        @Override
        public DbObjects getCollectionType() {
            return TABLES;
        }

        @Override
        public DbObjects[] getDepends() {
            return DbObjects.array(DOMAIN, TYPE, PARTITION_SCHEME);
        }
    }
    ,
    VIEWS((Class)ViewCollection.class){

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public DbObjects getParentType() {
            return SCHEMA;
        }
    }
    ,
    VIEW((Class)View.class){

        @Override
        public DbObjects getCollectionType() {
            return VIEWS;
        }

        @Override
        public DbObjects[] getDepends() {
            return DbObjects.array(TABLE);
        }
    }
    ,
    MVIEWS((Class)MviewCollection.class){

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public DbObjects getParentType() {
            return SCHEMA;
        }
    }
    ,
    MVIEW((Class)Mview.class){

        @Override
        public DbObjects getCollectionType() {
            return MVIEWS;
        }

        @Override
        public DbObjects[] getDepends() {
            return DbObjects.array(TABLE);
        }
    }
    ,
    EXTERNAL_TABLES((Class)ExternalTableCollection.class){

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public DbObjects getParentType() {
            return SCHEMA;
        }
    }
    ,
    EXTERNAL_TABLE((Class)ExternalTable.class){

        @Override
        public DbObjects getCollectionType() {
            return EXTERNAL_TABLES;
        }
    }
    ,
    MVIEW_LOGS((Class)MviewLogCollection.class){

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public DbObjects getParentType() {
            return SCHEMA;
        }
    }
    ,
    MVIEW_LOG((Class)MviewLog.class){

        @Override
        public DbObjects getCollectionType() {
            return MVIEW_LOGS;
        }

        @Override
        public DbObjects[] getDepends() {
            return DbObjects.array(TABLE, MVIEW);
        }
    }
    ,
    MASKS((Class)MaskCollection.class){

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public DbObjects getParentType() {
            return SCHEMA;
        }
    }
    ,
    MASK((Class)Mask.class){

        @Override
        public DbObjects getCollectionType() {
            return MASKS;
        }

        @Override
        public DbObjects[] getDepends() {
            return DbObjects.array(TABLE, MVIEW);
        }
    }
    ,
    PROCEDURES((Class)ProcedureCollection.class){

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public DbObjects getParentType() {
            return SCHEMA;
        }
    }
    ,
    PROCEDURE((Class)Procedure.class){

        @Override
        public DbObjects getCollectionType() {
            return PROCEDURES;
        }

        @Override
        public DbObjects[] getDepends() {
            return DbObjects.array(TABLE, MVIEW, VIEW, FUNCTION, TYPE);
        }
    }
    ,
    FUNCTIONS((Class)FunctionCollection.class){

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public DbObjects getParentType() {
            return SCHEMA;
        }
    }
    ,
    FUNCTION((Class)Function.class){

        @Override
        public DbObjects getCollectionType() {
            return FUNCTIONS;
        }

        @Override
        public DbObjects[] getDepends() {
            return DbObjects.array(TABLE, MVIEW, VIEW, PACKAGE, TYPE);
        }
    }
    ,
    PACKAGES((Class)PackageCollection.class){

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public DbObjects getParentType() {
            return SCHEMA;
        }
    }
    ,
    PACKAGE((Class)Package.class){

        @Override
        public DbObjects getCollectionType() {
            return PACKAGES;
        }

        @Override
        public DbObjects[] getDepends() {
            return DbObjects.array(DOMAIN, TYPE);
        }
    }
    ,
    PACKAGE_BODIES((Class)PackageBodyCollection.class){

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public DbObjects getParentType() {
            return SCHEMA;
        }
    }
    ,
    PACKAGE_BODY((Class)Package.class){

        @Override
        public DbObjects getCollectionType() {
            return PACKAGE_BODIES;
        }

        @Override
        public DbObjects[] getDepends() {
            return DbObjects.array(PACKAGE, TABLE, MVIEW, VIEW);
        }
    }
    ,
    TRIGGERS((Class)TriggerCollection.class){

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public DbObjects getParentType() {
            return SCHEMA;
        }
    }
    ,
    TRIGGER((Class)Trigger.class){

        @Override
        public DbObjects getCollectionType() {
            return TRIGGERS;
        }

        @Override
        public DbObjects[] getDepends() {
            return DbObjects.array(TABLE, FUNCTION, PROCEDURE);
        }
    }
    ,
    SEQUENCES((Class)SequenceCollection.class){

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public DbObjects getParentType() {
            return SCHEMA;
        }
    }
    ,
    SEQUENCE((Class)Sequence.class){

        @Override
        public DbObjects getCollectionType() {
            return SEQUENCES;
        }
    }
    ,
    DB_LINKS((Class)DbLinkCollection.class){

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public DbObjects getParentType() {
            return SCHEMA;
        }
    }
    ,
    DB_LINK((Class)DbLink.class){

        @Override
        public DbObjects getCollectionType() {
            return DB_LINKS;
        }
    }
    ,
    TABLE_LINKS((Class)TableLinkCollection.class){

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public DbObjects getParentType() {
            return SCHEMA;
        }
    }
    ,
    TABLE_LINK((Class)TableLink.class){

        @Override
        public DbObjects getCollectionType() {
            return TABLE_LINKS;
        }
    }
    ,
    SYNONYMS((Class)SynonymCollection.class){

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public DbObjects getParentType() {
            return SCHEMA;
        }
    }
    ,
    SYNONYM((Class)Synonym.class){

        @Override
        public DbObjects getCollectionType() {
            return SYNONYMS;
        }

        @Override
        public DbObjects[] getDepends() {
            return DbObjects.array(TABLE, VIEW, MVIEW, FUNCTION, PROCEDURE);
        }
    }
    ,
    DOMAINS((Class)DomainCollection.class){

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public DbObjects getParentType() {
            return SCHEMA;
        }
    }
    ,
    DOMAIN((Class)Domain.class){

        @Override
        public DbObjects getCollectionType() {
            return DOMAINS;
        }

        @Override
        public DbObjects[] getDepends() {
            return DbObjects.array(CONSTANT);
        }
    }
    ,
    TYPES((Class)TypeCollection.class){

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public DbObjects getParentType() {
            return SCHEMA;
        }
    }
    ,
    TYPE((Class)Type.class){

        @Override
        public DbObjects getCollectionType() {
            return TYPES;
        }

        @Override
        public DbObjects[] getDepends() {
            return DbObjects.array(DOMAIN);
        }
    }
    ,
    TYPE_BODIES((Class)TypeBodyCollection.class){

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public DbObjects getParentType() {
            return SCHEMA;
        }
    }
    ,
    TYPE_BODY((Class)TypeBody.class){

        @Override
        public DbObjects getCollectionType() {
            return TYPE_BODIES;
        }

        @Override
        public DbObjects[] getDepends() {
            return DbObjects.array(TYPE);
        }
    }
    ,
    RULES((Class)RuleCollection.class){

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public DbObjects getParentType() {
            return SCHEMA;
        }
    }
    ,
    RULE((Class)Rule.class){

        @Override
        public DbObjects getCollectionType() {
            return RULES;
        }
    }
    ,
    CONSTANTS((Class)ConstantCollection.class){

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public DbObjects getParentType() {
            return SCHEMA;
        }
    }
    ,
    CONSTANT((Class)Constant.class){

        @Override
        public DbObjects getCollectionType() {
            return CONSTANTS;
        }

        @Override
        public DbObjects[] getDepends() {
            return DbObjects.array(SCHEMA);
        }
    }
    ,
    EVENTS((Class)EventCollection.class){

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public DbObjects getParentType() {
            return SCHEMA;
        }
    }
    ,
    EVENT((Class)Event.class){

        @Override
        public DbObjects getCollectionType() {
            return EVENTS;
        }

        @Override
        public DbObjects[] getDepends() {
            return DbObjects.array(FUNCTION, PROCEDURE, PACKAGE);
        }
    }
    ,
    XML_SCHEMAS((Class)XmlSchemaCollection.class){

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public DbObjects getParentType() {
            return SCHEMA;
        }
    }
    ,
    XML_SCHEMA((Class)XmlSchema.class){

        @Override
        public DbObjects getCollectionType() {
            return XML_SCHEMAS;
        }
    }
    ,
    OPERATORS((Class)OperatorCollection.class){

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public DbObjects getParentType() {
            return SCHEMA;
        }
    }
    ,
    OPERATOR((Class)Operator.class){

        @Override
        public DbObjects getCollectionType() {
            return OPERATORS;
        }

        @Override
        public DbObjects[] getDepends() {
            return DbObjects.array(FUNCTION, DOMAIN, TYPE);
        }
    }
    ,
    OPERATOR_CLASSES((Class)OperatorClassCollection.class){

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public DbObjects getParentType() {
            return SCHEMA;
        }
    }
    ,
    OPERATOR_CLASS((Class)OperatorClass.class){

        @Override
        public DbObjects getCollectionType() {
            return OPERATOR_CLASSES;
        }

        @Override
        public DbObjects[] getDepends() {
            return DbObjects.array(OPERATOR, FUNCTION);
        }
    }
    ,
    DIMENSIONS((Class)DimensionCollection.class){

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public DbObjects getParentType() {
            return SCHEMA;
        }
    }
    ,
    DIMENSION((Class)Dimension.class){

        @Override
        public DbObjects getCollectionType() {
            return DIMENSIONS;
        }

        @Override
        public DbObjects[] getDepends() {
            return DbObjects.array(TABLE, VIEW, MVIEW);
        }
    }
    ,
    INDEXES((Class)IndexCollection.class){

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public DbObjects getParentType() {
            return TABLE;
        }
    }
    ,
    INDEX((Class)Index.class){

        @Override
        public DbObjects getCollectionType() {
            return INDEXES;
        }

        @Override
        public DbObjects[] getDepends() {
            return DbObjects.array(TABLE, VIEW, MVIEW, FUNCTION, PACKAGE);
        }
    }
    ,
    UNIQUE_CONSTRAINTS("constraints", (Class)ConstraintCollection.class){

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public DbObjects getParentType() {
            return TABLE;
        }
    }
    ,
    UNIQUE_CONSTRAINT((Class)UniqueConstraint.class){

        @Override
        public DbObjects getCollectionType() {
            return UNIQUE_CONSTRAINTS;
        }

        @Override
        public DbObjects[] getDepends() {
            return DbObjects.array(TABLE, FUNCTION, PACKAGE, COLUMN);
        }
    }
    ,
    FOREIGN_KEY_CONSTRAINTS("constraints", (Class)ConstraintCollection.class){

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public DbObjects getParentType() {
            return TABLE;
        }
    }
    ,
    FOREIGN_KEY_CONSTRAINT((Class)ForeignKeyConstraint.class){

        @Override
        public DbObjects getCollectionType() {
            return FOREIGN_KEY_CONSTRAINTS;
        }

        @Override
        public DbObjects[] getDepends() {
            return DbObjects.array(TABLE, UNIQUE_CONSTRAINT, COLUMN);
        }
    }
    ,
    CHECK_CONSTRAINTS("constraints", (Class)ConstraintCollection.class){

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public DbObjects getParentType() {
            return TABLE;
        }
    }
    ,
    CHECK_CONSTRAINT((Class)CheckConstraint.class){

        @Override
        public DbObjects getCollectionType() {
            return CHECK_CONSTRAINTS;
        }

        @Override
        public DbObjects[] getDepends() {
            return DbObjects.array(TABLE, COLUMN);
        }
    }
    ,
    EXCLUDE_CONSTRAINTS("constraints", (Class)ConstraintCollection.class){

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public DbObjects getParentType() {
            return TABLE;
        }
    }
    ,
    EXCLUDE_CONSTRAINT((Class)ForeignKeyConstraint.class){

        @Override
        public DbObjects getCollectionType() {
            return EXCLUDE_CONSTRAINTS;
        }

        @Override
        public DbObjects[] getDepends() {
            return DbObjects.array(TABLE, COLUMN);
        }
    }
    ,
    COLUMNS((Class)ColumnCollection.class){

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public DbObjects getParentType() {
            return TABLE;
        }
    }
    ,
    COLUMN((Class)Column.class){

        @Override
        public DbObjects getCollectionType() {
            return COLUMNS;
        }

        @Override
        public DbObjects[] getDepends() {
            return DbObjects.array(DOMAIN, TYPE);
        }
    }
    ,
    PARTITIONS((Class)PartitionCollection.class){

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public DbObjects getParentType() {
            return TABLE;
        }
    }
    ,
    PARTITION((Class)Partition.class){

        @Override
        public DbObjects getCollectionType() {
            return PARTITIONS;
        }

        @Override
        public DbObjects[] getDepends() {
            return DbObjects.array(TABLE);
        }
    }
    ,
    SUB_PARTITIONS((Class)SubPartitionCollection.class){

        @Override
        public boolean isCollection() {
            return true;
        }

        @Override
        public DbObjects getParentType() {
            return TABLE;
        }
    }
    ,
    SUB_PARTITION((Class)SubPartition.class){

        @Override
        public DbObjects getCollectionType() {
            return SUB_PARTITIONS;
        }

        @Override
        public DbObjects[] getDepends() {
            return DbObjects.array(PARTITION);
        }
    };

    private final Class<?> type;
    private final String label;

    private DbObjects(Class<?> type) {
        this.type = type;
        this.label = StringUtils.snakeToCamel(this.name());
    }

    private DbObjects(String label, Class<?> type) {
        this.type = type;
        this.label = label;
    }

    public String getCamelCase() {
        return this.label;
    }

    public String getSnakeCase() {
        return this.name().toLowerCase();
    }

    public String getCamelCaseNameLabel() {
        return this.getCamelCase() + "Name";
    }

    public String getSnakeCaseNameLabel() {
        return this.getSnakeCase() + "_name";
    }

    public Class<?> getType() {
        return this.type;
    }

    public boolean isCollection() {
        return false;
    }

    public DbObjects getCollectionType() {
        return null;
    }

    public DbObjects getParentType() {
        return this.getCollectionType();
    }

    public static List<DbObjects> getCreateOrders() {
        List<DbObjects> list = CommonUtils.list();
        for (DbObjects enm : DbObjects.values()) {
            if (enm.isCollection()) continue;
            list.add(enm);
        }
        DbObjectsComparator comp = new DbObjectsComparator();
        for (int i = 0; i < list.size() - 1; ++i) {
            for (int j = i + 1; j < list.size(); ++j) {
                DbObjects val2;
                DbObjects val1 = list.get(i);
                int cnt = comp.compare(val1, val2 = list.get(j));
                if (cnt <= 0) continue;
                DbObjects.swap(list, i, j);
            }
        }
        return list;
    }

    public static List<DbObjects> getDropOrders() {
        List<DbObjects> list = CommonUtils.list();
        for (DbObjects enm : DbObjects.values()) {
            if (enm.isCollection()) continue;
            list.add(enm);
        }
        DbObjectsComparator comp = new DbObjectsComparator();
        for (int i = 0; i < list.size() - 1; ++i) {
            for (int j = i + 1; j < list.size(); ++j) {
                DbObjects val2;
                DbObjects val1 = list.get(i);
                int cnt = -comp.compare(val1, val2 = list.get(j));
                if (cnt <= 0) continue;
                DbObjects.swap(list, i, j);
            }
        }
        return list;
    }

    private static void swap(List<DbObjects> list, int i, int j) {
        DbObjects val1 = list.get(i);
        DbObjects val2 = list.get(j);
        list.set(i, val2);
        list.set(j, val1);
    }

    private List<DbObjects> getAllDepends() {
        if (CommonUtils.isEmpty(this.getDepends())) {
            return Collections.emptyList();
        }
        List<DbObjects> list = CommonUtils.list();
        this.createAllDepends(this, list);
        return list;
    }

    private void createAllDepends(DbObjects current, List<DbObjects> list) {
        if (CommonUtils.isEmpty(current.getDepends())) {
            return;
        }
        for (DbObjects enm : current.getDepends()) {
            if (!list.contains((Object)enm) && !enm.isCollection()) {
                list.add(enm);
            }
            this.createAllDepends(enm, list);
        }
    }

    private List<DbObjects> getAncestors() {
        if (CommonUtils.isEmpty((Object)this.getParentType())) {
            return Collections.emptyList();
        }
        List<DbObjects> list = CommonUtils.list();
        this.createAncestors(this.getParentType(), list);
        return list;
    }

    private void createAncestors(DbObjects current, List<DbObjects> list) {
        if (!CommonUtils.isEmpty((Object)current.getParentType())) {
            if (!current.getParentType().isCollection()) {
                list.add(current.getParentType());
            }
            this.createAncestors(current.getParentType(), list);
        }
    }

    public DbObjects[] getDepends() {
        return null;
    }

    private static final DbObjects[] array(DbObjects ... args) {
        return args;
    }

    static class DbObjectsComparator
    implements Comparator<DbObjects> {
        DbObjectsComparator() {
        }

        @Override
        public int compare(DbObjects o1, DbObjects o2) {
            int index2;
            List<DbObjects> o1Ans = o1.getAncestors();
            List<DbObjects> o2Ans = o2.getAncestors();
            int index1 = o1Ans.indexOf((Object)o2);
            int comp = this.indexCompare(index1, index2 = o2Ans.indexOf((Object)o1));
            if (comp != 0) {
                return comp * 1000;
            }
            List<DbObjects> o1Dep = o1.getAllDepends();
            List<DbObjects> o2Dep = o2.getAllDepends();
            if (o1Dep.isEmpty()) {
                if (o2Dep.isEmpty()) {
                    return this.compare(o1.toString(), o2.toString());
                }
                return -1;
            }
            if (o2Dep.isEmpty()) {
                return 10;
            }
            if (!o1Dep.contains((Object)o2)) {
                if (!o2Dep.contains((Object)o1)) {
                    return o1Dep.size() - o2Dep.size();
                }
                return -1000;
            }
            if (!o2Dep.contains((Object)o1)) {
                return 1000;
            }
            index1 = o1Dep.indexOf((Object)o2);
            comp = this.indexCompare(index1, index2 = o2Dep.indexOf((Object)o1));
            if (comp != 0) {
                return comp * 100;
            }
            return this.compare(o1.toString(), o2.toString());
        }

        private int indexCompare(int index1, int index2) {
            if (index1 >= 0) {
                if (index2 >= 0) {
                    int comp = index1 - index2;
                    if (comp != 0) {
                        return comp * 1000;
                    }
                    return 0;
                }
                return 1;
            }
            if (index2 >= 0) {
                return -1;
            }
            return 0;
        }

        @Override
        private int compare(String val1, String val2) {
            int comp = val1.compareTo(val2);
            if (comp > 0) {
                return 1;
            }
            if (comp < 0) {
                return -1;
            }
            return 0;
        }
    }

    static class SortableHolder
    implements Comparable<SortableHolder> {
        private int point;
        private final DbObjects dbObjects;

        SortableHolder(DbObjects dbObjects) {
            this.dbObjects = dbObjects;
        }

        public void add(int cnt) {
            this.point += cnt;
        }

        public void setPoint(int point) {
            this.point = point;
        }

        public int getPoint() {
            return this.point;
        }

        public DbObjects getDbObjects() {
            return this.dbObjects;
        }

        @Override
        public int compareTo(SortableHolder o) {
            return this.point - o.point;
        }

        public String toString() {
            ToStringBuilder builder = new ToStringBuilder();
            builder.add("dbObjects", (Object)this.dbObjects);
            builder.add("point", this.point);
            return builder.toString();
        }
    }
}

