/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.DbObjectDifference;
import com.sqlapp.data.schemas.DbObjectDifferenceCollection;
import com.sqlapp.data.schemas.State;
import java.util.function.BiPredicate;

public interface Difference<T> {
    public T getOriginal();

    default public <S> S getOriginal(Class<S> clazz) {
        T obj = this.getOriginal();
        if (obj == null) {
            return null;
        }
        if (clazz.isInstance(obj)) {
            return (S)obj;
        }
        if (DbCommonObject.class.isInstance(obj)) {
            return null;
        }
        return Converters.getDefault().convertObject(obj, clazz);
    }

    public T getTarget();

    default public <S> S getTarget(Class<S> clazz) {
        T obj = this.getTarget();
        if (obj == null) {
            return null;
        }
        if (clazz.isInstance(obj)) {
            return (S)obj;
        }
        if (DbCommonObject.class.isInstance(obj)) {
            return null;
        }
        return Converters.getDefault().convertObject(obj, clazz);
    }

    public DbCommonObject<?> getOriginalParent();

    default public <S extends DbCommonObject<?>> S getOriginalParent(Class<S> clazz) {
        DbCommonObject<?> obj = this.getOriginalParent();
        if (obj == null) {
            return null;
        }
        if (clazz.isInstance(obj)) {
            return (S)obj;
        }
        if (DbCommonObject.class.isInstance(obj)) {
            return null;
        }
        return (S)((DbCommonObject)Converters.getDefault().convertObject(obj, clazz));
    }

    public DbCommonObject<?> getTargetParent();

    default public <S extends DbCommonObject<?>> S getTargetParent(Class<S> clazz) {
        DbCommonObject<?> obj = this.getTargetParent();
        if (obj == null) {
            return null;
        }
        if (clazz.isInstance(obj)) {
            return (S)obj;
        }
        if (DbCommonObject.class.isInstance(obj)) {
            return null;
        }
        return (S)((DbCommonObject)Converters.getDefault().convertObject(obj, clazz));
    }

    public <S extends Difference<?>> S getParentDifference();

    public State getState();

    public DbObjectDifference toDifference();

    public DbObjectDifferenceCollection toDifferenceCollection();

    public void removeRecursive(BiPredicate<String, Difference<?>> var1);

    public Difference<?> reverse();
}

