/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractSchemaObject;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.DbObjects;
import com.sqlapp.data.schemas.DimensionAttributeColumnCollection;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.HasParent;
import com.sqlapp.data.schemas.Schema;
import com.sqlapp.data.schemas.SchemaCollection;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.UnOrdered;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.data.schemas.properties.SchemaNameProperty;
import com.sqlapp.data.schemas.properties.TableNameProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.ToStringBuilder;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;

public class DimensionAttributeColumn
extends AbstractSchemaObject<DimensionAttributeColumn>
implements UnOrdered,
HasParent<DimensionAttributeColumnCollection>,
SchemaNameProperty<DimensionAttributeColumn>,
TableNameProperty<DimensionAttributeColumn> {
    private static final long serialVersionUID = -766487951195992327L;
    private Column column = null;

    public DimensionAttributeColumn() {
    }

    public DimensionAttributeColumn(String name) {
        super(name);
        this.setName(name);
    }

    @Override
    protected Supplier<DimensionAttributeColumn> newInstance() {
        return () -> new DimensionAttributeColumn();
    }

    @Override
    protected String getSimpleName() {
        return DbObjects.COLUMN.getCamelCase();
    }

    @Override
    public String getName() {
        if (this.column == null) {
            return null;
        }
        return this.column.getName();
    }

    @Override
    public String getTableName() {
        if (this.column == null) {
            return null;
        }
        return this.column.getTableName();
    }

    @Override
    public String getSchemaName() {
        if (this.column == null) {
            return null;
        }
        return this.column.getSchemaName();
    }

    @Override
    public DimensionAttributeColumn clone() {
        DimensionAttributeColumn clone = new DimensionAttributeColumn();
        this.cloneProperties(clone);
        return clone;
    }

    public Column getColumn() {
        return this.column;
    }

    public DimensionAttributeColumn setColumn(Column column) {
        this.column = column;
        return (DimensionAttributeColumn)this.instance();
    }

    @Override
    public DimensionAttributeColumn setSchemaName(String schemaName) {
        if (this.column == null) {
            this.column = new Column();
            this.column.setSchemaName(schemaName);
        } else if (!CommonUtils.eq(this.column.getSchemaName(), schemaName)) {
            Column column = new Column(this.column.getName());
            column.setSchemaName(schemaName);
            this.column = column;
        }
        return (DimensionAttributeColumn)this.instance();
    }

    @Override
    public DimensionAttributeColumn setTableName(String tableName) {
        if (this.column == null) {
            this.column = new Column();
            this.column.setTableName(tableName);
        } else if (!CommonUtils.eq(this.column.getTableName(), tableName)) {
            Column column = new Column(this.column.getName());
            column.setTableName(tableName);
            this.column = column;
        }
        return (DimensionAttributeColumn)this.instance();
    }

    @Override
    public DimensionAttributeColumn setName(String arg) {
        if (arg == null || arg.length() == 0) {
            this.column = null;
            return (DimensionAttributeColumn)this.instance();
        }
        String[] vals = arg.split("[, |]");
        Column column = new Column(CommonUtils.last(vals));
        if (vals.length > 1) {
            column.setTableName(vals[vals.length - 2]);
        }
        if (vals.length > 2) {
            column.setSchemaName(vals[vals.length - 3]);
        }
        if (vals.length > 3) {
            column.setCatalogName(vals[vals.length - 4]);
        }
        this.column = column;
        super.setName(column.getName());
        return (DimensionAttributeColumn)this.instance();
    }

    @Override
    protected void toStringDetail(ToStringBuilder builder) {
        builder.add((ISchemaProperty)SchemaProperties.SCHEMA_NAME, this.getSchemaName());
        builder.add((ISchemaProperty)SchemaProperties.TABLE_NAME, this.getTableName());
        builder.add((ISchemaProperty)SchemaProperties.NAME, this.getName());
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        if (!(obj instanceof DimensionAttributeColumn)) {
            return false;
        }
        DimensionAttributeColumn val = (DimensionAttributeColumn)obj;
        if (!this.equals(SchemaProperties.SCHEMA_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.TABLE_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.NAME, val, equalsHandler)) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    @Override
    protected void writeXmlOptionalAttributes(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalAttributes(stax);
        if (!CommonUtils.eq(this.getSchemaName(), this.getParent().getSchemaName())) {
            stax.writeAttribute(SchemaProperties.SCHEMA_NAME.getLabel(), this.getSchemaName());
        }
        stax.writeAttribute(SchemaProperties.TABLE_NAME.getLabel(), this.getTableName());
    }

    @Override
    public DimensionAttributeColumnCollection getParent() {
        return (DimensionAttributeColumnCollection)super.getParent();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    protected void validate() {
        super.validate();
        if (this.getColumn() == null) {
            return;
        }
        Schema schema = this.getAncestor(Schema.class);
        if (this.getColumn().getSchemaName() == null) {
            schema = this.getAncestor(Schema.class);
        } else {
            SchemaCollection schemas = this.getAncestor(SchemaCollection.class);
            if (schemas == null) {
                schema = this.getAncestor(Schema.class);
            }
        }
        if (schema == null) {
            return;
        }
        Table table = (Table)schema.getTables().get(this.getColumn().getTableName());
        if (table == null) {
            return;
        }
        Column col = (Column)table.getColumns().get(this.getColumn().getName());
        if (col != null) {
            this.column = col;
        }
    }
}

