/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractSchemaObject;
import com.sqlapp.data.schemas.DimensionLevelCollection;
import com.sqlapp.data.schemas.DimensionLevelColumn;
import com.sqlapp.data.schemas.DimensionLevelColumnCollection;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.HasParent;
import com.sqlapp.data.schemas.Schema;
import com.sqlapp.data.schemas.SchemaObjectProperties;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.data.schemas.properties.SkipWhenNullProperty;
import com.sqlapp.data.schemas.properties.object.DimensionLevelColumnsProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.ToStringBuilder;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;

public class DimensionLevel
extends AbstractSchemaObject<DimensionLevel>
implements HasParent<DimensionLevelCollection>,
DimensionLevelColumnsProperty<DimensionLevel>,
SkipWhenNullProperty<DimensionLevel> {
    private static final long serialVersionUID = -766487951195992327L;
    private boolean skipWhenNull = (Boolean)SchemaProperties.SKIP_WHEN_NULL.getDefaultValue();
    private DimensionLevelColumnCollection columns = new DimensionLevelColumnCollection(this);

    public DimensionLevel() {
    }

    public DimensionLevel(String name) {
        super(name);
    }

    @Override
    protected Supplier<DimensionLevel> newInstance() {
        return () -> new DimensionLevel();
    }

    public DimensionLevelColumn newColumn() {
        DimensionLevelColumn column = new DimensionLevelColumn();
        column.setParent(this.columns);
        return column;
    }

    protected DimensionLevel setColumns(DimensionLevelColumnCollection columns) {
        this.columns = columns;
        if (columns != null) {
            columns.setParent(this);
        }
        return (DimensionLevel)this.instance();
    }

    @Override
    protected void toStringDetail(ToStringBuilder builder) {
        builder.add((ISchemaProperty)SchemaObjectProperties.DIMENSION_LEVEL_COLUMNS, this.getColumns().toString("(", ")"));
        builder.add((ISchemaProperty)SchemaProperties.SKIP_WHEN_NULL, (Object)this.isSkipWhenNull());
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        if (!(obj instanceof DimensionLevel)) {
            return false;
        }
        DimensionLevel val = (DimensionLevel)obj;
        if (!this.equals(SchemaObjectProperties.DIMENSION_LEVEL_COLUMNS, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.SKIP_WHEN_NULL, val, equalsHandler)) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    @Override
    protected void writeXmlOptionalAttributes(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalAttributes(stax);
        if (this.isSkipWhenNull()) {
            stax.writeAttribute(SchemaProperties.SKIP_WHEN_NULL.getLabel(), (Object)this.isSkipWhenNull());
        }
    }

    @Override
    protected void writeXmlOptionalValues(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalValues(stax);
        if (!CommonUtils.isEmpty(this.columns)) {
            this.columns.writeXml(stax);
        }
    }

    @Override
    protected String getSimpleName() {
        return "level";
    }

    @Override
    public boolean isSkipWhenNull() {
        return this.skipWhenNull;
    }

    @Override
    public DimensionLevel setSkipWhenNull(boolean skipWhenNull) {
        this.skipWhenNull = skipWhenNull;
        return this;
    }

    protected Table getTableFromParent(Table table) {
        if (table == null) {
            return table;
        }
        if (this.getParent() == null) {
            return table;
        }
        if (this.getParent().getSchema() == null) {
            return table;
        }
        Schema getSchema = null;
        if (CommonUtils.eq(table.getSchemaName(), this.getSchemaName())) {
            getSchema = this.getParent().getSchema();
        } else if (this.getParent().getSchema().getParent() != null) {
            getSchema = (Schema)this.getParent().getSchema().getParent().get(table.getSchemaName());
        }
        if (getSchema == null) {
            return table;
        }
        Table ret = getSchema.getTable(table.getName());
        if (ret != null) {
            return ret;
        }
        return table;
    }

    @Override
    public DimensionLevelColumnCollection getColumns() {
        return this.columns;
    }

    public DimensionLevel setColumns(String arg) {
        String[] vals;
        if (arg == null || arg.length() == 0) {
            this.columns.clear();
            return this;
        }
        for (String val : vals = arg.split("[, |]")) {
            this.columns.add(val);
        }
        return this;
    }

    @Override
    public DimensionLevelCollection getParent() {
        return (DimensionLevelCollection)super.getParent();
    }

    @Override
    protected void validate() {
        super.validate();
    }
}

