/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractNamedObjectXmlReaderHandler;
import com.sqlapp.data.schemas.AbstractSchemaObject;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.DbObjects;
import com.sqlapp.data.schemas.DimensionLevel;
import com.sqlapp.data.schemas.DimensionLevelColumnCollection;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.HasParent;
import com.sqlapp.data.schemas.Schema;
import com.sqlapp.data.schemas.SchemaCollection;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.UnOrdered;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.data.schemas.properties.SchemaNameProperty;
import com.sqlapp.data.schemas.properties.TableNameProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.ToStringBuilder;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;

public class DimensionLevelColumn
extends AbstractSchemaObject<DimensionLevelColumn>
implements UnOrdered,
HasParent<DimensionLevelColumnCollection>,
SchemaNameProperty<DimensionLevelColumn>,
TableNameProperty<DimensionLevelColumn> {
    private static final long serialVersionUID = -766487951195992327L;
    private Column column = null;

    public DimensionLevelColumn() {
    }

    public DimensionLevelColumn(String name) {
        super(name);
        this.setName(name);
    }

    @Override
    protected Supplier<DimensionLevelColumn> newInstance() {
        return () -> new DimensionLevelColumn();
    }

    @Override
    protected String getSimpleName() {
        return DbObjects.COLUMN.getCamelCase();
    }

    @Override
    public String getTableName() {
        if (this.column == null) {
            return null;
        }
        return this.column.getTableName();
    }

    @Override
    public String getSchemaName() {
        if (this.column == null) {
            return null;
        }
        return this.column.getSchemaName();
    }

    public Column getColumn() {
        return this.column;
    }

    public DimensionLevelColumn setColumn(Column column) {
        this.column = column;
        return (DimensionLevelColumn)this.instance();
    }

    @Override
    public DimensionLevelColumn setSchemaName(String schemaName) {
        if (this.column == null) {
            this.column = new Column();
            this.column.setSchemaName(schemaName);
        } else if (!CommonUtils.eq(this.column.getSchemaName(), schemaName)) {
            Column column = new Column(this.column.getName());
            column.setSchemaName(schemaName);
            this.column = column;
        }
        return (DimensionLevelColumn)this.instance();
    }

    @Override
    public DimensionLevelColumn setTableName(String tableName) {
        if (this.column == null) {
            this.column = new Column();
            this.column.setTableName(tableName);
        } else if (!CommonUtils.eq(this.column.getTableName(), tableName)) {
            Column column = new Column(this.column.getName());
            column.setTableName(tableName);
            this.column = column;
        }
        return (DimensionLevelColumn)this.instance();
    }

    @Override
    public DimensionLevelColumn setName(String arg) {
        if (arg == null || arg.length() == 0) {
            this.column = null;
            super.setName(arg);
            return (DimensionLevelColumn)this.instance();
        }
        String[] vals = arg.split("[, |]");
        Column column = new Column(CommonUtils.last(vals));
        if (vals.length > 1) {
            column.setTableName(vals[vals.length - 2]);
        }
        if (vals.length > 2) {
            column.setSchemaName(vals[vals.length - 3]);
        }
        if (vals.length > 3) {
            column.setCatalogName(vals[vals.length - 4]);
        }
        super.setName(column.getName());
        this.column = column;
        return (DimensionLevelColumn)this.instance();
    }

    @Override
    protected void toStringDetail(ToStringBuilder builder) {
        builder.add((ISchemaProperty)SchemaProperties.SCHEMA_NAME, this.getSchemaName());
        builder.add((ISchemaProperty)SchemaProperties.TABLE_NAME, this.getTableName());
        builder.add((ISchemaProperty)SchemaProperties.NAME, this.getName());
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        if (!(obj instanceof DimensionLevelColumn)) {
            return false;
        }
        DimensionLevelColumn val = (DimensionLevelColumn)obj;
        if (!this.equals(SchemaProperties.SCHEMA_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.TABLE_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.NAME, val, equalsHandler)) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    @Override
    protected void writeXmlOptionalAttributes(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalAttributes(stax);
        if (!CommonUtils.eq(this.getSchemaName(), this.getParent().getSchemaName())) {
            stax.writeAttribute(SchemaProperties.SCHEMA_NAME.getLabel(), this.getSchemaName());
        }
        stax.writeAttribute(SchemaProperties.TABLE_NAME.getLabel(), this.getTableName());
    }

    @Override
    public DimensionLevelColumnCollection getParent() {
        return (DimensionLevelColumnCollection)super.getParent();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    protected AbstractNamedObjectXmlReaderHandler<DimensionLevelColumn> getDbObjectXmlReaderHandler() {
        return new AbstractNamedObjectXmlReaderHandler<DimensionLevelColumn>(this.newInstance()){

            protected DimensionLevelColumnCollection toParent(Object parentObject) {
                DimensionLevelColumnCollection parent = null;
                if (parentObject instanceof DimensionLevel) {
                    parent = ((DimensionLevel)parentObject).getColumns();
                } else if (parentObject instanceof DimensionLevelColumnCollection) {
                    parent = (DimensionLevelColumnCollection)parentObject;
                }
                return parent;
            }
        };
    }

    @Override
    protected void validate() {
        super.validate();
        if (this.getColumn() == null) {
            return;
        }
        Schema schema = this.getAncestor(Schema.class);
        if (this.getColumn().getSchemaName() == null) {
            schema = this.getAncestor(Schema.class);
        } else {
            SchemaCollection schemas = this.getAncestor(SchemaCollection.class);
            if (schemas == null) {
                schema = this.getAncestor(Schema.class);
            }
        }
        if (schema == null) {
            return;
        }
        Table table = (Table)schema.getTables().get(this.getColumn().getTableName());
        if (table == null) {
            return;
        }
        Column col = (Column)table.getColumns().get(this.getColumn().getName());
        if (col != null) {
            this.column = col;
        }
    }
}

