/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.ArgumentRoutine;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.FunctionCollection;
import com.sqlapp.data.schemas.FunctionReturning;
import com.sqlapp.data.schemas.FunctionType;
import com.sqlapp.data.schemas.HasParent;
import com.sqlapp.data.schemas.OnNullCall;
import com.sqlapp.data.schemas.SchemaObjectProperties;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.properties.FunctionTypeProperty;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.data.schemas.properties.OnNullCallProperty;
import com.sqlapp.data.schemas.properties.StableProperty;
import com.sqlapp.data.schemas.properties.object.FunctionReturningProperty;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.ToStringBuilder;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;

public final class Function
extends ArgumentRoutine<Function>
implements HasParent<FunctionCollection>,
FunctionTypeProperty<Function>,
StableProperty<Function>,
OnNullCallProperty<Function>,
FunctionReturningProperty<Function> {
    private static final long serialVersionUID = 1587998127886007525L;
    private FunctionType functionType = FunctionType.Scalar;
    private OnNullCall onNullCall = null;
    private Boolean stable = null;
    private FunctionReturning returning = new FunctionReturning(this);

    public Function() {
    }

    public Function(String name) {
        super(name);
    }

    @Override
    protected Supplier<Function> newInstance() {
        return () -> new Function();
    }

    public Function(String functionName, String specificName) {
        super(functionName, specificName);
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        if (!(obj instanceof Function)) {
            return false;
        }
        Function val = (Function)obj;
        if (!this.equals(SchemaObjectProperties.FUNCTION_RETURNING, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.FUNCTION_TYPE, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.ON_NULL_CALL, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.STABLE, val, equalsHandler)) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    @Override
    public FunctionReturning getReturning() {
        return this.returning;
    }

    @Override
    public Function setReturning(FunctionReturning returning) {
        if (returning != null) {
            returning.setParent(this);
        }
        if (this.returning != null) {
            this.returning.setParent(null);
        }
        this.returning = returning;
        return (Function)this.instance();
    }

    @Override
    public FunctionCollection getParent() {
        return (FunctionCollection)super.getParent();
    }

    @Override
    protected void writeXmlOptionalAttributes(StaxWriter stax) throws XMLStreamException {
        if (this.getFunctionType() != FunctionType.Scalar) {
            stax.writeAttribute(SchemaProperties.FUNCTION_TYPE.getLabel(), (Object)this.getFunctionType());
        }
        super.writeXmlOptionalAttributes(stax);
        stax.writeAttribute(SchemaProperties.STABLE.getLabel(), (Object)this.getStable());
        stax.writeAttribute(SchemaProperties.ON_NULL_CALL.getLabel(), (Object)this.getOnNullCall());
    }

    @Override
    protected void writeXmlOptionalValues(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalValues(stax);
        this.returning.writeXml(stax);
    }

    @Override
    protected void toStringDetail(ToStringBuilder builder) {
        super.toStringDetail(builder);
        builder.add((ISchemaProperty)SchemaProperties.FUNCTION_TYPE, (Object)this.getFunctionType());
        builder.add("returning", (Object)this.getReturning());
        builder.add((ISchemaProperty)SchemaProperties.ON_NULL_CALL, (Object)this.getOnNullCall());
        builder.add((ISchemaProperty)SchemaProperties.STABLE, (Object)this.getStable());
    }

    @Override
    public FunctionType getFunctionType() {
        return this.functionType;
    }

    @Override
    public Function setFunctionType(FunctionType functionType) {
        this.functionType = functionType;
        return (Function)this.instance();
    }

    @Override
    public OnNullCall getOnNullCall() {
        return this.onNullCall;
    }

    @Override
    public Function setOnNullCall(OnNullCall onNullCall) {
        this.onNullCall = onNullCall;
        return (Function)this.instance();
    }

    @Override
    public Boolean getStable() {
        return this.stable;
    }

    @Override
    public Function setStable(Boolean stable) {
        this.stable = stable;
        if (this.stable != null && this.stable.booleanValue()) {
            this.setDeterministic(null);
        }
        return (Function)this.instance();
    }

    @Override
    public Function setDeterministic(Boolean deterministic) {
        super.setDeterministic(deterministic);
        if (this.getDeterministic() != null) {
            this.stable = null;
        }
        return (Function)this.instance();
    }

    @Override
    protected void validate() {
        super.validate();
        this.returning.validate();
    }
}

