/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.db.datatype.DataType;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.schemas.AbstractDbObject;
import com.sqlapp.data.schemas.CharacterSemantics;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.Function;
import com.sqlapp.data.schemas.FunctionReturningReferenceTable;
import com.sqlapp.data.schemas.HasParent;
import com.sqlapp.data.schemas.SchemaObjectProperties;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.properties.DataTypeSetProperties;
import com.sqlapp.data.schemas.properties.DefinitionProperty;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.data.schemas.properties.NameProperty;
import com.sqlapp.data.schemas.properties.object.FunctionReturningReferenceTableProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.EqualsUtils;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.ToStringBuilder;
import java.util.List;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;

public class FunctionReturning
extends AbstractDbObject<FunctionReturning>
implements HasParent<Function>,
DataTypeSetProperties<FunctionReturning>,
NameProperty<FunctionReturning>,
DefinitionProperty<FunctionReturning>,
FunctionReturningReferenceTableProperty<FunctionReturning> {
    private static final long serialVersionUID = 5048992706883015188L;
    private String name = null;
    private Long maxLength = null;
    private Long octetLength = null;
    private CharacterSemantics characterSemantics = null;
    private DataType dataType = null;
    private String dataTypeName = null;
    private Integer scale = null;
    private int arrayDimension = 0;
    private int arrayLowerBound = 0;
    private int arrayUpperBound = 0;
    private String characterSet = null;
    private String collation = null;
    private List<String> definition = null;
    private FunctionReturningReferenceTable table = null;
    protected static final String SIMPLE_NAME = "returning";

    public FunctionReturning(Function function) {
        super.setParent(function);
    }

    protected FunctionReturning() {
    }

    @Override
    protected Supplier<FunctionReturning> newInstance() {
        return () -> new FunctionReturning();
    }

    @Override
    public Function getParent() {
        return (Function)super.getParent();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public FunctionReturning setName(String name) {
        this.name = name;
        return (FunctionReturning)this.instance();
    }

    @Override
    protected String getSimpleName() {
        return SIMPLE_NAME;
    }

    @Override
    public String getCharacterSet() {
        return this.characterSet;
    }

    @Override
    public FunctionReturning setCharacterSet(String characterSetName) {
        this.characterSet = characterSetName;
        return (FunctionReturning)this.instance();
    }

    @Override
    public String getCollation() {
        return this.collation;
    }

    @Override
    public FunctionReturning setCollation(String collationName) {
        this.collation = collationName;
        return (FunctionReturning)this.instance();
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!(obj instanceof FunctionReturning)) {
            return false;
        }
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        FunctionReturning val = (FunctionReturning)obj;
        if (!this.equals(SchemaProperties.NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.DATA_TYPE, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.DATA_TYPE_NAME, val, equalsHandler, EqualsUtils.getEqualsIgnoreCaseSupplier(this.getDataTypeName(), val.getDataTypeName()))) {
            return false;
        }
        if (!this.equals(SchemaProperties.LENGTH, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.OCTET_LENGTH, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.CHARACTER_SEMANTICS, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.SCALE, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.ARRAY_DIMENSION, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.ARRAY_DIMENSION_LOWER_BOUND, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.ARRAY_DIMENSION_UPPER_BOUND, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.CHARACTER_SET, val, equalsHandler, EqualsUtils.getEqualsIgnoreCaseSupplier(this.getCharacterSet(), val.getCharacterSet()))) {
            return false;
        }
        if (!this.equals(SchemaProperties.COLLATION, val, equalsHandler, EqualsUtils.getEqualsIgnoreCaseSupplier(this.getCollation(), val.getCollation()))) {
            return false;
        }
        if (!this.equals(SchemaObjectProperties.FUNCTION_RETURNING_REFERENCE_TABLE, val, equalsHandler)) {
            return false;
        }
        return this.equals(SchemaProperties.DEFINITION, val, equalsHandler);
    }

    @Override
    public Long getLength() {
        return this.maxLength;
    }

    @Override
    public FunctionReturning setLength(long maxLength) {
        this.maxLength = maxLength;
        return (FunctionReturning)this.instance();
    }

    @Override
    public FunctionReturning setLength(Number maxLength) {
        this.maxLength = Converters.getDefault().convertObject(maxLength, Long.class);
        return (FunctionReturning)this.instance();
    }

    @Override
    public Long getOctetLength() {
        if (this.octetLength != null && this.getLength() != null && this.getLength() > 0L) {
            return this.getLength();
        }
        return this.octetLength;
    }

    @Override
    public FunctionReturning setOctetLength(long octetLength) {
        this.octetLength = octetLength;
        return (FunctionReturning)this.instance();
    }

    @Override
    public FunctionReturning setOctetLength(Number octetLength) {
        this.octetLength = Converters.getDefault().convertObject(octetLength, Long.class);
        return (FunctionReturning)this.instance();
    }

    @Override
    public Dialect getDialect() {
        if (this.getParent() == null) {
            return null;
        }
        return this.getParent().getDialect();
    }

    @Override
    protected void validate() {
        this.setDataTypeName(this.getDataTypeName());
    }

    @Override
    public Integer getScale() {
        return this.scale;
    }

    @Override
    public FunctionReturning setScale(Number scale) {
        this.scale = Converters.getDefault().convertObject(scale, Integer.class);
        return (FunctionReturning)this.instance();
    }

    @Override
    public FunctionReturning setScale(int scale) {
        this.scale = scale;
        return (FunctionReturning)this.instance();
    }

    @Override
    protected void toString(ToStringBuilder builder) {
        builder.add(SchemaProperties.NAME.getLabel(), this.getName());
        builder.add((ISchemaProperty)SchemaProperties.DATA_TYPE, (Object)this.getDataType());
        builder.add((ISchemaProperty)SchemaProperties.DATA_TYPE_NAME, this.getDataTypeName());
        builder.add((ISchemaProperty)SchemaProperties.LENGTH, (Object)this.maxLength);
        builder.add((ISchemaProperty)SchemaProperties.SCALE, (Object)this.getScale());
        builder.add((ISchemaProperty)SchemaProperties.OCTET_LENGTH, (Object)this.getOctetLength());
        builder.add(SchemaProperties.CHARACTER_SEMANTICS.getLabel(), (Object)this.getCharacterSemantics());
        builder.add(SchemaProperties.CHARACTER_SET.getLabel(), this.getCharacterSet());
        builder.add(SchemaProperties.COLLATION.getLabel(), this.getCollation());
        if (this.arrayDimension > 0) {
            builder.add((ISchemaProperty)SchemaProperties.ARRAY_DIMENSION, (Object)this.arrayDimension);
            builder.add((ISchemaProperty)SchemaProperties.ARRAY_DIMENSION_LOWER_BOUND, (Object)this.arrayLowerBound);
            builder.add((ISchemaProperty)SchemaProperties.ARRAY_DIMENSION_UPPER_BOUND, (Object)this.arrayUpperBound);
        }
        builder.add((ISchemaProperty)SchemaProperties.DEFINITION, this.getDefinition());
        super.toString(builder);
    }

    @Override
    protected void writeXmlOptionalAttributes(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalAttributes(stax);
        stax.writeAttribute(SchemaProperties.NAME.getLabel(), this.getName());
        stax.writeAttribute(SchemaProperties.DATA_TYPE.getLabel(), (Object)this.getDataType());
        stax.writeAttribute(SchemaProperties.DATA_TYPE_NAME.getLabel(), this.getDataTypeName());
        stax.writeAttribute(SchemaProperties.LENGTH.getLabel(), (Object)this.getLength());
        if (!CommonUtils.eq(this.getLength(), this.getOctetLength())) {
            stax.writeAttribute(SchemaProperties.OCTET_LENGTH.getLabel(), (Object)this.getOctetLength());
        }
        stax.writeAttribute(SchemaProperties.SCALE.getLabel(), (Object)this.getScale());
        this.writeCharacterSemantics(stax);
        this.writeCharacterSetName(stax);
        this.writeCollationName(stax);
        if (this.getArrayDimension() > 0) {
            stax.writeAttribute(SchemaProperties.ARRAY_DIMENSION.getLabel(), (Object)this.getArrayDimension());
            if (this.getArrayDimensionLowerBound() > 0) {
                stax.writeAttribute(SchemaProperties.ARRAY_DIMENSION_LOWER_BOUND.getLabel(), (Object)this.getArrayDimensionLowerBound());
            }
            if (this.getArrayDimensionUpperBound() > 0) {
                stax.writeAttribute(SchemaProperties.ARRAY_DIMENSION_UPPER_BOUND.getLabel(), (Object)this.getArrayDimensionUpperBound());
            }
        }
    }

    protected void writeCharacterSemantics(StaxWriter stax) throws XMLStreamException {
        stax.writeAttribute(SchemaProperties.CHARACTER_SEMANTICS.getLabel(), (Object)this.getCharacterSemantics());
    }

    protected void writeCharacterSetName(StaxWriter stax) throws XMLStreamException {
        stax.writeAttribute(SchemaProperties.CHARACTER_SET.getLabel(), this.getCharacterSet());
    }

    protected void writeCollationName(StaxWriter stax) throws XMLStreamException {
        stax.writeAttribute(SchemaProperties.COLLATION.getLabel(), this.getCollation());
    }

    @Override
    protected void writeXmlOptionalValues(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalValues(stax);
        if (this.getTable() != null) {
            stax.addIndentLevel(1);
            this.getTable().writeXml(stax);
            stax.addIndentLevel(-1);
        }
        if (!CommonUtils.isEmpty(this.getDefinition())) {
            stax.newLine();
            stax.indent();
            stax.writeCData(SchemaProperties.DEFINITION.getLabel(), this.listToString(this.getDefinition()));
        }
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public FunctionReturning setDataType(DataType dbType) {
        this.dataType = dbType;
        return (FunctionReturning)this.instance();
    }

    @Override
    public int getArrayDimensionLowerBound() {
        return this.arrayLowerBound;
    }

    @Override
    public FunctionReturning setArrayDimensionLowerBound(int arrayLowerBound) {
        this.arrayLowerBound = arrayLowerBound;
        return (FunctionReturning)this.instance();
    }

    @Override
    public int getArrayDimensionUpperBound() {
        return this.arrayUpperBound;
    }

    @Override
    public FunctionReturning setArrayDimensionUpperBound(int arrayUpperBound) {
        this.arrayUpperBound = arrayUpperBound;
        return (FunctionReturning)this.instance();
    }

    @Override
    public int getArrayDimension() {
        return this.arrayDimension;
    }

    @Override
    public FunctionReturning setArrayDimension(int arrayDimension) {
        this.arrayDimension = arrayDimension;
        return (FunctionReturning)this.instance();
    }

    @Override
    public CharacterSemantics getCharacterSemantics() {
        return this.characterSemantics;
    }

    @Override
    public FunctionReturning setCharacterSemantics(CharacterSemantics characterSemantics) {
        this.characterSemantics = characterSemantics;
        return (FunctionReturning)this.instance();
    }

    @Override
    public List<String> getDefinition() {
        if (this.definition == null) {
            this.definition = CommonUtils.list();
        }
        return this.definition;
    }

    @Override
    public FunctionReturning setDefinition(List<String> definition) {
        this.definition = definition;
        return (FunctionReturning)this.instance();
    }

    @Override
    public FunctionReturning setDefinition(String definition) {
        this.definition = CommonUtils.splitLine(definition);
        return (FunctionReturning)this.instance();
    }

    @Override
    public int compareTo(FunctionReturning o) {
        return this.getParent().compareTo(o.getParent());
    }

    @Override
    public FunctionReturningReferenceTable getTable() {
        if (this.table != null) {
            this.table.setDialect(this.getDialect());
        }
        return this.table;
    }

    @Override
    public FunctionReturning setTable(FunctionReturningReferenceTable value) {
        if (value != null) {
            this.table = (FunctionReturningReferenceTable)value.clone();
            this.table.getTable().getRows().clear();
            this.table.setParent(this);
        } else {
            this.table = value;
        }
        return (FunctionReturning)this.instance();
    }

    public FunctionReturning toTable() {
        if (this.getTable() == null) {
            this.table = new FunctionReturningReferenceTable(this);
        }
        this.setDataTypeName(null);
        this.setDataType((DataType)null);
        return (FunctionReturning)this.instance();
    }
}

