/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractSchemaObject;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.HasParent;
import com.sqlapp.data.schemas.MaskCollection;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.properties.ColumnNameProperty;
import com.sqlapp.data.schemas.properties.EnableProperty;
import com.sqlapp.data.schemas.properties.SchemaNameProperty;
import com.sqlapp.data.schemas.properties.TableNameProperty;
import com.sqlapp.data.schemas.properties.TableSchemaNameProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.ToStringBuilder;
import java.util.function.Supplier;

public final class Mask
extends AbstractSchemaObject<Mask>
implements HasParent<MaskCollection>,
SchemaNameProperty<Mask>,
TableSchemaNameProperty<Mask>,
TableNameProperty<Mask>,
ColumnNameProperty<Mask>,
EnableProperty<Mask> {
    private static final long serialVersionUID = -233129040207248096L;
    private Column column = null;
    private boolean enable = true;

    public Mask() {
    }

    public Mask(String name) {
        super(name);
    }

    @Override
    protected Supplier<Mask> newInstance() {
        return () -> new Mask();
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!(obj instanceof Mask)) {
            return false;
        }
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    @Override
    public MaskCollection getParent() {
        return (MaskCollection)super.getParent();
    }

    public Column getColumn() {
        Column col;
        Table table;
        if (this.column == null) {
            return null;
        }
        if (this.column.getParent() == null && (table = SchemaUtils.getTableFromParent(this.column.getSchemaName() != null ? this.column.getSchemaName() : this.getSchemaName(), this.column.getTableName(), this)) != null && (col = (Column)table.getColumns().get(this.column.getName())) != null) {
            this.column = col;
        }
        return this.column;
    }

    @Override
    protected void toStringDetail(ToStringBuilder builder) {
    }

    @Override
    public String getColumnName() {
        if (this.getColumn() != null) {
            return this.getColumn().getName();
        }
        return null;
    }

    @Override
    public Mask setColumnName(String columnName) {
        if (this.column == null) {
            this.column = new Column();
            this.column.setName(columnName);
        } else if (!CommonUtils.eq(this.column.getName(), columnName) && this.column.getName() != null) {
            Column column;
            this.column = column = new Column(columnName);
        } else {
            this.column.setName(columnName);
        }
        return (Mask)this.instance();
    }

    @Override
    public String getTableName() {
        if (this.getColumn() != null) {
            return this.getColumn().getTableName();
        }
        return null;
    }

    public Table getTable() {
        if (this.getColumn() != null) {
            Table table = this.getColumn().getTable();
            if (table != null) {
                return table;
            }
            table = new Table(this.getColumn().getTableName());
            table.setSchemaName(this.getColumn().getSchemaName());
            return table;
        }
        return null;
    }

    @Override
    public Mask setTableName(String tableName) {
        if (this.column == null) {
            this.column = new Column();
            this.column.setTableName(tableName);
        } else if (!CommonUtils.eq(this.column.getTableName(), tableName) && this.column.getTableName() != null) {
            Column column = new Column(this.column.getName());
            column.setTableName(tableName);
            this.column = column;
        } else {
            this.column.setTableName(tableName);
        }
        return (Mask)this.instance();
    }

    @Override
    public String getTableSchemaName() {
        if (this.getColumn() != null) {
            return this.getColumn().getSchemaName();
        }
        return null;
    }

    @Override
    public Mask setTableSchemaName(String tableSchemaName) {
        if (this.column == null) {
            this.column = new Column();
            this.column.setSchemaName(tableSchemaName);
        } else if (!CommonUtils.eq(this.column.getSchemaName(), tableSchemaName) && this.column.getSchemaName() != null) {
            Column column = new Column(this.column.getName());
            column.setSchemaName(tableSchemaName);
            this.column = column;
        } else {
            this.column.setTableName(tableSchemaName);
        }
        return (Mask)this.instance();
    }

    @Override
    public boolean isEnable() {
        return this.enable;
    }

    @Override
    public Mask setEnable(boolean value) {
        this.enable = value;
        return (Mask)this.instance();
    }

    @Override
    protected void validate() {
        super.validate();
        this.getColumn();
    }
}

