/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.db.datatype.DataType;
import com.sqlapp.data.schemas.AbstractSchemaObject;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.FunctionFamilyCollection;
import com.sqlapp.data.schemas.HasParent;
import com.sqlapp.data.schemas.IndexType;
import com.sqlapp.data.schemas.OperatorClassCollection;
import com.sqlapp.data.schemas.OperatorFamilyCollection;
import com.sqlapp.data.schemas.SchemaObjectProperties;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.properties.DataTypeProperties;
import com.sqlapp.data.schemas.properties.DefaultProperty;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.data.schemas.properties.IndexTypeProperty;
import com.sqlapp.data.schemas.properties.object.FunctionFamiliesProperty;
import com.sqlapp.data.schemas.properties.object.OperatorFamiliesProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.EqualsUtils;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.ToStringBuilder;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;

public final class OperatorClass
extends AbstractSchemaObject<OperatorClass>
implements HasParent<OperatorClassCollection>,
DataTypeProperties<OperatorClass>,
DefaultProperty<OperatorClass>,
OperatorFamiliesProperty<OperatorClass>,
FunctionFamiliesProperty<OperatorClass>,
IndexTypeProperty<OperatorClass> {
    private static final long serialVersionUID = -7288255390207070306L;
    private DataType dataType = null;
    private String dataTypeName = null;
    private IndexType indexType = null;
    private boolean _default = (Boolean)SchemaProperties.DEFAULT.getDefaultValue();
    private OperatorFamilyCollection operatorFamilies = new OperatorFamilyCollection(this);
    private FunctionFamilyCollection functionFamilies = new FunctionFamilyCollection(this);

    protected OperatorClass() {
    }

    public OperatorClass(String name) {
        super(name);
    }

    @Override
    protected Supplier<OperatorClass> newInstance() {
        return () -> new OperatorClass();
    }

    @Override
    public OperatorFamilyCollection getOperatorFamilies() {
        return this.operatorFamilies;
    }

    @Override
    public FunctionFamilyCollection getFunctionFamilies() {
        return this.functionFamilies;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public OperatorClass setDataType(DataType dbType) {
        this.dataType = dbType;
        return this;
    }

    @Override
    public String getDataTypeName() {
        return this.dataTypeName;
    }

    @Override
    public IndexType getIndexType() {
        return this.indexType;
    }

    @Override
    public OperatorClass setIndexType(IndexType indexType) {
        this.indexType = indexType;
        return this;
    }

    @Override
    public boolean isDefault() {
        return this._default;
    }

    @Override
    public OperatorClass setDefault(boolean _default) {
        this._default = _default;
        return this;
    }

    @Override
    protected void toStringDetail(ToStringBuilder builder) {
        builder.add((ISchemaProperty)SchemaProperties.DATA_TYPE, (Object)this.getDataType());
        builder.add((ISchemaProperty)SchemaProperties.DATA_TYPE_NAME, this.getDataTypeName());
        builder.add((ISchemaProperty)SchemaProperties.INDEX_TYPE, (Object)this.getIndexType());
        builder.add((ISchemaProperty)SchemaProperties.DEFAULT, (Object)this.isDefault());
        builder.add((ISchemaProperty)SchemaObjectProperties.OPERATOR_FAMILIES, (Object)this.getOperatorFamilies());
        builder.add((ISchemaProperty)SchemaObjectProperties.FUNCTION_FAMILIES, (Object)this.getFunctionFamilies());
    }

    @Override
    protected void writeName(StaxWriter stax) throws XMLStreamException {
        stax.writeAttribute("name", this.getName());
    }

    @Override
    protected void writeXmlOptionalAttributes(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalAttributes(stax);
        stax.writeAttribute(SchemaProperties.DATA_TYPE.getLabel(), (Object)this.getDataType());
        stax.writeAttribute(SchemaProperties.DATA_TYPE_NAME.getLabel(), this.getDataTypeName());
        stax.writeAttribute(SchemaProperties.INDEX_TYPE.getLabel(), (Object)this.getIndexType());
        stax.writeAttribute(SchemaProperties.DEFAULT.getLabel(), (Object)this.isDefault());
    }

    @Override
    protected void writeXmlOptionalValues(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalValues(stax);
        if (!CommonUtils.isEmpty(this.operatorFamilies)) {
            this.operatorFamilies.writeXml(stax);
        }
        if (!CommonUtils.isEmpty(this.functionFamilies)) {
            this.functionFamilies.writeXml(stax);
        }
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!(obj instanceof OperatorClass)) {
            return false;
        }
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        OperatorClass val = (OperatorClass)obj;
        if (!this.equals(SchemaProperties.DATA_TYPE, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.DATA_TYPE_NAME, val, equalsHandler, EqualsUtils.getEqualsIgnoreCaseSupplier(this.getDataTypeName(), val.getDataTypeName()))) {
            return false;
        }
        if (!this.equals(SchemaProperties.INDEX_TYPE, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.DEFAULT, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaObjectProperties.OPERATOR_FAMILIES, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaObjectProperties.FUNCTION_FAMILIES, val, equalsHandler)) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    protected OperatorClass setOperatorFamilies(OperatorFamilyCollection operatorFamilies) {
        this.operatorFamilies = operatorFamilies;
        return this;
    }

    protected OperatorClass setFunctionFamilies(FunctionFamilyCollection functionFamilies) {
        this.functionFamilies = functionFamilies;
        return this;
    }

    @Override
    public OperatorClassCollection getParent() {
        return (OperatorClassCollection)super.getParent();
    }

    @Override
    protected void validate() {
        if (this.getDialect() != null) {
            String dataTypeName = this.getDataTypeName();
            this.setDataTypeName(dataTypeName);
        }
        this.operatorFamilies.validate();
        this.functionFamilies.validate();
    }
}

