/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.EnumProperties;
import com.sqlapp.util.CommonUtils;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum ProcedureType implements EnumProperties
{
    Procedure("PROCEDURE", "Pro.*"),
    Function("FUNCTION", "F.*"),
    Package("PACKAGE", "Pack.*"),
    PackageBody("PACKAGE BODY", "Pack.*Body"),
    Trigger("TRIGGER", "T.*");

    private final String text;
    private final Pattern pattern;

    private ProcedureType(String text, String patternText) {
        this.text = text;
        this.pattern = Pattern.compile(patternText, 2);
    }

    public static ProcedureType parse(String type) {
        if (CommonUtils.isEmpty(type)) {
            return null;
        }
        for (ProcedureType procedureType : ProcedureType.values()) {
            Matcher matcher = procedureType.pattern.matcher(type);
            if (!matcher.matches()) continue;
            return procedureType;
        }
        return null;
    }

    @Override
    public String getDisplayName() {
        return this.text;
    }

    @Override
    public String getDisplayName(Locale locale) {
        return this.getDisplayName();
    }

    @Override
    public String getSqlValue() {
        return this.getDisplayName();
    }
}

