/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractNamedObject;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.HasParent;
import com.sqlapp.data.schemas.PublicDbLinkCollection;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.data.schemas.properties.ObjectLinkProperties;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.ToStringBuilder;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;

public final class PublicDbLink
extends AbstractNamedObject<PublicDbLink>
implements HasParent<PublicDbLinkCollection>,
ObjectLinkProperties<PublicDbLink> {
    private static final long serialVersionUID = -5594263228976491676L;
    private String driverClassName = null;
    private String userId = null;
    private String password = null;
    private String dataSource = null;
    private String connectionCatalog = null;
    private boolean passwordEncrypted = false;

    protected PublicDbLink() {
    }

    public PublicDbLink(String name) {
        super(name);
    }

    @Override
    protected Supplier<PublicDbLink> newInstance() {
        return () -> new PublicDbLink();
    }

    @Override
    protected void toStringDetail(ToStringBuilder builder) {
        builder.add((ISchemaProperty)SchemaProperties.USER_ID, this.getUserId());
        builder.add((ISchemaProperty)SchemaProperties.PASSWORD, this.getPassword());
        builder.add((ISchemaProperty)SchemaProperties.PASSWORD_ENCRYPTED, (Object)this.isPasswordEncrypted());
        builder.add((ISchemaProperty)SchemaProperties.DRIVER_CLASS_NAME, this.getDriverClassName());
        builder.add((ISchemaProperty)SchemaProperties.DATA_SOURCE, this.getDataSource());
        builder.add((ISchemaProperty)SchemaProperties.CONNECTION_CATALOG, this.getConnectionCatalog());
        this.toStringChild(builder);
    }

    protected void toStringChild(ToStringBuilder builder) {
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        if (!(obj instanceof PublicDbLink)) {
            return false;
        }
        PublicDbLink val = (PublicDbLink)obj;
        if (!this.equals(SchemaProperties.USER_ID, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.PASSWORD, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.PASSWORD_ENCRYPTED, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.DRIVER_CLASS_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.DATA_SOURCE, val, equalsHandler)) {
            return false;
        }
        return this.equals(SchemaProperties.CONNECTION_CATALOG, val, equalsHandler);
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    public PublicDbLink setUserId(String userId) {
        this.userId = userId;
        return (PublicDbLink)this.instance();
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public PublicDbLink setPassword(String password) {
        this.password = password;
        return (PublicDbLink)this.instance();
    }

    @Override
    public String getDataSource() {
        return this.dataSource;
    }

    @Override
    public PublicDbLink setDataSource(String dataSource) {
        this.dataSource = dataSource;
        return (PublicDbLink)this.instance();
    }

    @Override
    public boolean isPasswordEncrypted() {
        return this.passwordEncrypted;
    }

    @Override
    public PublicDbLink setPasswordEncrypted(boolean passwordEncrypted) {
        this.passwordEncrypted = passwordEncrypted;
        return (PublicDbLink)this.instance();
    }

    @Override
    public String getDriverClassName() {
        return this.driverClassName;
    }

    @Override
    public PublicDbLink setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
        return (PublicDbLink)this.instance();
    }

    @Override
    public String getConnectionCatalog() {
        return this.connectionCatalog;
    }

    @Override
    public PublicDbLink setConnectionCatalog(String connectionCatalog) {
        this.connectionCatalog = connectionCatalog;
        return (PublicDbLink)this.instance();
    }

    @Override
    protected void writeXmlOptionalAttributes(StaxWriter stax) throws XMLStreamException {
        stax.writeAttribute(SchemaProperties.DRIVER_CLASS_NAME.getLabel(), this.getDriverClassName());
        stax.writeAttribute(SchemaProperties.USER_ID.getLabel(), this.getUserId());
        stax.writeAttribute(SchemaProperties.PASSWORD.getLabel(), this.getPassword());
        if (!CommonUtils.isEmpty(this.getPassword())) {
            stax.writeAttribute(SchemaProperties.PASSWORD_ENCRYPTED.getLabel(), (Object)this.isPasswordEncrypted());
        }
        stax.writeAttribute(SchemaProperties.DATA_SOURCE.getLabel(), this.getDataSource());
        stax.writeAttribute(SchemaProperties.CONNECTION_CATALOG.getLabel(), this.getConnectionCatalog());
    }

    @Override
    public PublicDbLinkCollection getParent() {
        return (PublicDbLinkCollection)super.getParent();
    }
}

