/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractNamedObject;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.DbObjects;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.HasParent;
import com.sqlapp.data.schemas.NullsOrder;
import com.sqlapp.data.schemas.Order;
import com.sqlapp.data.schemas.ReferenceColumnCollection;
import com.sqlapp.data.schemas.ReferenceColumnXmlReaderHandler;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.data.schemas.properties.IncludedColumnProperty;
import com.sqlapp.data.schemas.properties.LengthProperty;
import com.sqlapp.data.schemas.properties.NullsOrderProperty;
import com.sqlapp.data.schemas.properties.OrderProperty;
import com.sqlapp.data.schemas.properties.SchemaNameProperty;
import com.sqlapp.data.schemas.properties.TableNameProperty;
import com.sqlapp.data.schemas.properties.WithProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.EqualsUtils;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.ToStringBuilder;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;

public final class ReferenceColumn
extends AbstractNamedObject<ReferenceColumn>
implements HasParent<ReferenceColumnCollection>,
SchemaNameProperty<ReferenceColumn>,
TableNameProperty<ReferenceColumn>,
OrderProperty<ReferenceColumn>,
LengthProperty<ReferenceColumn>,
NullsOrderProperty<ReferenceColumn>,
IncludedColumnProperty<ReferenceColumn>,
WithProperty<ReferenceColumn> {
    private static final long serialVersionUID = -6483603161537304602L;
    private String schemaName = null;
    private String tableName = null;
    private Column column = null;
    private Order order = (Order)SchemaProperties.ORDER.getDefaultValue();
    private Long length = (Long)SchemaProperties.LENGTH.getDefaultValue();
    private NullsOrder nullsOrder = (NullsOrder)SchemaProperties.NULLS_ORDER.getDefaultValue();
    private boolean includedColumn = (Boolean)SchemaProperties.INCLUDED_COLUMN.getDefaultValue();
    private String with = (String)SchemaProperties.WITH.getDefaultValue();

    @Override
    protected Supplier<ReferenceColumn> newInstance() {
        return () -> new ReferenceColumn();
    }

    @Override
    public String getSchemaName() {
        if (this.column != null) {
            return this.column.getSchemaName();
        }
        Table table = this.getTable();
        if (table != null) {
            return table.getSchemaName();
        }
        return this.schemaName;
    }

    @Override
    public ReferenceColumn setSchemaName(String value) {
        this.schemaName = value;
        return this;
    }

    @Override
    public String getTableName() {
        if (this.column != null) {
            return this.column.getTableName();
        }
        Table table = this.getTable();
        if (table != null) {
            return table.getName();
        }
        return this.tableName;
    }

    @Override
    public ReferenceColumn setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    protected Table getTable() {
        return this.getAncestor(Table.class);
    }

    protected ReferenceColumn() {
    }

    public ReferenceColumn(Column column) {
        this.column = column;
    }

    public ReferenceColumn(Column column, Order order) {
        this.column = column;
        this.order = order;
    }

    public ReferenceColumn(String name) {
        super(name);
    }

    @Override
    protected String getSimpleName() {
        return DbObjects.COLUMN.getCamelCase();
    }

    @Override
    public String getName() {
        if (this.column == null) {
            return super.getName();
        }
        return this.column.getName();
    }

    @Override
    public ReferenceColumn setName(String name) {
        if (CommonUtils.eq(this.getName(), name)) {
            return (ReferenceColumn)this.instance();
        }
        if (this.column != null) {
            this.column = new Column(name);
        } else {
            super.setName(name);
        }
        return this;
    }

    @Override
    protected void writeXmlOptionalAttributes(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalAttributes(stax);
        stax.writeAttribute(SchemaProperties.LENGTH.getLabel(), (Object)this.getLength());
        stax.writeAttribute(SchemaProperties.ORDER.getLabel(), (Object)this.convertOrder(this.getOrder()));
        stax.writeAttribute(SchemaProperties.NULLS_ORDER.getLabel(), (Object)this.getNullsOrder());
        if (this.isIncludedColumn()) {
            stax.writeAttribute(SchemaProperties.INCLUDED_COLUMN.getLabel(), (Object)this.isIncludedColumn());
        }
        stax.writeAttribute(SchemaProperties.WITH.getLabel(), this.getWith());
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!(obj instanceof ReferenceColumn)) {
            return false;
        }
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        ReferenceColumn val = (ReferenceColumn)obj;
        if (!this.equals(SchemaProperties.LENGTH, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.ORDER, val, equalsHandler, EqualsUtils.getEqualsSupplier(this.convertOrder(this.getOrder()), this.convertOrder(val.getOrder())))) {
            return false;
        }
        if (!this.equals(SchemaProperties.NULLS_ORDER, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.INCLUDED_COLUMN, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.WITH, val, equalsHandler)) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    @Override
    public boolean like(Object obj) {
        if (!(obj instanceof ReferenceColumn)) {
            return false;
        }
        ReferenceColumn cst = (ReferenceColumn)obj;
        return CommonUtils.eq(this.getName(), cst.getName());
    }

    private Order convertOrder(Order order) {
        if (Order.Asc == order) {
            return null;
        }
        return order;
    }

    @Override
    protected void toStringDetail(ToStringBuilder builder) {
        if (this.getLength() != null) {
            builder.add((ISchemaProperty)SchemaProperties.LENGTH, (Object)this.getLength());
        }
        if (this.getOrder() != null && this.getOrder() != Order.Asc) {
            builder.add((ISchemaProperty)SchemaProperties.ORDER, (Object)this.getOrder());
        }
        if (this.getNullsOrder() != null) {
            builder.add((ISchemaProperty)SchemaProperties.NULLS_ORDER, (Object)this.getNullsOrder());
        }
        if (this.isIncludedColumn()) {
            builder.add((ISchemaProperty)SchemaProperties.INCLUDED_COLUMN, (Object)this.isIncludedColumn());
        }
        if (this.getWith() != null) {
            builder.add((ISchemaProperty)SchemaProperties.WITH, this.getWith());
        }
    }

    @Override
    public Order getOrder() {
        return this.order;
    }

    @Override
    public ReferenceColumn setOrder(Order order) {
        this.order = order;
        return this;
    }

    @Override
    public Long getLength() {
        return this.length;
    }

    @Override
    public ReferenceColumn setLength(long length) {
        this.length = length;
        return this;
    }

    @Override
    public ReferenceColumn setLength(Number length) {
        this.length = length != null ? Long.valueOf(length.longValue()) : null;
        return this;
    }

    @Override
    public NullsOrder getNullsOrder() {
        return this.nullsOrder;
    }

    @Override
    public ReferenceColumn setNullsOrder(NullsOrder nullsOrder) {
        this.nullsOrder = nullsOrder;
        return this;
    }

    protected Column getColumn() {
        return this.column;
    }

    protected ReferenceColumn setColumn(Column column) {
        super.setName(null);
        this.column = column;
        return this;
    }

    @Override
    public boolean isIncludedColumn() {
        return this.includedColumn;
    }

    @Override
    public ReferenceColumn setIncludedColumn(boolean includedColumn) {
        this.includedColumn = includedColumn;
        return this;
    }

    @Override
    public String getWith() {
        return this.with;
    }

    @Override
    public ReferenceColumn setWith(String with) {
        this.with = with;
        return this;
    }

    @Override
    public ReferenceColumnCollection getParent() {
        return (ReferenceColumnCollection)super.getParent();
    }

    @Override
    protected ReferenceColumnXmlReaderHandler getDbObjectXmlReaderHandler() {
        return new ReferenceColumnXmlReaderHandler();
    }
}

