/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractBaseDbObjectCollection;
import com.sqlapp.data.schemas.AbstractSchemaObject;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.properties.ClassNamePrefixProperty;
import com.sqlapp.data.schemas.properties.ClassNameProperty;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.data.schemas.properties.LanguageProperty;
import com.sqlapp.data.schemas.properties.MethodNameProperty;
import com.sqlapp.data.schemas.properties.SpecificNameProperty;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.EqualsUtils;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.ToStringBuilder;
import javax.xml.stream.XMLStreamException;

public abstract class Routine<T extends Routine<T>>
extends AbstractSchemaObject<T>
implements ClassNamePrefixProperty<T>,
ClassNameProperty<T>,
MethodNameProperty<T>,
SpecificNameProperty<T>,
LanguageProperty<T> {
    private static final long serialVersionUID = 8421121636119616875L;
    private String classNamePrefix = null;
    private String className = null;
    private String methodName = null;
    private String language = null;
    private String specificName = null;

    protected Routine() {
    }

    public Routine(String name) {
        super(name);
    }

    public Routine(String name, String specificName) {
        super(name, specificName);
    }

    @Override
    public String getSpecificName() {
        if (CommonUtils.isEmpty(this.specificName)) {
            return this.getName();
        }
        return this.specificName;
    }

    @Override
    public T setSpecificName(String specificName) {
        if (specificName == null) {
            this.specificName = specificName;
            return (T)((Routine)this.instance());
        }
        String[] names = specificName.split("\\.");
        int i = 0;
        if (names.length > 1) {
            this.setSchemaName(names[i++]);
        }
        this.specificName = names[i++];
        return (T)((Routine)this.instance());
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!(obj instanceof Routine)) {
            return false;
        }
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        Routine val = (Routine)CommonUtils.cast(obj);
        if (!this.equals(SchemaProperties.CLASS_NAME_PREFIX, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.CLASS_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.METHOD_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.LANGUAGE, val, equalsHandler, EqualsUtils.getEqualsIgnoreCaseSupplier(CommonUtils.emptyToNull(val.getLanguage()), CommonUtils.emptyToNull(this.getLanguage())))) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    @Override
    protected void toStringDetail(ToStringBuilder builder) {
        builder.add((ISchemaProperty)SchemaProperties.CLASS_NAME_PREFIX, this.getClassNamePrefix());
        builder.add((ISchemaProperty)SchemaProperties.CLASS_NAME, this.getClassName());
        builder.add((ISchemaProperty)SchemaProperties.METHOD_NAME, this.getMethodName());
        builder.add((ISchemaProperty)SchemaProperties.LANGUAGE, this.getLanguage());
    }

    @Override
    protected void writeXmlOptionalAttributes(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalAttributes(stax);
        stax.writeAttribute(SchemaProperties.CLASS_NAME_PREFIX.getLabel(), this.getClassNamePrefix());
        stax.writeAttribute(SchemaProperties.CLASS_NAME.getLabel(), this.getClassName());
        stax.writeAttribute(SchemaProperties.METHOD_NAME.getLabel(), this.getMethodName());
        if (!CommonUtils.isEmpty(this.getLanguage())) {
            stax.writeAttribute(SchemaProperties.LANGUAGE.getLabel(), this.getLanguage());
        }
    }

    @Override
    protected void writeXmlOptionalValues(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalValues(stax);
    }

    protected void renewParent() {
        if (this.getParent() != null && this.getParent() instanceof AbstractBaseDbObjectCollection) {
            ((AbstractBaseDbObjectCollection)this.getParent()).renew();
        }
    }

    @Override
    public String getClassNamePrefix() {
        return this.classNamePrefix;
    }

    @Override
    public T setClassNamePrefix(String classNamePrefix) {
        this.classNamePrefix = classNamePrefix;
        return (T)((Routine)this.instance());
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public T setClassName(String className) {
        this.className = className;
        return (T)((Routine)this.instance());
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public T setMethodName(String methodName) {
        this.methodName = methodName;
        return (T)((Routine)this.instance());
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public T setLanguage(String language) {
        this.language = language;
        return (T)((Routine)this.instance());
    }
}

