/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.AbstractObjectXmlReaderHandler;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.Row;
import com.sqlapp.data.schemas.RowCollection;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.ValueHolder;
import com.sqlapp.data.schemas.ValueHolderXmlReaderHandler;
import com.sqlapp.data.schemas.function.RowValueConverter;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.StaxReader;
import com.sqlapp.util.xml.NotEmptyTextHandler;
import com.sqlapp.util.xml.SetValue;
import com.sqlapp.util.xml.StaxElementHandler;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class RowXmlReaderHandler
extends AbstractObjectXmlReaderHandler<Row> {
    private static Logger log = LogManager.getLogger(RowXmlReaderHandler.class);
    private RowValueConverter rowValueConverter = null;
    private final String LOCAL_NAME = this.createNewInstance(null).getSimpleName();

    protected RowXmlReaderHandler() {
    }

    @Override
    protected void initializeSetValue() {
        super.initializeSetValue();
        this.registerChild(new NotEmptyTextHandler());
        this.registerChild(new ValueHolderXmlReaderHandler());
    }

    @Override
    public String getLocalName() {
        return this.LOCAL_NAME;
    }

    @Override
    public void doCallback(StaxReader reader, StaxElementHandler child, String name, Object ownObject, Object childObject) throws XMLStreamException {
        Row row = (Row)ownObject;
        try {
            this.setValue(row, name, childObject);
        }
        catch (RuntimeException e) {
            if (row != null) {
                Location location = reader.getLocation();
                row.setDataSourceRowNumber(location.getLineNumber());
            }
            throw e;
        }
    }

    @Override
    protected void setValue(Row obj, String key, Object value) throws XMLStreamException {
        Column column;
        String comment = null;
        String option = null;
        if (value instanceof ValueHolder) {
            ValueHolder valueHolder = (ValueHolder)ValueHolder.class.cast(value);
            key = valueHolder.getKey();
            value = valueHolder.getValue();
            comment = valueHolder.getComment();
            option = valueHolder.getOption();
        }
        if ((column = (Column)obj.getParent().getParent().getColumns().get(key)) != null) {
            obj.put(column, this.getRowValueConverter().apply(obj, column, value));
            if (comment != null) {
                obj.putRemarks(column, comment);
            }
            if (option != null) {
                obj.putOption(column, option);
            }
        } else {
            SetValue setValue = (SetValue)CommonUtils.cast(this.setValueMap.get(key));
            if (setValue != null && value != null) {
                setValue.setValue(obj, key, value);
            } else if (log.isWarnEnabled()) {
                log.warn("[" + key + "] column not found.");
            }
        }
    }

    protected RowValueConverter getRowValueConverter() {
        if (this.rowValueConverter == null) {
            this.rowValueConverter = this.getReaderOptions().getRowValueConverter();
        }
        return this.rowValueConverter;
    }

    @Override
    protected Row createNewInstance(Object parentObject) {
        if (parentObject instanceof RowCollection) {
            RowCollection rows = (RowCollection)parentObject;
            return rows.newElement();
        }
        if (parentObject instanceof Table) {
            Table table = (Table)parentObject;
            return table.newRow();
        }
        Row row = new Row();
        return row;
    }
}

