/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.DialectResolver;
import com.sqlapp.data.schemas.AbstractBaseDbObject;
import com.sqlapp.data.schemas.AbstractBaseDbObjectCollection;
import com.sqlapp.data.schemas.AbstractColumn;
import com.sqlapp.data.schemas.AbstractDbObject;
import com.sqlapp.data.schemas.AbstractDbObjectCollection;
import com.sqlapp.data.schemas.AbstractSchemaObject;
import com.sqlapp.data.schemas.AssemblyFile;
import com.sqlapp.data.schemas.Catalog;
import com.sqlapp.data.schemas.CatalogCollection;
import com.sqlapp.data.schemas.CharacterSemantics;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.ColumnCollectionXmlReaderHandler;
import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.DbObject;
import com.sqlapp.data.schemas.DimensionAttribute;
import com.sqlapp.data.schemas.DimensionAttributeColumn;
import com.sqlapp.data.schemas.DimensionHierarchy;
import com.sqlapp.data.schemas.DimensionHierarchyJoinKeyColumn;
import com.sqlapp.data.schemas.DimensionHierarchyLevel;
import com.sqlapp.data.schemas.DimensionLevel;
import com.sqlapp.data.schemas.DimensionLevelColumn;
import com.sqlapp.data.schemas.ForeignKeyConstraint;
import com.sqlapp.data.schemas.Function;
import com.sqlapp.data.schemas.Index;
import com.sqlapp.data.schemas.NamedArgument;
import com.sqlapp.data.schemas.Operator;
import com.sqlapp.data.schemas.OperatorArgument;
import com.sqlapp.data.schemas.Partition;
import com.sqlapp.data.schemas.PartitionFunction;
import com.sqlapp.data.schemas.PartitionScheme;
import com.sqlapp.data.schemas.Role;
import com.sqlapp.data.schemas.Routine;
import com.sqlapp.data.schemas.Row;
import com.sqlapp.data.schemas.RowCollection;
import com.sqlapp.data.schemas.Schema;
import com.sqlapp.data.schemas.SchemaCollection;
import com.sqlapp.data.schemas.SchemaObjectProperties;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.Sequence;
import com.sqlapp.data.schemas.Setting;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.TableCreateOrderComparator;
import com.sqlapp.data.schemas.TableDropOrderComparator;
import com.sqlapp.data.schemas.TableSpace;
import com.sqlapp.data.schemas.TableSpaceFile;
import com.sqlapp.data.schemas.Type;
import com.sqlapp.data.schemas.TypeColumn;
import com.sqlapp.data.schemas.User;
import com.sqlapp.data.schemas.properties.CharacterSemanticsProperty;
import com.sqlapp.data.schemas.properties.CharacterSetProperty;
import com.sqlapp.data.schemas.properties.CollationProperty;
import com.sqlapp.data.schemas.properties.DataTypeNameProperty;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.data.schemas.properties.NameProperty;
import com.sqlapp.data.schemas.properties.ProductProperties;
import com.sqlapp.data.schemas.properties.SchemaNameProperty;
import com.sqlapp.data.schemas.properties.TableNameProperty;
import com.sqlapp.util.ClassFinder;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.DoubleKeyMap;
import com.sqlapp.util.Factory;
import com.sqlapp.util.FileUtils;
import com.sqlapp.util.SeparatedStringBuilder;
import com.sqlapp.util.SimpleBeanUtils;
import com.sqlapp.util.StaxReader;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.StringUtils;
import com.sqlapp.util.TripleKeyMap;
import com.sqlapp.util.xml.StaxElementHandler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;

public class SchemaUtils {
    private static final Map<String, Factory<? extends DbCommonObject<?>>> FACTORYS = CommonUtils.upperMap();
    private static Map<String, String> PLURAL_NAME_CACHE = CommonUtils.concurrentMap();
    private static final Map<Class<?>, Set<Class<?>>> CLASSES_CACHE = CommonUtils.map();
    private static Map<Class<?>, Set<ISchemaProperty>> ALL_SCHEMA_PROPERTIES_SET = CommonUtils.map();
    private static Map<Class<?>, Set<ISchemaProperty>> SCHEMA_PROPERTIES_SET = CommonUtils.map();
    private static Map<Class<?>, Set<ISchemaProperty>> SCHEMA_OBJECT_PROPERTIES_SET = CommonUtils.map();

    private SchemaUtils() {
    }

    private static <V extends DbCommonObject<?>> V getByXml(Class<?> clazz, String path) throws FileNotFoundException, XMLStreamException {
        InputStream fis = FileUtils.getInputStream(clazz, path);
        if (fis == null) {
            throw new FileNotFoundException(path);
        }
        return SchemaUtils.getByXml(fis);
    }

    private static <V extends DbCommonObject<?>> V getByXml(InputStream is) throws XMLStreamException {
        V v;
        StaxReader staxReader;
        BufferedInputStream bis;
        block5: {
            bis = null;
            bis = new BufferedInputStream(is);
            staxReader = new StaxReader(bis, "UTF-8");
            staxReader.nextFristStartElement();
            if (staxReader.isStartElement()) break block5;
            V v2 = null;
            FileUtils.close(bis);
            FileUtils.close(is);
            return v2;
        }
        try {
            String name = staxReader.getName().getLocalPart();
            v = SchemaUtils.createInstance(name);
        }
        catch (XMLStreamException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                FileUtils.close(bis);
                FileUtils.close(is);
                throw throwable;
            }
        }
        FileUtils.close(bis);
        FileUtils.close(is);
        return v;
    }

    private static <V extends DbCommonObject<?>> V getByXml(String path) throws FileNotFoundException, XMLStreamException {
        return SchemaUtils.getByXml(SchemaUtils.class, path);
    }

    public static <V extends DbCommonObject<?>> V readXml(Class<?> clazz, String path) throws XMLStreamException, IOException {
        return SchemaUtils.readXml(FileUtils.getInputStream(clazz, path));
    }

    public static <V extends DbCommonObject<?>> V readXml(String path) throws FileNotFoundException, XMLStreamException {
        V obj = SchemaUtils.getByXml(path);
        obj.loadXml(path);
        return obj;
    }

    public static <V extends DbCommonObject<?>> V readXml(File file) throws XMLStreamException, IOException {
        return SchemaUtils.readXml(new FileInputStream(file));
    }

    public static <V extends DbCommonObject<?>> V readXml(InputStream is) throws XMLStreamException, IOException {
        V v;
        StaxReader staxReader;
        BufferedInputStream bis;
        block5: {
            bis = null;
            int readlimit = 10240;
            bis = new BufferedInputStream(is, 10240);
            bis.mark(10240);
            staxReader = new StaxReader(bis, "UTF-8");
            staxReader.nextFristStartElement();
            if (staxReader.isStartElement()) break block5;
            V v2 = null;
            FileUtils.close(bis);
            FileUtils.close(is);
            return v2;
        }
        try {
            String name = staxReader.getName().getLocalPart();
            V obj = SchemaUtils.createInstance(name);
            bis.reset();
            obj.loadXml(bis);
            v = obj;
        }
        catch (XMLStreamException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                FileUtils.close(bis);
                FileUtils.close(is);
                throw throwable;
            }
        }
        FileUtils.close(bis);
        FileUtils.close(is);
        return v;
    }

    public static <V extends DbCommonObject<?>> V readXml(Reader reader) throws XMLStreamException, IOException {
        V v;
        StaxReader staxReader;
        BufferedReader br;
        block5: {
            br = null;
            int readlimit = 10240;
            br = new BufferedReader(reader, 10240);
            br.mark(10240);
            staxReader = new StaxReader(reader);
            staxReader.nextFristStartElement();
            if (staxReader.isStartElement()) break block5;
            V v2 = null;
            FileUtils.close(br);
            FileUtils.close(reader);
            return v2;
        }
        try {
            String name = staxReader.getName().getLocalPart();
            V obj = SchemaUtils.createInstance(name);
            br.reset();
            obj.loadXml(br);
            v = obj;
        }
        catch (XMLStreamException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                FileUtils.close(br);
                FileUtils.close(reader);
                throw throwable;
            }
        }
        FileUtils.close(br);
        FileUtils.close(reader);
        return v;
    }

    public static <V extends DbCommonObject<?>> void writeAllXml(List<V> list, OutputStream stream) throws XMLStreamException {
        for (DbCommonObject obj : list) {
            obj.writeXml(stream);
        }
    }

    public static <V extends DbCommonObject<?>> void writeAllXml(List<V> list, Writer writer) throws XMLStreamException {
        for (DbCommonObject obj : list) {
            obj.writeXml(writer);
        }
    }

    public static <V extends DbCommonObject<?>> void writeAllXml(List<V> list, StaxWriter writer) throws XMLStreamException {
        for (DbCommonObject obj : list) {
            obj.writeXml(writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V extends DbCommonObject<?>> void writeAllXml(List<V> list, String path) throws XMLStreamException, FileNotFoundException {
        FileOutputStream fos = null;
        BufferedOutputStream bos = null;
        try {
            fos = new FileOutputStream(path);
            bos = new BufferedOutputStream(fos);
            StaxWriter staxWriter = new StaxWriter(bos);
            for (DbCommonObject obj : list) {
                obj.writeXml(staxWriter);
            }
        }
        catch (Throwable throwable) {
            FileUtils.close(bos);
            FileUtils.close(fos);
            throw throwable;
        }
        FileUtils.close(bos);
        FileUtils.close(fos);
    }

    public static <V extends DbCommonObject<?>> V createInstance(String name) {
        Factory<DbCommonObject<?>> factory;
        if (FACTORYS.size() == 0) {
            SchemaUtils.loadFactories();
        }
        if ((factory = FACTORYS.get(name)) == null) {
            throw new UnsupportedOperationException(name + " does not support.");
        }
        return (V)factory.newInstance();
    }

    protected static void registerFactory(String name, Factory<? extends DbCommonObject<?>> factory) {
        FACTORYS.put(name, factory);
    }

    private static synchronized void loadFactories() {
        Set<Class<?>> clazzes = SchemaUtils.getSubClasses(DbCommonObject.class);
        for (Class<?> clazz : clazzes) {
            SchemaUtils.registerFactory(clazz);
        }
    }

    protected static void registerFactory(final Class<? extends DbCommonObject<?>> clazz) {
        if (clazz.getSimpleName().endsWith("Collection")) {
            SchemaUtils.registerFactory(StringUtils.uncapitalize(SchemaUtils.getPluralName(clazz)), new Factory<DbCommonObject<?>>(){

                @Override
                public DbCommonObject<?> newInstance() {
                    return (DbCommonObject)SchemaUtils.newInstanceAtSchemas(clazz);
                }
            });
        } else {
            SchemaUtils.registerFactory(StringUtils.uncapitalize(clazz.getSimpleName()), new Factory<DbCommonObject<?>>(){

                @Override
                public DbCommonObject<?> newInstance() {
                    return (DbCommonObject)SchemaUtils.newInstanceAtSchemas(clazz);
                }
            });
        }
    }

    public static String getPluralName(Class<?> clazz) {
        String val = clazz.getSimpleName();
        return SchemaUtils.getPluralName(val);
    }

    public static String getPluralName(String name) {
        String value = PLURAL_NAME_CACHE.get(name);
        if (value != null) {
            return value;
        }
        value = SchemaUtils.getPluralNameInternal(name);
        PLURAL_NAME_CACHE.putIfAbsent(name, value);
        return value;
    }

    private static String getPluralNameInternal(String name) {
        if (((String)name).endsWith("ss")) {
            return (String)name + "es";
        }
        if (((String)name).endsWith("s")) {
            return name;
        }
        if (((String)name).endsWith("Collection")) {
            name = ((String)name).substring(0, ((String)name).length() - "Collection".length());
        }
        name = ((String)name).endsWith("ss") ? (String)name + "es" : (((String)name).endsWith("x") ? (String)name + "es" : (((String)name).endsWith("y") ? ((String)name).substring(0, ((String)name).length() - 1) + "ies" : (String)name + "s"));
        return name;
    }

    public static String getSingularName(String name) {
        if (((String)name).endsWith("ss")) {
            return name;
        }
        if (((String)name).endsWith("ies")) {
            name = ((String)name).substring(0, ((String)name).length() - 3) + "y";
        } else if (((String)name).endsWith("xes")) {
            name = ((String)name).substring(0, ((String)name).length() - 2);
        } else if (((String)name).endsWith("ses")) {
            name = ((String)name).substring(0, ((String)name).length() - 2);
        } else if (((String)name).endsWith("s")) {
            name = ((String)name).substring(0, ((String)name).length() - 1);
        } else if (((String)name).endsWith("Collection")) {
            name = ((String)name).substring(0, ((String)name).length() - "Collection".length());
        }
        return name;
    }

    public static <V> V newInstanceAtSchemas(Class<V> clazz) {
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            try {
                return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e1) {
                throw new RuntimeException(e1);
            }
        }
    }

    public static void setRoutine(NamedArgument arg, Routine<?> routine) {
        arg.setRoutine(routine);
    }

    public static <V> List<V> getNewSortedList(List<V> list, Comparator<V> comparator) {
        List<V> result = CommonUtils.list(list);
        V t = CommonUtils.first(list);
        if (t instanceof Table) {
            return SchemaUtils.getNewSortedTableList(list, comparator, table -> table);
        }
        Collections.sort(result, comparator);
        return result;
    }

    public static List<Table> getNewSortedTableList(List<Table> list, Comparator<Table> comparator) {
        return SchemaUtils.getNewSortedTableList(list, comparator, table -> table);
    }

    public static <V> List<V> getNewSortedTableList(List<V> list, Comparator<Table> comparator, java.util.function.Function<V, Table> f) {
        Table table;
        if (!(comparator instanceof TableCreateOrderComparator) && !(comparator instanceof TableDropOrderComparator)) {
            List<V> tmp = CommonUtils.list(list);
            Collections.sort(tmp, (o1, o2) -> comparator.compare((Table)f.apply(o1), (Table)f.apply(o2)));
            return tmp;
        }
        if (CommonUtils.isEmpty(list)) {
            return list;
        }
        List noReferences = CommonUtils.list();
        List hasReference = CommonUtils.list();
        TripleKeyMap<Object, String, String, Table> referenced = CommonUtils.tripleKeyMap();
        TripleKeyMap<Object, String, String, Table> hasFks = CommonUtils.tripleKeyMap();
        for (V t : list) {
            table = f.apply(t);
            List<ForeignKeyConstraint> fks = table.getConstraints().getForeignKeyConstraints();
            if (!fks.isEmpty()) {
                hasFks.put(null, table.getSchemaName(), table.getName(), table);
            }
            for (ForeignKeyConstraint fk : fks) {
                referenced.put(null, fk.getRelatedTable().getSchemaName(), fk.getRelatedTable().getName(), fk.getRelatedTable());
            }
        }
        for (V t : list) {
            table = f.apply(t);
            Table refTable = (Table)hasFks.get(null, table.getSchemaName(), table.getName());
            if (refTable == null && (refTable = (Table)referenced.get(null, table.getSchemaName(), table.getName())) == null) {
                noReferences.add(t);
                continue;
            }
            hasReference.add(t);
        }
        List sorted1 = SchemaUtils.getNewSortedTableListInternal(noReferences, comparator, f);
        List sorted2 = SchemaUtils.getNewSortedTableListInternal(hasReference, comparator, f);
        sorted1.addAll(sorted2);
        return sorted1;
    }

    private static <V> List<V> getNewSortedTableListInternal(List<V> list, Comparator<Table> comparator, java.util.function.Function<V, Table> f) {
        TablePoint tp2;
        TablePoint tp1;
        int i;
        if (list.isEmpty()) {
            return list;
        }
        List<V> tmp = CommonUtils.list(list);
        Collections.sort(tmp, (o1, o2) -> comparator.compare((Table)f.apply(o1), (Table)f.apply(o2)));
        List tpList = tmp.stream().map(t -> {
            TablePoint<Object> tp = new TablePoint<Object>(t, f);
            return tp;
        }).collect(Collectors.toList());
        int counter = 0;
        for (i = tpList.size() - 1; i >= 0; --i) {
            TablePoint tp3 = (TablePoint)tpList.get(i);
            tp3.minus(counter++);
        }
        for (i = 0; i < tpList.size(); ++i) {
            for (int j = i + 1; j < tpList.size(); ++j) {
                tp1 = (TablePoint)tpList.get(i);
                tp2 = (TablePoint)tpList.get(j);
                int ret = comparator.compare(tp1.getTable(), tp2.getTable());
                if (ret > 0) {
                    tp2.setPoint(Math.min(tp1.point, tp2.point)).minus(ret);
                    continue;
                }
                if (ret >= 0) continue;
                tp1.setPoint(Math.min(tp1.point, tp2.point)).minus(-ret);
            }
        }
        for (i = 0; i < tpList.size() - 1; ++i) {
            for (int j = i + 1; j < tpList.size(); ++j) {
                tp1 = (TablePoint)tpList.get(i);
                tp2 = (TablePoint)tpList.get(j);
                tpList.set(j, tp2);
                tpList.set(i, tp1);
            }
        }
        List result = tpList.stream().map(tp -> tp.getObject()).collect(Collectors.toList());
        return result;
    }

    public static void validate(AbstractDbObject<?> object) {
        object.validate();
    }

    public static void validate(AbstractDbObjectCollection<?> object) {
        object.validate();
    }

    public static Set<Class<?>> getDroppableClasses() {
        Set<Class<?>> classes = SchemaUtils.getNamedObjectClasses();
        Set<Class<?>> result = CommonUtils.set(classes);
        result.remove(AssemblyFile.class);
        result.remove(Catalog.class);
        result.remove(Column.class);
        result.remove(DimensionLevel.class);
        result.remove(DimensionLevelColumn.class);
        result.remove(NamedArgument.class);
        result.remove(Setting.class);
        result.remove(TableSpaceFile.class);
        result.remove(TypeColumn.class);
        result.remove(Partition.class);
        result.remove(DimensionAttribute.class);
        result.remove(DimensionHierarchy.class);
        result.remove(DimensionHierarchyLevel.class);
        result.remove(DimensionAttributeColumn.class);
        result.remove(DimensionHierarchyJoinKeyColumn.class);
        return result;
    }

    public static <V extends NameProperty<?>> Map<String, V> toMap(Collection<V> c) {
        if (c == null) {
            return Collections.emptyMap();
        }
        Map map = CommonUtils.map();
        Map cmap = CommonUtils.caseInsensitiveLinkedMap();
        c.stream().forEach(v -> {
            map.put(v.getName(), v);
            cmap.put(v.getName(), v);
        });
        if (map.size() == cmap.size()) {
            return cmap;
        }
        return map;
    }

    public static <V extends AbstractSchemaObject<?>> DoubleKeyMap<String, String, V> toDoubleKeyMap(Collection<V> c) {
        return DoubleKeyMap.toMap(c, v -> v.getSchemaName(), v -> v.getName());
    }

    public static <V extends AbstractSchemaObject<?>> DoubleKeyMap<String, String, List<V>> toDoubleKeyListMap(Collection<V> c, java.util.function.Function<V, String> func) {
        return DoubleKeyMap.toListMap(c, v -> v.getSchemaName(), v -> (String)func.apply(v));
    }

    public static <V extends AbstractSchemaObject<?>> TripleKeyMap<String, String, String, V> toTripleKeyMap(Collection<V> c) {
        return TripleKeyMap.toMap(c, v -> v.getCatalogName(), v -> v.getSchemaName(), v -> v.getName());
    }

    public static <V extends AbstractSchemaObject<?>> TripleKeyMap<String, String, String, List<V>> toTripleKeyListMap(Collection<V> c, java.util.function.Function<V, String> func) {
        return TripleKeyMap.toListMap(c, v -> v.getCatalogName(), v -> v.getSchemaName(), v -> (String)func.apply(v));
    }

    public static Set<Class<?>> getSchemaObjectClasses() {
        return SchemaUtils.getSubClasses(AbstractSchemaObject.class);
    }

    public static Set<Class<?>> getDbObjectClasses() {
        return SchemaUtils.getSubClasses(DbObject.class);
    }

    public static Set<Class<?>> getNamedObjectClasses() {
        return SchemaUtils.getSubClasses(NameProperty.class);
    }

    public static Set<Class<?>> getSubClasses(Class<?> ... classes) {
        Set<Class<?>> ret = CommonUtils.set();
        for (Class<?> clazz : classes) {
            ret.addAll(SchemaUtils.getSubClasses(clazz));
        }
        return ret;
    }

    public static String getSimpleName(DbCommonObject<?> obj) {
        if (obj instanceof Row) {
            return ((Row)obj).getSimpleName();
        }
        if (obj instanceof RowCollection) {
            return ((RowCollection)obj).getSimpleName();
        }
        if (obj instanceof AbstractBaseDbObject) {
            return ((AbstractBaseDbObject)obj).getSimpleName();
        }
        if (obj instanceof AbstractBaseDbObjectCollection) {
            return ((AbstractBaseDbObjectCollection)obj).getSimpleName();
        }
        return null;
    }

    public static Set<Class<?>> getSubClasses(Class<?> clazz) {
        Set<Class<?>> classes = CLASSES_CACHE.get(clazz);
        if (classes != null) {
            return classes;
        }
        List<Class<?>> ret = SchemaUtils.getClassesInternal(clazz);
        classes = Collections.unmodifiableSet(CommonUtils.linkedSet(ret));
        CLASSES_CACHE.put(clazz, classes);
        return classes;
    }

    protected static List<Class<?>> getClassesInternal(final Class<?> clazz) {
        ClassFinder finder = new ClassFinder(Schema.class.getClassLoader());
        Predicate filter = new Predicate<Class<?>>(){

            @Override
            public boolean test(Class<?> obj) {
                if (!clazz.isAssignableFrom(obj)) {
                    return false;
                }
                if (Modifier.isAbstract(obj.getModifiers())) {
                    return false;
                }
                if (obj.getSimpleName().startsWith("Dummy")) {
                    return false;
                }
                return !obj.getSimpleName().startsWith("Reference");
            }
        };
        finder.setFilter(filter);
        List<Class<?>> ret = finder.find(Schema.class.getPackage().getName());
        return ret;
    }

    public static List<Table> getTables(Catalog catalog) {
        List<Table> tables = CommonUtils.list();
        for (Schema schema : catalog.getSchemas()) {
            tables.addAll(schema.getTables());
        }
        return tables;
    }

    public static Dialect getDialect(DbCommonObject<?> dbObject) {
        if (dbObject instanceof ProductProperties) {
            return SchemaUtils.getDialect((ProductProperties)((Object)dbObject));
        }
        if (dbObject instanceof CatalogCollection) {
            CatalogCollection cc = (CatalogCollection)dbObject;
            return SchemaUtils.getDialect((ProductProperties)((Object)cc.get(0)));
        }
        if (dbObject instanceof SchemaCollection) {
            SchemaCollection cc = (SchemaCollection)dbObject;
            return SchemaUtils.getDialect((ProductProperties)((Object)cc.get(0)));
        }
        return null;
    }

    public static Dialect getDialect(ProductProperties<?> obj) {
        if (obj == null) {
            return null;
        }
        if (obj.getProductName() != null) {
            return DialectResolver.getInstance().getDialect(obj.getProductName(), obj.getProductMajorVersion(), obj.getProductMinorVersion());
        }
        return null;
    }

    public static Object putDialect(Row row, Column column, Object value) {
        return row.putDirect(column, value);
    }

    public static boolean nameEquals(NameProperty<?> column1, NameProperty<?> column2) {
        if (column1 == null) {
            return column2 == null;
        }
        if (column2 == null) {
            return false;
        }
        if (!CommonUtils.eq(column1.getName(), column2.getName())) {
            return false;
        }
        if (column1 instanceof TableNameProperty && column2 instanceof TableNameProperty && !CommonUtils.eq(((TableNameProperty)((Object)column1)).getTableName(), ((TableNameProperty)((Object)column2)).getTableName())) {
            return false;
        }
        return !(column1 instanceof SchemaNameProperty) || !(column2 instanceof SchemaNameProperty) || CommonUtils.eq(((SchemaNameProperty)((Object)column1)).getSchemaName(), ((SchemaNameProperty)((Object)column2)).getSchemaName());
    }

    public static Schema getSchema(AbstractSchemaObject<?> obj) {
        if (obj.getParent() == null) {
            return null;
        }
        return obj.getAncestor(Schema.class);
    }

    public static Schema getSchemaFromParent(Schema obj, DbCommonObject<?> dbObject) {
        return SchemaUtils.getNamedObjectFromParentInternal(obj, dbObject, (name, catalog) -> {
            if (obj == null || obj.getName() == null) {
                return dbObject.getAncestor(Schema.class);
            }
            return (Schema)catalog.getSchemas().get((String)name);
        });
    }

    public static TableSpace getTableSpaceFromParent(TableSpace obj, DbCommonObject<?> dbObject) {
        return SchemaUtils.getNamedObjectFromParentInternal(obj, dbObject, (name, catalog) -> (TableSpace)catalog.getTableSpaces().get((String)name));
    }

    public static User getUserFromParent(User obj, DbCommonObject<?> dbObject) {
        return SchemaUtils.getNamedObjectFromParentInternal(obj, dbObject, (name, catalog) -> (User)catalog.getUsers().get((String)name));
    }

    public static Role getRoleFromParent(Role obj, DbCommonObject<?> dbObject) {
        return SchemaUtils.getNamedObjectFromParentInternal(obj, dbObject, (name, catalog) -> (Role)catalog.getRoles().get((String)name));
    }

    public static PartitionScheme getPartitionSchemeFromParent(PartitionScheme obj, DbCommonObject<?> dbObject) {
        return SchemaUtils.getNamedObjectFromParentInternal(obj, dbObject, (name, catalog) -> (PartitionScheme)catalog.getPartitionSchemes().get((String)name));
    }

    public static PartitionFunction getPartitionFunctionFromParent(PartitionFunction obj, DbCommonObject<?> dbObject) {
        return SchemaUtils.getNamedObjectFromParentInternal(obj, dbObject, (name, catalog) -> (PartitionFunction)catalog.getPartitionFunctions().get((String)name));
    }

    private static <V extends NameProperty<?>> V getNamedObjectFromParentInternal(V obj, DbCommonObject<?> dbObject, BiFunction<String, Catalog, V> func) {
        if (obj == null) {
            return null;
        }
        if (obj.getName() == null) {
            return obj;
        }
        Catalog catalog = dbObject.getAncestor(Catalog.class);
        if (catalog == null) {
            return obj;
        }
        NameProperty getObject = (NameProperty)func.apply(obj.getName(), catalog);
        if (getObject != null) {
            return (V)getObject;
        }
        return obj;
    }

    public static Operator getOperatorFromParent(Operator obj, DbCommonObject<?> dbObject) {
        return SchemaUtils.getSchemaObjectFromParentInternal(obj, dbObject, (name, schema) -> (Operator)schema.getOperators().get((String)name));
    }

    public static Type getTypeFromParent(Type obj, DbCommonObject<?> dbObject) {
        return SchemaUtils.getSchemaObjectFromParentInternal(obj, dbObject, (name, schema) -> (Type)schema.getTypes().get((String)name));
    }

    public static Table getTableFromParent(Table obj, DbCommonObject<?> dbObject) {
        return SchemaUtils.getSchemaObjectFromParentInternal(obj, dbObject, (name, schema) -> (Table)schema.getTables().get((String)name));
    }

    public static Table getTableOnlyFromParent(String schemaName, String name, DbCommonObject<?> dbObject) {
        return SchemaUtils.getSchemaObjectFromParentInternal(schemaName, name, dbObject, (nm, schema) -> (Table)schema.getTables().get((String)nm));
    }

    public static Table getTableFromParent(String schemaName, String name, DbCommonObject<?> dbObject) {
        return SchemaUtils.getSchemaObjectFromParentInternal(schemaName, name, dbObject, (nm, schema) -> schema.getTable((String)nm));
    }

    public static Function getFunctionFromParent(Function obj, DbCommonObject<?> dbObject) {
        return SchemaUtils.getSchemaObjectFromParentInternal(obj, dbObject, (name, schema) -> (Function)schema.getFunctions().get((String)name));
    }

    public static Sequence getSequenceFromParent(Sequence obj, DbCommonObject<?> dbObject) {
        return SchemaUtils.getSchemaObjectFromParentInternal(obj, dbObject, (name, schema) -> (Sequence)schema.getSequences().get((String)name));
    }

    public static Index getIndexFromParent(Index obj, DbCommonObject<?> dbObject) {
        return SchemaUtils.getTableObjectFromParentInternal(obj, dbObject, (name, table) -> (Index)table.getIndexes().get((String)name));
    }

    private static <V extends AbstractSchemaObject<?>> V getSchemaObjectFromParentInternal(V obj, DbCommonObject<?> dbObject, BiFunction<String, Schema, V> func) {
        if (obj == null) {
            return null;
        }
        if (obj.getName() == null) {
            return obj;
        }
        V ret = SchemaUtils.getSchemaObjectFromParentInternal(obj.getSchemaName(), obj.getName(), dbObject, func);
        if (ret != null) {
            return ret;
        }
        return obj;
    }

    private static <V extends AbstractSchemaObject<?>> V getSchemaObjectFromParentInternal(String schemaName, String name, DbCommonObject<?> dbObject, BiFunction<String, Schema, V> func) {
        Schema schema;
        if (name == null) {
            return null;
        }
        String objSchemaName = (String)SchemaProperties.SCHEMA_NAME.getValue(dbObject);
        if (CommonUtils.eq(schemaName, objSchemaName) || schemaName == null) {
            schema = dbObject.getAncestor(Schema.class);
        } else {
            SchemaCollection schemas = dbObject.getAncestor(SchemaCollection.class);
            if (schemas == null) {
                return null;
            }
            schema = (Schema)schemas.get(schemaName);
        }
        if (schema == null) {
            return null;
        }
        AbstractSchemaObject getObject = (AbstractSchemaObject)func.apply(name, schema);
        if (getObject != null) {
            return (V)getObject;
        }
        return null;
    }

    private static <V extends AbstractSchemaObject<?>> V getTableObjectFromParentInternal(V obj, DbCommonObject<?> dbObject, BiFunction<String, Table, V> func) {
        if (obj == null) {
            return null;
        }
        if (obj.getName() == null) {
            return obj;
        }
        Table table = dbObject.getAncestor(Table.class);
        if (table == null) {
            return obj;
        }
        AbstractSchemaObject getObject = (AbstractSchemaObject)func.apply(obj.getName(), table);
        if (getObject != null) {
            return (V)getObject;
        }
        return obj;
    }

    public static Function getFunctionFromParent(Function function, OperatorArgument leftArgument, OperatorArgument rightArgument, DbCommonObject<?> dbObject) {
        if (function == null) {
            return function;
        }
        Schema schema = dbObject.getAncestor(Schema.class);
        if (schema == null) {
            return function;
        }
        OperatorArgument[] args = null;
        args = leftArgument == null ? (rightArgument == null ? new OperatorArgument[]{} : new OperatorArgument[]{rightArgument}) : (rightArgument == null ? new OperatorArgument[]{leftArgument} : new OperatorArgument[]{leftArgument, rightArgument});
        String name = SchemaUtils.getSpecificFunctionName(function, args);
        Function getFunction = (Function)schema.getFunctions().get(name);
        if (getFunction != null) {
            return getFunction;
        }
        getFunction = (Function)schema.getFunctions().get(function.getName());
        return function;
    }

    private static String getSpecificFunctionName(Function function, OperatorArgument[] args) {
        SeparatedStringBuilder builder = new SeparatedStringBuilder(",").setStart(function.getName() + "(").setEnd(")");
        for (int i = 0; i < args.length; ++i) {
            builder.add((Object)args[i].getDataTypeName());
        }
        return builder.toString();
    }

    public static Set<ISchemaProperty> getAllSchemaProperties(Class<?> clazz) {
        Set<ISchemaProperty> set = ALL_SCHEMA_PROPERTIES_SET.get(clazz);
        if (set == null) {
            Set<ISchemaProperty> schemaProperties = SchemaUtils.getSchemaProperties(clazz);
            Set<ISchemaProperty> schemaObjectProperties = SchemaUtils.getSchemaObjectProperties(clazz);
            set = CommonUtils.linkedSet(schemaProperties.size() + schemaObjectProperties.size());
            set.addAll(schemaProperties);
            set.addAll(schemaObjectProperties);
            if (!set.isEmpty()) {
                ALL_SCHEMA_PROPERTIES_SET.put(clazz, set);
            }
        }
        return set;
    }

    public static Set<ISchemaProperty> getSchemaProperties(Class<?> clazz) {
        Set<ISchemaProperty> set = SCHEMA_PROPERTIES_SET.get(clazz);
        if (set == null) {
            set = CommonUtils.linkedSet();
            for (SchemaProperties prop : SchemaProperties.values()) {
                if (!prop.getPropertyClass().isAssignableFrom(clazz)) continue;
                set.add(prop);
            }
            if (!set.isEmpty()) {
                SCHEMA_PROPERTIES_SET.put(clazz, set);
            }
        }
        return set;
    }

    public static Set<ISchemaProperty> copySchemaProperties(Object from, Object to) {
        Set<ISchemaProperty> set = SchemaUtils.getSchemaProperties(from.getClass());
        for (SchemaProperties prop : SchemaProperties.values()) {
            Object value = prop.getCloneValue(from);
            prop.setValue(to, value);
        }
        return set;
    }

    public static Set<ISchemaProperty> getSchemaObjectProperties(Class<?> clazz) {
        Set<ISchemaProperty> set = SCHEMA_OBJECT_PROPERTIES_SET.get(clazz);
        if (set == null) {
            set = CommonUtils.linkedSet();
            for (SchemaObjectProperties prop : SchemaObjectProperties.values()) {
                if (!prop.getPropertyClass().isAssignableFrom(clazz)) continue;
                set.add(prop);
            }
            if (!set.isEmpty()) {
                SCHEMA_OBJECT_PROPERTIES_SET.put(clazz, set);
            }
        }
        return set;
    }

    public static StaxElementHandler getStaxElementHandler(Object obj) {
        if (obj instanceof AbstractBaseDbObjectCollection) {
            AbstractBaseDbObjectCollection c = (AbstractBaseDbObjectCollection)obj;
            return c.getDbObjectXmlReaderHandler();
        }
        if (obj instanceof AbstractBaseDbObject) {
            AbstractBaseDbObject c = (AbstractBaseDbObject)obj;
            return c.getDbObjectXmlReaderHandler();
        }
        if (obj instanceof Column[]) {
            return new ColumnCollectionXmlReaderHandler();
        }
        return null;
    }

    public static CharacterSemantics getParentCharacterSemantics(DbCommonObject<?> obj) {
        CharacterSemanticsProperty prop = (CharacterSemanticsProperty)obj.getAncestor(o -> o instanceof CharacterSemanticsProperty);
        if (prop == null) {
            return null;
        }
        return prop.getCharacterSemantics();
    }

    public static String getParentCharacterSet(DbCommonObject<?> obj) {
        CharacterSetProperty prop = (CharacterSetProperty)obj.getAncestor(o -> o instanceof CharacterSetProperty);
        if (prop == null) {
            return null;
        }
        return prop.getCharacterSet();
    }

    public static String getParentCollation(DbCommonObject<?> obj) {
        CollationProperty prop = (CollationProperty)obj.getAncestor(o -> o instanceof CollationProperty);
        if (prop == null) {
            return null;
        }
        return prop.getCollation();
    }

    public static String getProductInfo(DbCommonObject<?> obj) {
        Schema schema = null;
        schema = obj instanceof Schema ? (Schema)obj : obj.getAncestor(Schema.class);
        if (schema != null) {
            return schema.getProductVersionInfo().toString();
        }
        SchemaCollection schemas = null;
        schemas = obj instanceof SchemaCollection ? (SchemaCollection)obj : obj.getAncestor(SchemaCollection.class);
        Catalog catalog = null;
        if (schemas != null) {
            catalog = schemas.getParent();
        }
        if (catalog != null) {
            return catalog.getProductVersionInfo().toString();
        }
        catalog = obj instanceof Catalog ? (Catalog)obj : obj.getAncestor(Catalog.class);
        if (catalog != null) {
            return catalog.getProductVersionInfo().toString();
        }
        return null;
    }

    public static boolean setDataTypeNameInternal(String dataTypeName, DataTypeNameProperty<?> prop) {
        if (prop instanceof AbstractColumn) {
            ((AbstractColumn)prop).dataTypeName = dataTypeName;
            return true;
        }
        boolean bool = SimpleBeanUtils.setField(prop, SchemaProperties.DATA_TYPE_NAME.getLabel(), dataTypeName);
        return bool;
    }

    public static String getDataTypeNameInternal(DataTypeNameProperty<?> prop) {
        if (prop instanceof AbstractColumn) {
            return ((AbstractColumn)prop).dataTypeName;
        }
        return (String)SimpleBeanUtils.getField(prop, SchemaProperties.DATA_TYPE_NAME.getLabel());
    }

    static class TablePoint<V>
    implements Comparable<TablePoint<V>> {
        private final V object;
        private final java.util.function.Function<V, Table> f;
        private int point = Integer.MAX_VALUE;

        TablePoint(V object, java.util.function.Function<V, Table> f) {
            this.object = object;
            this.f = f;
        }

        public V getObject() {
            return this.object;
        }

        public Table getTable() {
            return this.f.apply(this.object);
        }

        public TablePoint<V> setPoint(int point) {
            this.point = point;
            return this;
        }

        public TablePoint<V> minus() {
            --this.point;
            return this;
        }

        public TablePoint<V> minus(int val) {
            this.point -= val;
            return this;
        }

        public long point() {
            return this.point;
        }

        @Override
        public int compareTo(TablePoint<V> o) {
            return this.point - o.point;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getTable().getName());
            builder.append("(");
            builder.append(this.point);
            builder.append(")");
            return builder.toString();
        }
    }
}

