/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.converter.Converter;
import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.db.datatype.DataType;
import com.sqlapp.data.schemas.AbstractSchemaObject;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.HasParent;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.SequenceCollection;
import com.sqlapp.data.schemas.properties.CacheProperty;
import com.sqlapp.data.schemas.properties.CacheSizeProperty;
import com.sqlapp.data.schemas.properties.CycleProperty;
import com.sqlapp.data.schemas.properties.DataTypeProperties;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.data.schemas.properties.IncrementByProperty;
import com.sqlapp.data.schemas.properties.LastValueProperty;
import com.sqlapp.data.schemas.properties.MaxValueProperty;
import com.sqlapp.data.schemas.properties.MinValueProperty;
import com.sqlapp.data.schemas.properties.PrecisionProperty;
import com.sqlapp.data.schemas.properties.ScaleProperty;
import com.sqlapp.data.schemas.properties.SequenceOrderProperty;
import com.sqlapp.data.schemas.properties.StartValueProperty;
import com.sqlapp.util.EqualsUtils;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.ToStringBuilder;
import java.math.BigInteger;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;

public final class Sequence
extends AbstractSchemaObject<Sequence>
implements HasParent<SequenceCollection>,
DataTypeProperties<Sequence>,
PrecisionProperty<Sequence>,
ScaleProperty<Sequence>,
MinValueProperty<Sequence>,
MaxValueProperty<Sequence>,
IncrementByProperty<Sequence>,
CacheSizeProperty<Sequence>,
StartValueProperty<Sequence>,
LastValueProperty<Sequence>,
CycleProperty<Sequence>,
CacheProperty<Sequence>,
SequenceOrderProperty<Sequence> {
    private static final long serialVersionUID = -2636864307288766192L;
    private DataType dataType = null;
    private String dataTypeName = null;
    private BigInteger minValue = null;
    private BigInteger maxValue = null;
    private BigInteger incrementBy = null;
    private Integer cacheSize = null;
    private BigInteger startValue = null;
    private BigInteger lastValue = null;
    private static final Converter<BigInteger> converter = Converters.getDefault().getConverter(BigInteger.class);
    private boolean cycle = (Boolean)SchemaProperties.CYCLE.getDefaultValue();
    private boolean cache = (Boolean)SchemaProperties.CACHE.getDefaultValue();
    private boolean order = (Boolean)SchemaProperties.SEQUENCE_ORDER.getDefaultValue();
    private Integer precision = null;
    private Integer scale = null;
    private static final BigInteger TINYINT_MIN = converter.convertObject((byte)-128);
    private static final BigInteger SMALLINT_MIN = converter.convertObject((short)Short.MIN_VALUE);
    private static final BigInteger INT_MIN = converter.convertObject(Integer.MIN_VALUE);
    private static final BigInteger LONG_MIN = converter.convertObject(Long.MIN_VALUE);
    private static final BigInteger TINYINT_MAX = converter.convertObject((byte)127);
    private static final BigInteger SMALLINT_MAX = converter.convertObject((short)Short.MAX_VALUE);
    private static final BigInteger INT_MAX = converter.convertObject(Integer.MAX_VALUE);
    private static final BigInteger LONG_MAX = converter.convertObject(Long.MAX_VALUE);
    private static final BigInteger UTINYINT_MAX = converter.convertObject(255L);
    private static final BigInteger USMALLINT_MAX = converter.convertObject(65535L);
    private static final BigInteger UINT_MAX = converter.convertObject(0xFFFFFFFFL);
    private static final BigInteger ULONG_MAX = UINT_MAX.add(BigInteger.ONE).multiply(BigInteger.valueOf(2L)).subtract(BigInteger.ONE);

    @Override
    public Integer getPrecision() {
        return this.precision;
    }

    @Override
    public Sequence setPrecision(Number precision) {
        this.precision = Converters.getDefault().convertObject(precision, Integer.class);
        return this;
    }

    @Override
    public Sequence setPrecision(int precision) {
        this.precision = precision;
        return this;
    }

    @Override
    public Integer getScale() {
        return this.scale;
    }

    @Override
    public Sequence setScale(int scale) {
        this.scale = scale;
        return (Sequence)this.instance();
    }

    @Override
    public Sequence setScale(Number scale) {
        this.scale = Converters.getDefault().convertObject(scale, Integer.class);
        return this;
    }

    public Sequence() {
    }

    public Sequence(String name) {
        super(name);
    }

    @Override
    protected Supplier<Sequence> newInstance() {
        return () -> new Sequence();
    }

    public BigInteger nextValueFor() {
        this.lastValue = this.lastValue == null ? this.startValue : this.startValue.add(this.incrementBy);
        return this.lastValue;
    }

    @Override
    protected void toStringDetail(ToStringBuilder builder) {
        builder.add((ISchemaProperty)SchemaProperties.DATA_TYPE, (Object)this.dataType);
        builder.add((ISchemaProperty)SchemaProperties.DATA_TYPE_NAME, this.dataTypeName);
        builder.add((ISchemaProperty)SchemaProperties.PRECISION, (Object)this.precision);
        builder.add((ISchemaProperty)SchemaProperties.MIN_VALUE, (Object)this.getMinValue());
        builder.add((ISchemaProperty)SchemaProperties.MAX_VALUE, (Object)this.getMaxValue());
        builder.add((ISchemaProperty)SchemaProperties.INCREMENT_BY, (Object)this.getIncrementBy());
        builder.add((ISchemaProperty)SchemaProperties.CACHE_SIZE, (Object)this.getCacheSize());
        builder.add((ISchemaProperty)SchemaProperties.START_VALUE, (Object)this.getStartValue());
        builder.add((ISchemaProperty)SchemaProperties.LAST_VALUE, (Object)this.getLastValue());
        if (this.cycle) {
            builder.add((ISchemaProperty)SchemaProperties.CYCLE, (Object)this.isCycle());
        }
        builder.add((ISchemaProperty)SchemaProperties.CACHE, (Object)this.isCache());
        if (this.order) {
            builder.add((ISchemaProperty)SchemaProperties.SEQUENCE_ORDER, (Object)this.isOrder());
        }
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!(obj instanceof Sequence)) {
            return false;
        }
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        Sequence val = (Sequence)obj;
        if (!this.equals(SchemaProperties.DATA_TYPE, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.DATA_TYPE_NAME, val, equalsHandler, EqualsUtils.getEqualsIgnoreCaseSupplier(this.getDataTypeName(), val.getDataTypeName()))) {
            return false;
        }
        if (!this.equals(SchemaProperties.PRECISION, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.INCREMENT_BY, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.MAX_VALUE, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.MIN_VALUE, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.CACHE_SIZE, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.START_VALUE, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.LAST_VALUE, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.CACHE, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.CYCLE, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.SEQUENCE_ORDER, val, equalsHandler)) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    @Override
    protected void writeXmlOptionalAttributes(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalAttributes(stax);
        stax.writeAttribute(SchemaProperties.DATA_TYPE.getLabel(), (Object)this.getDataType());
        stax.writeAttribute(SchemaProperties.DATA_TYPE_NAME.getLabel(), this.getDataTypeName());
        stax.writeAttribute(SchemaProperties.PRECISION.getLabel(), (Object)this.getPrecision());
        stax.writeAttribute(SchemaProperties.MIN_VALUE.getLabel(), (Object)this.getMinValue());
        stax.writeAttribute(SchemaProperties.MAX_VALUE.getLabel(), (Object)this.getMaxValue());
        stax.writeAttribute(SchemaProperties.INCREMENT_BY.getLabel(), (Object)this.getIncrementBy());
        stax.writeAttribute(SchemaProperties.CACHE_SIZE.getLabel(), (Object)this.getCacheSize());
        stax.writeAttribute(SchemaProperties.START_VALUE.getLabel(), (Object)this.getStartValue());
        stax.writeAttribute(SchemaProperties.LAST_VALUE.getLabel(), (Object)this.getLastValue());
        if (this.cycle) {
            stax.writeAttribute(SchemaProperties.CYCLE.getLabel(), (Object)this.isCycle());
        }
        stax.writeAttribute(SchemaProperties.CACHE.getLabel(), (Object)this.isCache());
        stax.writeAttribute(SchemaProperties.SEQUENCE_ORDER.getLabel(), (Object)this.isOrder());
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public Sequence setDataType(DataType dbType) {
        this.dataType = dbType;
        this.setMinValue(this.getMinValue());
        this.setMaxValue(this.getMaxValue());
        return this;
    }

    @Override
    public String getDataTypeName() {
        return this.dataTypeName;
    }

    @Override
    public Integer getCacheSize() {
        return this.cacheSize;
    }

    @Override
    public BigInteger getMinValue() {
        return this.minValue;
    }

    @Override
    public Sequence setMinValue(BigInteger minValue) {
        this.minValue = this.getLimitValue(minValue);
        return (Sequence)this.instance();
    }

    @Override
    public BigInteger getMaxValue() {
        return this.maxValue;
    }

    @Override
    public Sequence setMaxValue(BigInteger maxValue) {
        this.maxValue = this.getLimitValue(maxValue);
        return (Sequence)this.instance();
    }

    @Override
    public BigInteger getIncrementBy() {
        return this.incrementBy;
    }

    @Override
    public Sequence setIncrementBy(BigInteger incrementBy) {
        this.incrementBy = incrementBy;
        return (Sequence)this.instance();
    }

    @Override
    public boolean isCycle() {
        return this.cycle;
    }

    @Override
    public Sequence setCycle(boolean cycle) {
        this.cycle = cycle;
        return (Sequence)this.instance();
    }

    @Override
    public boolean isCache() {
        return this.cache;
    }

    @Override
    public Sequence setCache(boolean cache) {
        this.cache = cache;
        return (Sequence)this.instance();
    }

    @Override
    public boolean isOrder() {
        return this.order;
    }

    @Override
    public Sequence setOrder(boolean order) {
        this.order = order;
        return this;
    }

    @Override
    public Sequence setCacheSize(Integer cacheSize) {
        this.cacheSize = cacheSize;
        return (Sequence)this.instance();
    }

    @Override
    public BigInteger getLastValue() {
        return this.lastValue;
    }

    @Override
    public Sequence setLastValue(BigInteger lastValue) {
        this.lastValue = lastValue;
        return (Sequence)this.instance();
    }

    @Override
    public BigInteger getStartValue() {
        return this.startValue;
    }

    @Override
    public Sequence setStartValue(BigInteger startValue) {
        this.startValue = startValue;
        return (Sequence)this.instance();
    }

    @Override
    public SequenceCollection getParent() {
        return (SequenceCollection)super.getParent();
    }

    private BigInteger getLimitValue(BigInteger value) {
        if (value == null) {
            return null;
        }
        BigInteger min = Sequence.getDbTypeMinValue(this.getDataType(), value);
        BigInteger max = Sequence.getDbTypeMaxValue(this.getDataType(), value);
        if (min != null && max != null) {
            if (min.compareTo(value) > 0) {
                return min;
            }
            if (max.compareTo(value) < 0) {
                return max;
            }
        }
        return value;
    }

    private static BigInteger getDbTypeMinValue(DataType type, BigInteger value) {
        if (value == null) {
            return null;
        }
        if (type == null) {
            return value;
        }
        BigInteger convValue = null;
        switch (type) {
            case TINYINT: {
                convValue = TINYINT_MIN;
                break;
            }
            case SMALLINT: {
                convValue = SMALLINT_MIN;
                break;
            }
            case INT: {
                convValue = INT_MIN;
                break;
            }
            case BIGINT: {
                convValue = LONG_MIN;
                break;
            }
            case UTINYINT: {
                convValue = BigInteger.ZERO;
                break;
            }
            case USMALLINT: {
                convValue = BigInteger.ZERO;
                break;
            }
            case UINT: {
                convValue = BigInteger.ZERO;
                break;
            }
            case UBIGINT: {
                convValue = BigInteger.ZERO;
                break;
            }
        }
        if (convValue == null) {
            return value;
        }
        return convValue;
    }

    private static BigInteger getDbTypeMaxValue(DataType type, BigInteger value) {
        if (value == null) {
            return null;
        }
        if (type == null) {
            return value;
        }
        BigInteger convValue = null;
        switch (type) {
            case TINYINT: {
                convValue = TINYINT_MAX;
                break;
            }
            case SMALLINT: {
                convValue = SMALLINT_MAX;
                break;
            }
            case INT: {
                convValue = INT_MAX;
                break;
            }
            case BIGINT: {
                convValue = LONG_MAX;
                break;
            }
            case UTINYINT: {
                convValue = UTINYINT_MAX;
                break;
            }
            case USMALLINT: {
                convValue = USMALLINT_MAX;
                break;
            }
            case UINT: {
                convValue = UINT_MAX;
                break;
            }
            case UBIGINT: {
                convValue = ULONG_MAX;
                break;
            }
        }
        if (convValue == null) {
            return value;
        }
        return convValue;
    }
}

