/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.schemas.EnumProperties;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum SqlDataAccess implements EnumProperties
{
    NoSql("NO SQL", "NO\\s*SQL"),
    ContainsSql("CONTAINS SQL", "CONTAINS\\s*SQL"),
    ReadsSqlData("READS SQL DATA", "READS\\s*SQL\\s*DATA"),
    ModifiesSqlData("MODIFIES SQL DATA", "MODIFIES SQL DATA");

    private final Pattern pattern;
    private final String text;

    private SqlDataAccess(String text, String patternText) {
        this.text = text;
        this.pattern = Pattern.compile(patternText, 2);
    }

    public static SqlDataAccess parse(String text) {
        if (text == null) {
            return null;
        }
        for (SqlDataAccess rule : SqlDataAccess.values()) {
            Matcher matcher = rule.pattern.matcher(text);
            if (!matcher.matches()) continue;
            return rule;
        }
        return null;
    }

    @Override
    public String getDisplayName() {
        return this.text;
    }

    @Override
    public String getDisplayName(Locale locale) {
        return this.getDisplayName();
    }

    @Override
    public String getSqlValue() {
        return this.getDisplayName();
    }
}

