/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.DialectResolver;
import com.sqlapp.data.schemas.AbstractSchemaObject;
import com.sqlapp.data.schemas.CharacterSemantics;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.ColumnCollection;
import com.sqlapp.data.schemas.ConstraintCollection;
import com.sqlapp.data.schemas.DataException;
import com.sqlapp.data.schemas.DefaultRowIteratorHandler;
import com.sqlapp.data.schemas.EnumProperties;
import com.sqlapp.data.schemas.EqualsHandler;
import com.sqlapp.data.schemas.ForeignKeyConstraint;
import com.sqlapp.data.schemas.HasParent;
import com.sqlapp.data.schemas.IndexCollection;
import com.sqlapp.data.schemas.InheritCollection;
import com.sqlapp.data.schemas.Mergeable;
import com.sqlapp.data.schemas.Mview;
import com.sqlapp.data.schemas.Order;
import com.sqlapp.data.schemas.PartitionParent;
import com.sqlapp.data.schemas.Partitioning;
import com.sqlapp.data.schemas.ReferenceColumn;
import com.sqlapp.data.schemas.Row;
import com.sqlapp.data.schemas.RowCollection;
import com.sqlapp.data.schemas.RowIteratorHandler;
import com.sqlapp.data.schemas.RowIteratorHandlerProperty;
import com.sqlapp.data.schemas.SchemaObjectProperties;
import com.sqlapp.data.schemas.SchemaProperties;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.data.schemas.TableCollection;
import com.sqlapp.data.schemas.TableCreateOrderComparator;
import com.sqlapp.data.schemas.TableDropOrderComparator;
import com.sqlapp.data.schemas.TableSpace;
import com.sqlapp.data.schemas.TableXmlReaderHandler;
import com.sqlapp.data.schemas.UniqueConstraint;
import com.sqlapp.data.schemas.View;
import com.sqlapp.data.schemas.function.AddDbObjectPredicate;
import com.sqlapp.data.schemas.function.RowValueConverter;
import com.sqlapp.data.schemas.properties.CharacterSemanticsProperty;
import com.sqlapp.data.schemas.properties.CharacterSetProperty;
import com.sqlapp.data.schemas.properties.CollationProperty;
import com.sqlapp.data.schemas.properties.CompressionProperty;
import com.sqlapp.data.schemas.properties.CompressionTypeProperty;
import com.sqlapp.data.schemas.properties.ISchemaProperty;
import com.sqlapp.data.schemas.properties.PartitioningProperty;
import com.sqlapp.data.schemas.properties.ReadonlyProperty;
import com.sqlapp.data.schemas.properties.TableDataStoreTypeProperty;
import com.sqlapp.data.schemas.properties.TableTypeProperty;
import com.sqlapp.data.schemas.properties.UnloggedProperty;
import com.sqlapp.data.schemas.properties.complex.IndexTableSpaceProperty;
import com.sqlapp.data.schemas.properties.complex.LobTableSpaceProperty;
import com.sqlapp.data.schemas.properties.complex.TableSpaceProperty;
import com.sqlapp.data.schemas.properties.object.ColumnsProperty;
import com.sqlapp.data.schemas.properties.object.ConstraintsProperty;
import com.sqlapp.data.schemas.properties.object.IndexesProperty;
import com.sqlapp.data.schemas.properties.object.InheritsProperty;
import com.sqlapp.data.schemas.properties.object.PartitionParentProperty;
import com.sqlapp.data.schemas.properties.object.RowsProperty;
import com.sqlapp.data.schemas.rowiterator.ResultSetRowIteratorHandler;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.DbUtils;
import com.sqlapp.util.EqualsUtils;
import com.sqlapp.util.FileUtils;
import com.sqlapp.util.StaxWriter;
import com.sqlapp.util.TableUtils;
import com.sqlapp.util.ToStringBuilder;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;

public class Table
extends AbstractSchemaObject<Table>
implements CollationProperty<Table>,
CharacterSetProperty<Table>,
CharacterSemanticsProperty<Table>,
HasParent<TableCollection>,
Mergeable<Table>,
RowIteratorHandlerProperty,
ColumnsProperty<Table>,
RowsProperty<Table>,
ConstraintsProperty<Table>,
IndexesProperty<Table>,
InheritsProperty<Table>,
TableSpaceProperty<Table>,
IndexTableSpaceProperty<Table>,
LobTableSpaceProperty<Table>,
TableTypeProperty<Table>,
TableDataStoreTypeProperty<Table>,
PartitioningProperty<Table>,
ReadonlyProperty<Table>,
CompressionProperty<Table>,
CompressionTypeProperty<Table>,
UnloggedProperty<Table>,
PartitionParentProperty<Table> {
    private static final long serialVersionUID = 7120013699239800425L;
    private ColumnCollection columns = new ColumnCollection(this);
    private RowCollection rows = new RowCollection(this);
    private ConstraintCollection constraints = new ConstraintCollection(this);
    private IndexCollection indexes = new IndexCollection(this);
    private TableType tableType = null;
    private TableDataStoreType tableDataStoreType = null;
    private Boolean readonly = null;
    private boolean compression = (Boolean)SchemaProperties.COMPRESSION.getDefaultValue();
    private boolean unlogged = (Boolean)SchemaProperties.UNLOGGED.getDefaultValue();
    private String compressionType = null;
    private Partitioning partitioning = null;
    private final TableSpace tableSpace = null;
    private final TableSpace indexTableSpace = null;
    private final TableSpace lobTableSpace = null;
    private CharacterSemantics characterSemantics = null;
    private String characterSet = null;
    private String collation = null;
    private InheritCollection inherits = new InheritCollection(this);
    private PartitionParent partitionParent;
    private List<ForeignKeyConstraint> childRelations = CommonUtils.list();

    public Table() {
    }

    public Table(String name, ResultSet rs, RowValueConverter valueConverter) throws SQLException {
        super(name);
        this.setDialect(DialectResolver.getInstance().getDialect(rs.getStatement().getConnection()));
        this.getDialect().getCatalogReader().getSchemaReader().getTableReader();
        this.readData(rs);
        this.getRows().setRowIteratorHandler(new ResultSetRowIteratorHandler(rs, valueConverter));
    }

    public Table(String name, ResultSet rs) throws SQLException {
        this(name, rs, (r, c, v) -> v);
    }

    @Override
    protected Supplier<Table> newInstance() {
        return () -> new Table();
    }

    @Override
    public InheritCollection getInherits() {
        return this.inherits;
    }

    public Table(String name) {
        super(name);
    }

    @Override
    public boolean equals(Object obj, EqualsHandler equalsHandler) {
        if (!(obj instanceof Table)) {
            return false;
        }
        if (!super.equals(obj, equalsHandler)) {
            return false;
        }
        Table val = (Table)CommonUtils.cast(obj);
        if (!this.equals(SchemaObjectProperties.COLUMNS, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaObjectProperties.INDEXES, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaObjectProperties.PARTITIONING, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaObjectProperties.PARTITION_PARENT, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaObjectProperties.CONSTRAINTS, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.READONLY, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.TABLE_TYPE, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.TABLE_DATA_STORE_TYPE, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.COMPRESSION, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.COMPRESSION_TYPE, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.UNLOGGED, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.TABLE_SPACE_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.INDEX_TABLE_SPACE_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.LOB_TABLE_SPACE_NAME, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaObjectProperties.INHERITS, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaProperties.CHARACTER_SET, val, equalsHandler, EqualsUtils.getEqualsIgnoreCaseSupplier(this.getCharacterSet(), val.getCharacterSet()))) {
            return false;
        }
        if (!this.equals(SchemaProperties.COLLATION, val, equalsHandler, EqualsUtils.getEqualsIgnoreCaseSupplier(this.getCollation(), val.getCollation()))) {
            return false;
        }
        if (!this.equals(SchemaProperties.CHARACTER_SEMANTICS, val, equalsHandler)) {
            return false;
        }
        if (!this.equals(SchemaObjectProperties.ROWS, val, equalsHandler)) {
            return false;
        }
        return equalsHandler.equalsResult(this, obj);
    }

    @Override
    protected void toStringDetail(ToStringBuilder builder) {
        builder.add((ISchemaProperty)SchemaProperties.TABLE_SPACE_NAME, this.getTableSpaceName());
        builder.add((ISchemaProperty)SchemaProperties.INDEX_TABLE_SPACE_NAME, this.getIndexTableSpaceName());
        builder.add((ISchemaProperty)SchemaProperties.LOB_TABLE_SPACE_NAME, this.getLobTableSpaceName());
        if (this.isCompression()) {
            builder.add((ISchemaProperty)SchemaProperties.COMPRESSION, (Object)this.isCompression());
            builder.add((ISchemaProperty)SchemaProperties.COMPRESSION_TYPE, this.getCompressionType());
        }
        if (this.isUnlogged()) {
            builder.add((ISchemaProperty)SchemaProperties.UNLOGGED, (Object)this.isUnlogged());
        }
        builder.add((ISchemaProperty)SchemaProperties.READONLY, (Object)this.getReadonly());
        builder.add((ISchemaProperty)SchemaProperties.TABLE_TYPE, (Object)this.getTableType());
        builder.add((ISchemaProperty)SchemaProperties.TABLE_DATA_STORE_TYPE, (Object)this.getTableDataStoreType());
        builder.add((ISchemaProperty)SchemaObjectProperties.INHERITS, (Object)this.getInherits());
        builder.add((ISchemaProperty)SchemaProperties.CHARACTER_SET, this.getCharacterSet());
        builder.add((ISchemaProperty)SchemaProperties.COLLATION, this.getCollation());
        builder.add((ISchemaProperty)SchemaProperties.CHARACTER_SEMANTICS, (Object)this.getCharacterSemantics());
    }

    @Override
    public TableType getTableType() {
        return this.tableType;
    }

    @Override
    public Table setTableType(TableType tableType) {
        this.tableType = tableType;
        return (Table)this.instance();
    }

    @Override
    public Boolean getReadonly() {
        return this.readonly;
    }

    @Override
    public Table setReadonly(Boolean readOnly) {
        this.readonly = readOnly;
        return (Table)this.instance();
    }

    @Override
    public Table setTableType(String tableType) {
        this.tableType = TableType.parse(tableType);
        return (Table)this.instance();
    }

    @Override
    public TableDataStoreType getTableDataStoreType() {
        return this.tableDataStoreType;
    }

    @Override
    public Table setTableDataStoreType(TableDataStoreType tableDataStoreType) {
        this.tableDataStoreType = tableDataStoreType;
        return (Table)this.instance();
    }

    @Override
    public ColumnCollection getColumns() {
        return this.columns;
    }

    protected Table setColumns(ColumnCollection columns) {
        if (columns != null) {
            columns.setParent(this);
        }
        this.columns = columns;
        return this;
    }

    @Override
    public RowCollection getRows() {
        return this.rows;
    }

    protected Table setRows(RowCollection rows) {
        if (rows != null) {
            rows.setParent(this);
        }
        this.rows = rows;
        return this;
    }

    protected Table setInherits(InheritCollection inherits) {
        this.inherits = inherits;
        if (this.inherits != null) {
            this.inherits.setParent(this);
        }
        return this;
    }

    public void read(Connection connection, ResultSet resultSet) {
        this.readMetaData(connection, resultSet);
        this.readData(resultSet);
    }

    public void readMetaData(Connection connection, ResultSet resultSet) {
        Dialect dialect = DialectResolver.getInstance().getDialect(connection);
        if (this.getDialect() == null) {
            this.setDialect(dialect);
        }
        DbUtils.setColumnMetadata(dialect, resultSet, this);
        DbUtils.setPrimaryKeyInfo(connection, this);
    }

    public void readData(ResultSet resultSet) {
        try {
            ResultSetMetaData metadata = resultSet.getMetaData();
            Column[] columns = new Column[metadata.getColumnCount()];
            Dialect dialect = this.getDialect();
            for (int i = 1; i <= metadata.getColumnCount(); ++i) {
                Column column;
                String name = metadata.getColumnLabel(i);
                if (name == null) {
                    name = metadata.getColumnName(i);
                }
                if ((column = (Column)this.getColumns().get(name)) == null) {
                    column = new Column();
                    String productDataType = metadata.getColumnTypeName(i);
                    long precision = metadata.getPrecision(i);
                    int scale = metadata.getScale(i);
                    if (dialect != null) {
                        dialect.setDbType(productDataType, precision, scale, column);
                    }
                    this.getColumns().add(column);
                }
                columns[i - 1] = column;
            }
            int size = columns.length;
            while (resultSet.next()) {
                Row row = this.newRow();
                for (int i = 1; i <= size; ++i) {
                    Column column = columns[i - 1];
                    Object obj = resultSet.getObject(column.getName());
                    row.put(column, obj);
                }
                this.getRows().add(row);
            }
        }
        catch (SQLException e) {
            DbUtils.close(resultSet);
            throw new DataException(e);
        }
    }

    public Row newRow() {
        Row obj = new Row();
        obj.setParent(this.getRows());
        return obj;
    }

    public Column newColumn() {
        Column obj = new Column();
        obj.setColumns(this.getColumns());
        return obj;
    }

    @Override
    public void merge(Table table) {
        for (Column column : table.getColumns()) {
            if (this.getColumns().contains(column.getName())) continue;
            this.getColumns().add((Column)column.clone());
        }
        for (Row row : table.getRows()) {
            Row copyRow = this.newRow();
            for (Column column : table.getColumns()) {
                Column thisColumn = (Column)this.getColumns().get(column.getName());
                copyRow.put(thisColumn, row.get(column));
            }
            this.getRows().add(copyRow);
        }
    }

    public UniqueConstraint getPrimaryKeyConstraint() {
        return this.constraints.getPrimaryKeyConstraint();
    }

    public Table setPrimaryKey(Column ... primaryKey) {
        this.setPrimaryKey((String)null, primaryKey);
        return this;
    }

    public Table setPrimaryKey(String primaryKeyName, Column ... primaryKey) {
        Object constraintName = primaryKeyName;
        if (CommonUtils.isEmpty((CharSequence)constraintName)) {
            constraintName = "PK_" + this.getName();
        }
        this.getConstraints().addUniqueConstraint((String)constraintName, true, primaryKey);
        return this;
    }

    public Table setPrimaryKey(String primaryKeyName, Function<Column, Order> columnOrder, Column ... primaryKey) {
        Object constraintName = primaryKeyName;
        if (CommonUtils.isEmpty((CharSequence)constraintName)) {
            constraintName = "PK_" + this.getName();
        }
        List<ReferenceColumn> refCols = CommonUtils.list();
        for (Column column : this.columns) {
            refCols.add(new ReferenceColumn(column, columnOrder.apply(column)));
        }
        this.getConstraints().addUniqueConstraint((String)constraintName, true, refCols.toArray(new ReferenceColumn[0]));
        return this;
    }

    public Table setPrimaryKey(String primaryKeyName, Column col1, Order order1, Column col2) {
        Object constraintName = primaryKeyName;
        if (CommonUtils.isEmpty((CharSequence)constraintName)) {
            constraintName = "PK_" + this.getName();
        }
        this.getConstraints().addUniqueConstraint((String)constraintName, true, new ReferenceColumn(col1, order1));
        return this;
    }

    public Table setPrimaryKey(String primaryKeyName, Column col1, Order order1, Column col2, Order order2) {
        Object constraintName = primaryKeyName;
        if (CommonUtils.isEmpty((CharSequence)constraintName)) {
            constraintName = "PK_" + this.getName();
        }
        this.getConstraints().addUniqueConstraint((String)constraintName, true, new ReferenceColumn(col1, order1), new ReferenceColumn(col2, order2));
        return this;
    }

    public Table setPrimaryKey(String primaryKeyName, Column col1, Order order1, Column col2, Order order2, Column col3, Order order3) {
        Object constraintName = primaryKeyName;
        if (CommonUtils.isEmpty((CharSequence)constraintName)) {
            constraintName = "PK_" + this.getName();
        }
        this.getConstraints().addUniqueConstraint((String)constraintName, true, new ReferenceColumn(col1, order1), new ReferenceColumn(col2, order2), new ReferenceColumn(col3, order3));
        return this;
    }

    public Table setPrimaryKey(String primaryKeyName, Column col1, Order order1, Column col2, Order order2, Column col3, Order order3, Column col4, Order order4) {
        Object constraintName = primaryKeyName;
        if (CommonUtils.isEmpty((CharSequence)constraintName)) {
            constraintName = "PK_" + this.getName();
        }
        this.getConstraints().addUniqueConstraint((String)constraintName, true, new ReferenceColumn(col1, order1), new ReferenceColumn(col2, order2), new ReferenceColumn(col3, order3), new ReferenceColumn(col4, order4));
        return this;
    }

    public Table setPrimaryKey(String primaryKeyName, Column col1, Order order1, Column col2, Order order2, Column col3, Order order3, Column col4, Order order4, Column col5, Order order5) {
        Object constraintName = primaryKeyName;
        if (CommonUtils.isEmpty((CharSequence)constraintName)) {
            constraintName = "PK_" + this.getName();
        }
        this.getConstraints().addUniqueConstraint((String)constraintName, true, new ReferenceColumn(col1, order1), new ReferenceColumn(col2, order2), new ReferenceColumn(col3, order3), new ReferenceColumn(col4, order4), new ReferenceColumn(col5, order5));
        return this;
    }

    public List<Column> getAutoIncrementColumns() {
        return TableUtils.getAutoIncrementColumn(this);
    }

    @Override
    public TableCollection getParent() {
        return (TableCollection)super.getParent();
    }

    protected void setTables(TableCollection tableCollection) {
        this.setParent(tableCollection);
    }

    @Override
    public ConstraintCollection getConstraints() {
        return this.constraints;
    }

    protected Table setIndexes(IndexCollection indexes) {
        this.indexes = indexes;
        if (this.indexes != null) {
            this.indexes.setParent(null);
        }
        return this;
    }

    @Override
    public IndexCollection getIndexes() {
        return this.indexes;
    }

    @Override
    public Partitioning getPartitioning() {
        if (this.partitioning != null) {
            this.partitioning.setTable(this);
        }
        return this.partitioning;
    }

    @Override
    public Table setPartitioning(Partitioning partitioning) {
        if (this.partitioning != null) {
            this.partitioning.setTable(null);
        }
        if (partitioning != null) {
            partitioning.setTable(this);
        }
        this.partitioning = partitioning;
        return this;
    }

    public Table removePartitioning() {
        return this.setPartitioning(null);
    }

    @Override
    public Table setPartitionParent(PartitionParent partitionParent) {
        if (this.partitionParent != null) {
            Table parent = this.partitionParent.getParent();
            if (parent != null && parent.getPartitioning() != null) {
                parent.getPartitioning().removePartitionTable(this);
            }
            this.partitionParent.setParent(null);
        }
        if (partitionParent != null) {
            partitionParent.setParent(this);
            if (partitionParent.getTable() != null) {
                Table parentPartition = SchemaUtils.getTableOnlyFromParent(partitionParent.getTable().getSchemaName(), partitionParent.getTable().getName(), this);
                partitionParent.setTable(parentPartition);
                if (partitionParent.getTable().getPartitioning() == null) {
                    partitionParent.getTable().toPartitioning();
                }
            }
        }
        this.partitionParent = partitionParent;
        return (Table)this.instance();
    }

    @Override
    public PartitionParent getPartitionParent() {
        return this.partitionParent;
    }

    @Override
    public boolean isCompression() {
        return this.compression;
    }

    @Override
    public Table setCompression(boolean compression) {
        this.compression = compression;
        return (Table)this.instance();
    }

    @Override
    public boolean isUnlogged() {
        return this.unlogged;
    }

    @Override
    public Table setUnlogged(boolean unlogged) {
        this.unlogged = unlogged;
        return (Table)this.instance();
    }

    @Override
    public Table setCompressionType(String compressionType) {
        this.compressionType = compressionType;
        return (Table)this.instance();
    }

    @Override
    public String getCompressionType() {
        return this.compressionType;
    }

    @Override
    public Table setCharacterSet(String value) {
        this.characterSet = value;
        return this;
    }

    protected void writeCharacterSet(StaxWriter stax) throws XMLStreamException {
        String value = SchemaUtils.getParentCharacterSet(this);
        if (!CommonUtils.eqIgnoreCase(value, this.getCharacterSet())) {
            stax.writeAttribute(SchemaProperties.CHARACTER_SET.getLabel(), this.getCharacterSet());
        }
    }

    protected void writeCollation(StaxWriter stax) throws XMLStreamException {
        String value = SchemaUtils.getParentCollation(this);
        if (!CommonUtils.eqIgnoreCase(value, this.getCollation())) {
            stax.writeAttribute(SchemaProperties.COLLATION.getLabel(), this.getCollation());
        }
    }

    protected void writeCharacterSemantics(StaxWriter stax) throws XMLStreamException {
        CharacterSemantics value = SchemaUtils.getParentCharacterSemantics(this);
        if (!CommonUtils.eq(value, this.getCharacterSemantics())) {
            stax.writeAttribute(SchemaProperties.CHARACTER_SEMANTICS.getLabel(), (Object)this.getCharacterSemantics());
        }
    }

    @Override
    public Table setCollation(String value) {
        this.collation = value;
        return (Table)this.instance();
    }

    @Override
    public Table setCharacterSemantics(CharacterSemantics characterSemantics) {
        this.characterSemantics = characterSemantics;
        return (Table)this.instance();
    }

    @Override
    protected void writeXmlOptionalAttributes(StaxWriter stax) throws XMLStreamException {
        super.writeXmlOptionalAttributes(stax);
        stax.writeAttribute(SchemaProperties.READONLY.getLabel(), (Object)this.getReadonly());
        stax.writeAttribute(SchemaProperties.TABLE_TYPE.getLabel(), (Object)this.getTableType());
        stax.writeAttribute(SchemaProperties.TABLE_DATA_STORE_TYPE.getLabel(), (Object)this.getTableDataStoreType());
        stax.writeAttribute(SchemaProperties.TABLE_SPACE_NAME.getLabel(), this.getTableSpaceName());
        stax.writeAttribute(SchemaProperties.INDEX_TABLE_SPACE_NAME.getLabel(), this.getIndexTableSpaceName());
        stax.writeAttribute(SchemaProperties.LOB_TABLE_SPACE_NAME.getLabel(), this.getLobTableSpaceName());
        if (this.isCompression()) {
            stax.writeAttribute(SchemaProperties.COMPRESSION.getLabel(), (Object)this.isCompression());
            stax.writeAttribute(SchemaProperties.COMPRESSION_TYPE.getLabel(), this.getCompressionType());
        }
        if (this.isUnlogged()) {
            stax.writeAttribute(SchemaProperties.UNLOGGED.getLabel(), (Object)this.isUnlogged());
        }
        this.writeCharacterSet(stax);
        this.writeCollation(stax);
        this.writeCharacterSemantics(stax);
    }

    @Override
    protected void writeXmlOptionalValues(StaxWriter stax) throws XMLStreamException {
        if (!CommonUtils.isEmpty(this.getColumns())) {
            this.getColumns().writeXml(stax);
        }
        if (!CommonUtils.isEmpty(this.getConstraints())) {
            this.getConstraints().writeXml(stax);
        }
        if (!CommonUtils.isEmpty(this.getIndexes())) {
            this.getIndexes().writeXml(stax);
        }
        if (!CommonUtils.isEmpty(this.getPartitioning())) {
            this.getPartitioning().writeXml(stax);
        }
        if (!CommonUtils.isEmpty(this.getInherits())) {
            this.getInherits().writeXml(stax);
        }
        if (!CommonUtils.isEmpty(this.getPartitionParent())) {
            this.getPartitionParent().writeXml(stax);
        }
        this.writeXmlRows(stax);
        super.writeXmlOptionalValues(stax);
    }

    protected void writeXmlRows(StaxWriter stax) throws XMLStreamException {
        if (this.isTable()) {
            this.getRows().writeXml(stax);
        }
    }

    public void writeXmlRowDatas(StaxWriter stax) throws XMLStreamException {
        if (this.isTable()) {
            this.getRows().writeXml(stax);
        }
    }

    public void writeXmlRowDatas(OutputStream stream) throws XMLStreamException {
        StaxWriter stax = new StaxWriter(stream){

            @Override
            protected boolean isWriteStartDocument() {
                return true;
            }
        };
        this.writeXmlRowDatas(stax);
    }

    public void writeXmlRowDatas(Writer writer) throws XMLStreamException {
        StaxWriter stax = new StaxWriter(writer){

            @Override
            protected boolean isWriteStartDocument() {
                return true;
            }
        };
        this.writeXmlRowDatas(stax);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeRowData(File file) throws XMLStreamException, IOException {
        BufferedOutputStream stream = null;
        try {
            stream = new BufferedOutputStream(new FileOutputStream(file));
            StaxWriter stax = new StaxWriter(stream);
            this.writeXmlRowDatas(stax);
            stream.flush();
        }
        catch (Throwable throwable) {
            FileUtils.close(stream);
            throw throwable;
        }
        FileUtils.close(stream);
    }

    private boolean isTable() {
        if (this instanceof View) {
            return false;
        }
        return !(this instanceof Mview);
    }

    protected Table setConstraints(ConstraintCollection constraints) {
        this.constraints = constraints;
        return this;
    }

    @Override
    public Table setCaseSensitive(boolean caseSensitive) {
        this.columns.setCaseSensitive(caseSensitive);
        this.constraints.setCaseSensitive(caseSensitive);
        this.indexes.setCaseSensitive(caseSensitive);
        if (this.partitioning != null) {
            this.partitioning.setCaseSensitive(caseSensitive);
        }
        return (Table)super.setCaseSensitive(caseSensitive);
    }

    public List<Column> getUniqueColumns() {
        for (UniqueConstraint uniqueConstraint : this.getConstraints().getUniqueConstraints()) {
            List<Column> columns = CommonUtils.list();
            for (ReferenceColumn rColumn : uniqueConstraint.getColumns()) {
                Column column = (Column)this.getColumns().get(rColumn.getName());
                if (column == null) break;
                columns.add(column);
            }
            if (uniqueConstraint.getColumns().size() != columns.size()) continue;
            return columns;
        }
        return null;
    }

    @Override
    protected TableXmlReaderHandler getDbObjectXmlReaderHandler() {
        return new TableXmlReaderHandler();
    }

    @Override
    public void setRowIteratorHandler(RowIteratorHandler rowIteratorHandler) {
        this.getRows().setRowIteratorHandler(rowIteratorHandler);
    }

    public RowCollection getRows(RowIteratorHandler rowIteratorHandler) {
        this.getRows().setRowIteratorHandler(rowIteratorHandler);
        return this.getRows();
    }

    public boolean isDefaultRowIteratorHandler() {
        return this.getRows().getRowIteratorHandler() instanceof DefaultRowIteratorHandler;
    }

    public void setAddDbObjectFilter(AddDbObjectPredicate addDbObjectFilter) {
        this.getColumns().setAddDbObjectPredicate(addDbObjectFilter);
        this.getRows().setAddDbObjectFilter(addDbObjectFilter);
        this.getConstraints().setAddDbObjectPredicate(addDbObjectFilter);
        this.getIndexes().setAddDbObjectPredicate(addDbObjectFilter);
    }

    @Override
    protected void validate() {
        super.validate();
        if (this.getTableSpace() != null) {
            // empty if block
        }
        if (this.getColumns() != null) {
            this.getColumns().setParent(this);
            this.getColumns().validate();
        }
        if (this.getConstraints() != null) {
            this.getConstraints().setParent(this);
            this.getConstraints().validate();
        }
        if (this.getIndexes() != null) {
            this.getIndexes().setParent(this);
            this.getIndexes().validate();
        }
        if (this.getPartitioning() != null) {
            this.getPartitioning().setParent(this);
            this.getPartitioning().validate();
        }
        if (this.getPartitionParent() != null) {
            this.getPartitionParent().setParent(this);
            this.getPartitionParent().validate();
        }
        this.cleanupChildRelations();
    }

    private void cleanupChildRelations() {
        List<ForeignKeyConstraint> removeTargets = CommonUtils.list();
        Set names = CommonUtils.set();
        this.getChildRelations().forEach(fk -> {
            if (fk.getRelatedTable() == null) {
                removeTargets.add((ForeignKeyConstraint)fk);
            } else if (!fk.getRelatedTable().equals(this)) {
                removeTargets.add((ForeignKeyConstraint)fk);
            }
            if (fk.getName() != null && names.contains(fk.getName())) {
                removeTargets.add((ForeignKeyConstraint)fk);
            } else {
                names.add(fk.getName());
            }
        });
        for (ForeignKeyConstraint fk2 : removeTargets) {
            this.getChildRelations().remove(fk2);
        }
    }

    public List<ForeignKeyConstraint> getChildRelations() {
        return this.childRelations;
    }

    public List<ForeignKeyConstraint> getChildRelations(Predicate<ForeignKeyConstraint> p) {
        List<ForeignKeyConstraint> result = CommonUtils.list(this.childRelations.size());
        int size = this.childRelations.size();
        for (int i = 0; i < size; ++i) {
            ForeignKeyConstraint c = this.childRelations.get(i);
            ForeignKeyConstraint cc = (ForeignKeyConstraint)CommonUtils.cast(c);
            if (!p.test(cc)) continue;
            result.add(cc);
        }
        return result;
    }

    protected Table addChildRelation(ForeignKeyConstraint fk) {
        if (!this.childRelations.contains(fk)) {
            this.childRelations.add(fk);
        }
        return (Table)this.instance();
    }

    protected void setChildRelations(List<ForeignKeyConstraint> childRelations) {
        this.childRelations = childRelations;
    }

    public static enum TableOrder {
        CREATE(new TableCreateOrderComparator()),
        DROP(new TableDropOrderComparator());

        private Comparator<Table> comparator;

        private TableOrder(Comparator<Table> comparator) {
            this.comparator = comparator;
        }

        public Comparator<Table> getComparator() {
            return this.comparator;
        }
    }

    public static enum TableType implements EnumProperties
    {
        File("FILE", "F.*"),
        Memory("MEMORY", "M.*"),
        Cache("CACHE", "Cache.*"),
        Temporary("TEMPORARY", "T.*"),
        Flex("Flex", "F.*");

        private final String text;
        private final Pattern pattern;

        private TableType(String text, String patternText) {
            this.text = text;
            this.pattern = Pattern.compile(patternText, 2);
        }

        public static TableType parse(String text) {
            for (TableType enm : TableType.values()) {
                Matcher matcher = enm.pattern.matcher(text);
                if (!matcher.matches()) continue;
                return enm;
            }
            return null;
        }

        @Override
        public String getDisplayName() {
            return this.text;
        }

        @Override
        public String getDisplayName(Locale locale) {
            return this.getDisplayName();
        }

        @Override
        public String getSqlValue() {
            return this.getDisplayName();
        }
    }

    public static enum TableDataStoreType implements EnumProperties
    {
        Row,
        Column,
        Hybrid;


        public static TableDataStoreType parse(String text) {
            if (text == null) {
                return null;
            }
            for (TableDataStoreType enm : TableDataStoreType.values()) {
                if (!enm.toString().equalsIgnoreCase(text)) continue;
                return enm;
            }
            return null;
        }

        @Override
        public String getDisplayName() {
            return this.toString().toUpperCase();
        }

        @Override
        public String getDisplayName(Locale locale) {
            return this.getDisplayName();
        }

        @Override
        public String getSqlValue() {
            return this.getDisplayName();
        }
    }
}

