/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas.function;

import com.sqlapp.data.schemas.RowCollection;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.ToStringBuilder;
import com.sqlapp.util.TripleKeyMap;
import java.io.Serializable;
import java.util.function.Predicate;

public class RowCollectionNamePredicate
implements Predicate<RowCollection>,
Serializable {
    private static final long serialVersionUID = 6341437679279254394L;
    private String[] includes = null;
    private String[] excludes = null;
    private final TripleKeyMap<String, String, String, ObjectNameHolder> includeMap = CommonUtils.tripleKeyMap();
    private final TripleKeyMap<String, String, String, ObjectNameHolder> excludeMap = CommonUtils.tripleKeyMap();

    public RowCollectionNamePredicate(String[] includes, String[] excludes) {
        this.includes = includes;
        this.excludes = excludes;
        this.initialize(includes, excludes);
    }

    protected void initialize(String[] includes, String[] excludes) {
        ObjectNameHolder nameHolder;
        if (includes != null) {
            for (String arg : includes) {
                nameHolder = new ObjectNameHolder(arg);
                this.includeMap.put(nameHolder.catalogName, nameHolder.schemaName, nameHolder.objectName, nameHolder);
            }
        }
        if (excludes != null) {
            for (String arg : excludes) {
                nameHolder = new ObjectNameHolder(arg);
                this.excludeMap.put(nameHolder.catalogName, nameHolder.schemaName, nameHolder.objectName, nameHolder);
            }
        }
    }

    @Override
    public boolean test(RowCollection obj) {
        String catalogName = null;
        String schemaName = obj.getParent().getSchemaName();
        String name = obj.getParent().getName();
        return this.match(catalogName, schemaName, name);
    }

    private boolean match(String catalogName, String schemaName, String name) {
        ObjectNameHolder nameHolder = this.excludeMap.get(catalogName, schemaName, name);
        if (nameHolder != null) {
            return false;
        }
        if (this.includeMap.size() == 0) {
            return true;
        }
        nameHolder = this.includeMap.get(catalogName, schemaName, name);
        return nameHolder != null;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this.getClass());
        this.toString(builder);
        return builder.toString();
    }

    protected void toString(ToStringBuilder builder) {
        builder.add("includes", (Object)this.includes);
        builder.add("excludes", (Object)this.excludes);
    }

    static class ObjectNameHolder {
        String catalogName = null;
        String schemaName;
        String objectName;

        ObjectNameHolder(String name) {
            String[] splits = name.split("\\.");
            if (splits.length == 1) {
                this.schemaName = null;
            } else if (splits.length == 2) {
                this.schemaName = CommonUtils.first(splits);
            } else {
                throw new IllegalArgumentException("name=" + name);
            }
            this.objectName = CommonUtils.last(splits);
        }
    }
}

