/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas.rowiterator;

import com.sqlapp.data.db.datatype.DataType;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.Row;
import com.sqlapp.data.schemas.RowCollection;
import com.sqlapp.data.schemas.function.RowValueConverter;
import com.sqlapp.data.schemas.rowiterator.AbstractRowIteratorHandler;
import com.sqlapp.data.schemas.rowiterator.AbstractTextRowListIterator;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.JsonConverter;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class JsonRowIteratorHandler
extends AbstractRowIteratorHandler {
    private final File file;
    private final JsonConverter jsonConverter;

    public JsonRowIteratorHandler(File file, JsonConverter jsonConverter, RowValueConverter valueConverter) {
        super(valueConverter);
        this.file = file;
        this.jsonConverter = jsonConverter;
    }

    public JsonRowIteratorHandler(File file, JsonConverter jsonConverter) {
        super((Row r, Column c, Object v) -> v);
        this.file = file;
        this.jsonConverter = jsonConverter;
    }

    public JsonRowIteratorHandler(File file) {
        super((Row r, Column c, Object v) -> v);
        this.file = file;
        this.jsonConverter = new JsonConverter();
    }

    @Override
    public Iterator<Row> iterator(RowCollection c) {
        return new JsonRowIterator(c, this.file, this.jsonConverter, 0L, this.getRowValueConverter());
    }

    @Override
    public ListIterator<Row> listIterator(RowCollection c, int index) {
        return new JsonRowIterator(c, this.file, this.jsonConverter, index, this.getRowValueConverter());
    }

    @Override
    public ListIterator<Row> listIterator(RowCollection c) {
        return (ListIterator)this.iterator(c);
    }

    public static class JsonRowIterator
    extends AbstractTextRowListIterator<Map<String, Object>> {
        private final JsonConverter jsonConverter;
        private final File file;
        private final String filename;
        private List<Map<String, Object>> list;
        private Iterator<Map<String, Object>> iterator;
        private Map<String, Object> current = null;
        private boolean hasColumn = false;

        JsonRowIterator(RowCollection c, File file, JsonConverter jsonConverter, long index, RowValueConverter valueConverter) {
            super(c, index, valueConverter);
            this.file = file;
            this.filename = file.getAbsolutePath();
            this.jsonConverter = jsonConverter;
        }

        @Override
        protected void preInitialize() throws Exception {
            this.list = this.jsonConverter.fromJsonString(this.file, List.class);
            this.iterator = this.list.iterator();
        }

        @Override
        protected void initializeColumn() throws Exception {
            if (!CommonUtils.isEmpty(this.table.getColumns())) {
                this.hasColumn = true;
            }
        }

        @Override
        protected boolean hasNextInternal() throws Exception {
            return this.iterator.hasNext();
        }

        @Override
        protected Map<String, Object> read() throws Exception {
            this.current = this.iterator.next();
            return this.current;
        }

        @Override
        protected void set(Map<String, Object> map, Row row) throws Exception {
            row.setDataSourceInfo(this.filename);
            row.setDataSourceRowNumber(this.count + 1L);
            map.forEach((columnName, value) -> {
                Column column = this.searchColumn(this.table, (String)columnName);
                if (!this.hasColumn && column == null) {
                    column = new Column((String)columnName);
                    this.table.getColumns().add(column);
                }
                if (column != null && value != null) {
                    this.setType(column, value);
                    this.put(row, column, value);
                }
            });
        }

        private void setType(Column column, Object value) {
            if (value instanceof Boolean) {
                if (column.getDataType() == null) {
                    column.setDataType(DataType.BOOLEAN);
                }
            } else if (value instanceof Integer || value instanceof Long) {
                if (column.getDataType() == null) {
                    column.setDataType(DataType.BIGINT);
                }
            } else if (value instanceof Number) {
                if (column.getDataType() == null) {
                    column.setDataType(DataType.DECIMAL);
                    column.setLength(38L);
                    column.setScale(17);
                } else if (column.getDataType() == DataType.INT) {
                    column.setDataType(DataType.DECIMAL);
                    column.setLength(38L);
                    column.setScale(17);
                }
            } else {
                String val = value.toString();
                long len = this.getTypeLength(val);
                if (column.getDataType() == null) {
                    column.setDataType(DataType.NVARCHAR);
                    column.setLength(len);
                }
                if (column.getLength() != null) {
                    column.setLength(Math.max(len, column.getLength()));
                }
            }
        }

        @Override
        protected void doClose() {
            this.iterator = null;
        }
    }
}

