/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.jdbc.sql;

import com.sqlapp.jdbc.sql.AbstractSqlRegistry;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.FileUtils;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;

public class ClassPathSqlRegistry
extends AbstractSqlRegistry {
    private String basePath = null;
    private String encoding = "UTF-8";
    private String extension = ".sql";

    public ClassPathSqlRegistry(Class<?> clazz) {
        this.setBasePath(clazz.getPackage().getName().replace('.', '/') + "/");
    }

    public ClassPathSqlRegistry(String basePath) {
        this.setBasePath(basePath);
    }

    public ClassPathSqlRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(String sqlId) {
        InputStream inp;
        block3: {
            boolean bl;
            String path = FileUtils.combinePath(this.getBasePath(), sqlId + this.getExtension());
            inp = null;
            try {
                inp = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
                if (inp != null) break block3;
                bl = false;
            }
            catch (Throwable throwable) {
                FileUtils.close(inp);
                throw throwable;
            }
            FileUtils.close(inp);
            return bl;
        }
        boolean bl = true;
        FileUtils.close(inp);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(String sqlId, String databaseProductName) {
        InputStream inp;
        block3: {
            boolean bl;
            inp = null;
            try {
                inp = Thread.currentThread().getContextClassLoader().getResourceAsStream(FileUtils.combinePath(this.getBasePath(), databaseProductName, sqlId + this.getExtension()));
                if (inp != null) break block3;
                bl = false;
            }
            catch (Throwable throwable) {
                FileUtils.close(inp);
                throw throwable;
            }
            FileUtils.close(inp);
            return bl;
        }
        boolean bl = true;
        FileUtils.close(inp);
        return bl;
    }

    @Override
    protected List<String> getInternal(String sqlId) {
        String path = FileUtils.combinePath(this.getBasePath(), sqlId + this.getExtension());
        String sql = this.getByPath(path);
        return ClassPathSqlRegistry.splitSql(sql);
    }

    protected static List<String> splitSql(String sql) {
        if (sql == null) {
            return Collections.emptyList();
        }
        String[] args = sql.split(";");
        return CommonUtils.list(args);
    }

    @Override
    protected List<String> getInternal(String sqlId, String databaseProductName) {
        String path = FileUtils.combinePath(this.getBasePath(), databaseProductName, sqlId + this.getExtension());
        String sql = this.getByPath(path);
        return ClassPathSqlRegistry.splitSql(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getByPath(String path) {
        String sql;
        InputStream inp;
        block3: {
            String string;
            inp = null;
            try {
                inp = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
                if (inp != null) break block3;
                string = null;
            }
            catch (Throwable throwable) {
                FileUtils.close(inp);
                throw throwable;
            }
            FileUtils.close(inp);
            return string;
        }
        String string = sql = FileUtils.readText(inp, "utf8");
        FileUtils.close(inp);
        return string;
    }

    @Override
    protected void putInternal(String sqlId, String databaseProductName, String ... sql) {
    }

    @Override
    protected void removeInternal(String sqlId) {
    }

    @Override
    protected void removeInternal(String sqlId, String databaseProductName) {
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }
}

