/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.jdbc.sql;

import com.sqlapp.data.DataMessageReader;
import com.sqlapp.data.parameter.ParameterDefinition;
import com.sqlapp.exceptions.SqlParseException;
import com.sqlapp.jdbc.sql.node.AbstractNodeFactory;
import com.sqlapp.jdbc.sql.node.BindVariableArrayNodeFactory;
import com.sqlapp.jdbc.sql.node.BindVariableNodeFactory;
import com.sqlapp.jdbc.sql.node.CommentNode;
import com.sqlapp.jdbc.sql.node.ElseIfNode;
import com.sqlapp.jdbc.sql.node.ElseNode;
import com.sqlapp.jdbc.sql.node.ElseNodeFactory;
import com.sqlapp.jdbc.sql.node.EndNode;
import com.sqlapp.jdbc.sql.node.EndNodeFactory;
import com.sqlapp.jdbc.sql.node.ForNodeFactory;
import com.sqlapp.jdbc.sql.node.IfNode;
import com.sqlapp.jdbc.sql.node.IfNodeFactory;
import com.sqlapp.jdbc.sql.node.InputStreamNodeFactory;
import com.sqlapp.jdbc.sql.node.NeedsEndNode;
import com.sqlapp.jdbc.sql.node.Node;
import com.sqlapp.jdbc.sql.node.OutputStreamNodeFactory;
import com.sqlapp.jdbc.sql.node.OutputVariableNodeFactory;
import com.sqlapp.jdbc.sql.node.ParameterMarkerNodeFactory;
import com.sqlapp.jdbc.sql.node.QueryNodeFactory;
import com.sqlapp.jdbc.sql.node.ReplaceVariableNodeFactory;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.jdbc.sql.node.SqlPartNode;
import com.sqlapp.util.CommonUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SqlParser {
    private static final SqlParser instance = new SqlParser();
    private List<AbstractNodeFactory<?>> nodeFactoryList = CommonUtils.list();
    private static Pattern PARAMETER_NAME_FILTER = Pattern.compile("(true|false|null|[0-9]+)");
    private static Pattern PARAMETER_EQ_FILTER = Pattern.compile("is(Not)?Empty\\(([^)]+)\\)");
    private static Pattern PARAMETER_PATH_FILTER = Pattern.compile("(.*)\\.(\\(.*?\\))");

    public static SqlParser getInstance() {
        return instance;
    }

    private SqlParser() {
        this.nodeFactoryList.add(new BindVariableArrayNodeFactory());
        this.nodeFactoryList.add(new BindVariableNodeFactory());
        this.nodeFactoryList.add(new IfNodeFactory());
        this.nodeFactoryList.add(new ElseNodeFactory());
        this.nodeFactoryList.add(new ForNodeFactory());
        this.nodeFactoryList.add(new ReplaceVariableNodeFactory());
        this.nodeFactoryList.add(new OutputVariableNodeFactory());
        this.nodeFactoryList.add(new EndNodeFactory());
        this.nodeFactoryList.add(new QueryNodeFactory());
        this.nodeFactoryList.add(new ParameterMarkerNodeFactory());
        this.nodeFactoryList.add(new InputStreamNodeFactory());
        this.nodeFactoryList.add(new OutputStreamNodeFactory());
    }

    public SqlNode parse(String sql) {
        SqlNode rootNode = new SqlNode();
        SortedMap<Integer, Node> sortedNodes = this.createNodes(sql);
        Map<Integer, Integer> keyMap = this.createKeyMap(sortedNodes);
        this.parseSql(rootNode, sortedNodes, keyMap, 0, sortedNodes.size(), 0);
        rootNode.setParameters(this.getParameterMarkerNodes(rootNode));
        return rootNode;
    }

    private Set<ParameterDefinition> getParameterMarkerNodes(SqlNode rootNode) {
        Set<ParameterDefinition> parameters = CommonUtils.linkedSet();
        this.setParameterDefinitions(rootNode, parameters);
        Set<ParameterDefinition> result = CommonUtils.linkedSet();
        for (ParameterDefinition parameterDefinition : parameters) {
            List<ParameterDefinition> list = this.convert(parameterDefinition);
            if (list == null) continue;
            result.addAll(list);
        }
        return result;
    }

    private List<ParameterDefinition> convert(ParameterDefinition parameterDefinition) {
        Matcher matcher;
        parameterDefinition.setName(CommonUtils.trim(CommonUtils.unwrap(parameterDefinition.getName(), '(', ')')));
        String[] splits = parameterDefinition.getName().split("(\\|\\||&&)");
        List<ParameterDefinition> result = CommonUtils.list();
        if (splits.length == 1 && (matcher = PARAMETER_EQ_FILTER.matcher(parameterDefinition.getName())).matches()) {
            result.add(new ParameterDefinition(matcher.group(2)));
            return result;
        }
        for (String val : splits) {
            String[] eqSplit;
            val = CommonUtils.unwrap(CommonUtils.trim(val), '(', ')');
            for (String eqVal : eqSplit = val.split("(==|\\|\\||!=|<=?|>=?)")) {
                Matcher matcher2 = PARAMETER_NAME_FILTER.matcher(eqVal = CommonUtils.unwrap(CommonUtils.trim(eqVal), '(', ')'));
                if (matcher2.matches() || this.isString(eqVal)) continue;
                matcher2 = PARAMETER_EQ_FILTER.matcher(eqVal);
                if (matcher2.matches()) {
                    result.add(new ParameterDefinition(matcher2.group(2)));
                    continue;
                }
                matcher2 = PARAMETER_PATH_FILTER.matcher(eqVal);
                if (matcher2.matches()) {
                    result.add(new ParameterDefinition(matcher2.group(1)));
                    continue;
                }
                result.add(new ParameterDefinition(eqVal));
            }
        }
        return result;
    }

    private boolean isString(String value) {
        if (value.startsWith("\"") && value.endsWith("\"") && value.contains("\"")) {
            return true;
        }
        return value.startsWith("'") && value.endsWith("'") && value.contains("'");
    }

    private void setParameterDefinitions(Node node, Set<ParameterDefinition> parameters) {
        ParameterDefinition def;
        if (node instanceof CommentNode && (def = ((CommentNode)node).getParameterDefinition()) != null && def.getName() != null) {
            parameters.add(def);
        }
        for (Node child : node.getChildNodes()) {
            this.setParameterDefinitions(child, parameters);
        }
    }

    private void parseSql(Node node, SortedMap<Integer, Node> sortedNodes, Map<Integer, Integer> keyMap, int start, int end, int nestedLevel) {
        Node childNode = null;
        for (int i = start; i < end; ++i) {
            int index = keyMap.get(i);
            childNode = (Node)sortedNodes.get(index);
            if (childNode instanceof NeedsEndNode) {
                i = this.parseNeedsEndNodes((NeedsEndNode)childNode, sortedNodes, keyMap, i + 1, end, nestedLevel + 1);
            }
            childNode.setNestedLevel(nestedLevel);
            if (childNode instanceof EndNode) continue;
            node.addChildNode(childNode);
        }
    }

    private Map<Integer, Integer> createKeyMap(SortedMap<Integer, Node> sortedNodes) {
        HashMap<Integer, Integer> keyMap = new HashMap<Integer, Integer>();
        int i = 0;
        for (Integer key : sortedNodes.keySet()) {
            keyMap.put(i++, key);
        }
        return keyMap;
    }

    private int parseNeedsEndNodes(NeedsEndNode node, SortedMap<Integer, Node> sortedNodes, Map<Integer, Integer> keyMap, int start, int end, int nestedLevel) {
        Node childNode = null;
        int i = 0;
        for (i = start; i < end; ++i) {
            int index = keyMap.get(i);
            childNode = (Node)sortedNodes.get(index);
            if (childNode instanceof NeedsEndNode) {
                i = this.parseNeedsEndNodes((NeedsEndNode)childNode, sortedNodes, keyMap, i + 1, end, nestedLevel++);
                node.addChildNode(childNode);
                continue;
            }
            if (childNode instanceof EndNode) {
                return i;
            }
            if (node instanceof IfNode && childNode instanceof ElseIfNode) {
                childNode.setNestedLevel(nestedLevel);
                ((IfNode)node).getElseIfNodes().add((ElseIfNode)childNode);
                continue;
            }
            if (node instanceof IfNode && childNode instanceof ElseNode) {
                childNode.setNestedLevel(nestedLevel);
                ((IfNode)node).setElseNode((ElseNode)childNode);
                continue;
            }
            childNode.setNestedLevel(nestedLevel + 1);
            node.addChildNode(childNode);
        }
        String message = DataMessageReader.getInstance().getMessage("ESQL00002", node.getMatchText());
        throw new SqlParseException(message);
    }

    private SortedMap<Integer, Node> createNodes(String sql) {
        TreeMap<Integer, Node> sortedNodes = new TreeMap<Integer, Node>();
        for (AbstractNodeFactory<?> factory : this.nodeFactoryList) {
            sortedNodes.putAll(factory.parseSql(sql));
        }
        this.parseSql(sql, sortedNodes);
        return sortedNodes;
    }

    private void parseSql(String sql, SortedMap<Integer, Node> sortedNodes) {
        int pos = 0;
        int len = 0;
        ArrayList<SqlPartNode> sqlNodes = new ArrayList<SqlPartNode>();
        int index = 0;
        CommentNode commentNode = null;
        SqlPartNode sqlNode = new SqlPartNode();
        sqlNode.setIndex(0);
        if (sortedNodes.size() > 0) {
            index = sortedNodes.firstKey();
            commentNode = (CommentNode)sortedNodes.get(index);
            len = commentNode.getIndex() - pos;
            sqlNode.setSql(sql.substring(pos, len));
            pos = index + commentNode.getMatchText().length();
        } else {
            len = sql.length();
            sqlNode.setSql(sql.substring(pos, len));
            pos = len;
        }
        sqlNodes.add(sqlNode);
        boolean first = true;
        for (Map.Entry<Integer, Node> entry : sortedNodes.entrySet()) {
            if (!first) {
                index = entry.getKey();
                commentNode = (CommentNode)entry.getValue();
                if (index >= pos) {
                    sqlNode = new SqlPartNode();
                    sqlNode.setSql(sql.substring(pos, index));
                    sqlNode.setIndex(pos);
                    sqlNodes.add(sqlNode);
                    pos = index + commentNode.getMatchText().length();
                }
            }
            first = false;
        }
        if (pos < sql.length()) {
            sqlNode = new SqlPartNode();
            sqlNode.setSql(sql.substring(pos));
            sqlNode.setIndex(pos);
            sqlNodes.add(sqlNode);
        }
        for (SqlPartNode ele : sqlNodes) {
            if (CommonUtils.isEmpty(ele.getSql())) continue;
            sortedNodes.put(ele.getIndex(), ele);
        }
    }
}

