/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.jdbc.sql.node;

import com.sqlapp.data.db.datatype.DataType;
import com.sqlapp.data.parameter.ParameterDefinition;
import com.sqlapp.jdbc.sql.BindParameter;
import com.sqlapp.jdbc.sql.ParameterDirection;
import com.sqlapp.jdbc.sql.SqlParameterCollection;
import com.sqlapp.jdbc.sql.node.AbstractColumnNode;
import com.sqlapp.util.CommonUtils;
import java.util.Map;

public class BindVariableNode
extends AbstractColumnNode {
    private static final long serialVersionUID = 1700573849729755073L;
    private final BindParameter bindParameter = new BindParameter();

    @Override
    public boolean eval(Object context, SqlParameterCollection sqlParameters) {
        BindParameter parameter = this.bindParameter.clone();
        Object val = this.evalExpression(this.bindParameter.getName(), context);
        parameter.setValue(val);
        String operatorText = this.getColumnOperator(this.bindParameter.getName(), context);
        this.addColumnOperator(sqlParameters, operatorText);
        sqlParameters.add(parameter);
        return true;
    }

    @Override
    public void setExpression(String expression) {
        this.setParameterDefinition(BindVariableNode.parse(this.bindParameter, expression));
        if (this.getParameterDefinition() != null) {
            this.expression = this.getParameterDefinition().getName();
        }
    }

    protected static ParameterDefinition parse(BindParameter bindParameter, String expression) {
        String[] params = CommonUtils.trim(expression).split("[ ]*;[ ]*");
        bindParameter.setName(CommonUtils.trim(params[0]));
        Map<String, String> map = CommonUtils.parseKeyValue(expression);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if ("type".equalsIgnoreCase(entry.getKey())) {
                DataType type = DataType.valueOf(entry.getValue());
                bindParameter.setType(type);
                continue;
            }
            if (!"direction".equalsIgnoreCase(entry.getKey())) continue;
            ParameterDirection direction = ParameterDirection.valueOf(entry.getValue());
            bindParameter.setDirection(direction);
        }
        return new ParameterDefinition(bindParameter.getName());
    }

    @Override
    public BindVariableNode clone() {
        return (BindVariableNode)super.clone();
    }
}

