/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.jdbc.sql.node;

import com.sqlapp.data.parameter.ParameterDefinition;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.jdbc.sql.SqlParameterCollection;
import com.sqlapp.jdbc.sql.node.NeedsEndNode;
import com.sqlapp.util.AbstractIterator;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.SimpleBeanUtils;
import java.util.Map;

public class ForNode
extends NeedsEndNode
implements Cloneable {
    private static final long serialVersionUID = -1261063598891910651L;
    private String variableName = null;

    @Override
    public boolean eval(Object context, SqlParameterCollection sqlParameters) {
        Object val = this.evalExpression(this.getExpression(), context);
        if (context instanceof ParametersContext) {
            this.execLoop((ParametersContext)context, sqlParameters, val);
        } else if (context instanceof Map) {
            this.execLoop((Map)context, sqlParameters, val);
        } else if (context != null) {
            Map<String, Object> map = SimpleBeanUtils.getInstance(context.getClass()).toMap(context);
            this.execLoop(map, sqlParameters, val);
        } else {
            Map map = CommonUtils.map();
            this.execLoop(map, sqlParameters, val);
        }
        return true;
    }

    private void execLoop(ParametersContext context, final SqlParameterCollection sqlParameters, Object val) {
        final String variableName = this.getVariableName();
        final String indexName = this.getIndexName();
        final ParametersContext copyContext = context.clone();
        AbstractIterator<Object> itr = new AbstractIterator<Object>(this.getEvaluator()){

            @Override
            protected void handle(Object obj, int index) {
                copyContext.put(indexName, (Object)index);
                copyContext.put(variableName, obj);
                ForNode.this.evalChilds(copyContext, sqlParameters);
            }

            @Override
            protected void executeFinally() {
                copyContext.remove(variableName);
                copyContext.remove(indexName);
            }
        };
        try {
            itr.execute(val);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void execLoop(Map<?, ?> context, final SqlParameterCollection sqlParameters, Object val) {
        final String variableName = this.getVariableName();
        final String indexName = this.getIndexName();
        final Map<?, ?> copyContext = CommonUtils.cloneMap(context);
        final boolean containts = context.containsKey(variableName);
        AbstractIterator<Object> itr = new AbstractIterator<Object>(this.getEvaluator()){

            @Override
            protected void handle(Object obj, int index) {
                copyContext.put(indexName, index);
                if (!containts) {
                    copyContext.put(variableName, obj);
                }
                ForNode.this.evalChilds(copyContext, sqlParameters);
            }

            @Override
            protected void executeFinally() {
                if (!containts) {
                    copyContext.remove(variableName);
                }
                copyContext.remove(indexName);
            }
        };
        try {
            itr.execute(val);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String getIndexName() {
        return this.getVariableName() + "_index";
    }

    public String getVariableName() {
        return this.variableName;
    }

    protected void setVariableName(String variableName) {
        this.variableName = variableName;
        this.setParameterDefinition(new ParameterDefinition(variableName));
    }

    @Override
    public ForNode clone() {
        return (ForNode)super.clone();
    }
}

