/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.jdbc.sql.node;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.parameter.ParameterDefinition;
import com.sqlapp.exceptions.SqlSecurityException;
import com.sqlapp.jdbc.sql.SqlParameterCollection;
import com.sqlapp.jdbc.sql.node.CommentNode;
import com.sqlapp.util.CommonUtils;
import java.util.Map;

public class ReplaceVariableNode
extends CommentNode {
    private static final long serialVersionUID = 7741989233299651746L;
    private Integer length = null;
    private String replaceString = null;
    private Boolean sqlKeywordCheck = false;

    @Override
    public boolean eval(Object context, SqlParameterCollection sqlParameters) {
        Object val = this.evalExpression(this.getExpression(), context);
        if (val != null) {
            String text = ReplaceVariableNode.sanitize(val.toString());
            if (this.getSqlKeywordCheck() != null && this.getSqlKeywordCheck().booleanValue()) {
                this.checkSqlSecurity(text);
            }
            sqlParameters.addSql(text);
            if (this.length != null) {
                sqlParameters.addSql(this.replaceString);
            }
        }
        return true;
    }

    private void checkSqlSecurity(String text) {
        if (this.containsSqlWord(text)) {
            throw new SqlSecurityException("Invalid parameter." + this.getExpression() + "=" + text);
        }
    }

    @Override
    public void setExpression(String expression) {
        String[] splits = expression.split(";");
        this.expression = CommonUtils.trim(splits[0]);
        Map<String, String> map = CommonUtils.parseKeyValue(expression);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if ("length".equalsIgnoreCase(entry.getKey())) {
                this.length = Integer.valueOf(entry.getValue());
            }
            if (!"sqlKeywordCheck".equalsIgnoreCase(entry.getKey())) continue;
            this.sqlKeywordCheck = Converters.getDefault().convertObject(entry.getValue(), Boolean.class);
        }
        if (this.length != null) {
            String txt = this.getMatchText().substring(this.getMatchText().lastIndexOf("*/") + 2);
            this.replaceString = txt.substring(this.length);
        }
        this.setParameterDefinition(new ParameterDefinition(this.expression));
    }

    public Integer getLength() {
        return this.length;
    }

    public Boolean getSqlKeywordCheck() {
        return this.sqlKeywordCheck;
    }

    public void setSqlKeywordCheck(Boolean sqlKeywordCheck) {
        this.sqlKeywordCheck = sqlKeywordCheck;
    }

    @Override
    public ReplaceVariableNode clone() {
        return (ReplaceVariableNode)super.clone();
    }
}

