/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import com.sqlapp.util.AbstractIterator;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.DefaultPredicate;
import com.sqlapp.util.FileUtils;
import com.sqlapp.util.Searcher;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

abstract class AbstractClassFinder<T> {
    protected ClassLoader classLoader;
    private Predicate<T> filter = new DefaultPredicate();
    Map<String, Searcher<T>> resourceSearchers = CommonUtils.map();
    private Method getPackagesMethod = null;
    private Method getURLsMethod = null;

    public AbstractClassFinder() {
        this.classLoader = Thread.currentThread().getContextClassLoader();
        this.itialize();
    }

    public AbstractClassFinder(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.itialize();
    }

    protected abstract void itialize();

    public void addResourceSearcher(Searcher<T> resourceFinder) {
        for (String protocol : resourceFinder.supportProtocols()) {
            this.addResourceSearcher(protocol, resourceFinder);
        }
    }

    public void addResourceSearcher(String protocol, Searcher<T> resourceFinder) {
        this.resourceSearchers.put(protocol, resourceFinder);
    }

    public Predicate<T> getFilter() {
        return this.filter;
    }

    public void setFilter(Predicate<T> filter) {
        this.filter = filter;
    }

    private String packageNameToResourceName(String packageName) {
        return packageName.replace('.', '/');
    }

    protected List<T> findClasses(final ClassLoader classLoader, String packageName, final boolean recursive) {
        final List classes = CommonUtils.list();
        if (CommonUtils.isEmpty(packageName)) {
            Method urlMethod = this.getGetURLsMethod(classLoader.getClass());
            if (urlMethod != null) {
                try {
                    Object obj = urlMethod.invoke((Object)classLoader, new Object[0]);
                    AbstractIterator<URL> itr = new AbstractIterator<URL>(){

                        @Override
                        protected void handle(URL obj, int index) throws Exception {
                            List cls = AbstractClassFinder.this.findClasses(classLoader, "", recursive, obj);
                            AbstractClassFinder.this.merge(classes, cls);
                        }
                    };
                    itr.execute(obj);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (recursive) {
                Method method = this.getPackagesMethod(classLoader.getClass());
                if (method == null) {
                    return classes;
                }
                try {
                    Package[] packages = (Package[])method.invoke((Object)classLoader, new Object[0]);
                    Set<String> roots = this.getRootPackages(packages);
                    for (String root : roots) {
                        Enumeration<URL> enm;
                        String resourceName = this.packageNameToResourceName(root);
                        try {
                            enm = classLoader.getResources(resourceName);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        while (enm.hasMoreElements()) {
                            URL url = enm.nextElement();
                            List<T> cls = this.findClasses(classLoader, root, recursive, url);
                            this.merge(classes, cls);
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            Enumeration<URL> enm;
            String resourceName = this.packageNameToResourceName(packageName);
            try {
                enm = classLoader.getResources(resourceName);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            while (enm.hasMoreElements()) {
                URL url = enm.nextElement();
                List<T> cls = this.findClasses(classLoader, packageName, recursive, url);
                this.merge(classes, cls);
            }
        }
        return classes;
    }

    private Set<String> getRootPackages(Package[] packages) {
        Set<String> result = CommonUtils.linkedSet();
        for (Package pack : packages) {
            String[] splits = pack.getName().split("\\.");
            result.add(CommonUtils.first(splits));
        }
        return result;
    }

    private Method getPackagesMethod(Class<?> clazz) {
        Method[] methods;
        if (this.getPackagesMethod != null) {
            return this.getPackagesMethod;
        }
        if (clazz == null) {
            return null;
        }
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (!"getPackages".equalsIgnoreCase(method.getName()) || method.getParameterCount() != 0) continue;
            method.setAccessible(true);
            this.getPackagesMethod = method;
            return method;
        }
        return this.getPackagesMethod(clazz.getSuperclass());
    }

    private Method getGetURLsMethod(Class<?> clazz) {
        Method[] methods;
        if (this.getURLsMethod != null) {
            return this.getURLsMethod;
        }
        if (clazz == null) {
            return null;
        }
        for (Method method : methods = clazz.getMethods()) {
            if (!"getURLs".equalsIgnoreCase(method.getName()) || method.getParameterCount() != 0) continue;
            method.setAccessible(true);
            this.getURLsMethod = method;
            return method;
        }
        return null;
    }

    protected abstract void merge(List<T> var1, List<T> var2);

    protected <U> List<T> findClasses(ClassLoader classLoader, String packageName, boolean recursive, URL url) {
        if (url == null) {
            return CommonUtils.list();
        }
        String protocol = url.getProtocol();
        Searcher<T> searcher = this.resourceSearchers.get(protocol);
        if ("file".equals(url.getProtocol())) {
            String extension = FileUtils.getExtension(url.getFile());
            Searcher<T> jarSearcher = this.resourceSearchers.get("jar");
            if (("jar".equals(extension) || "zip".equals(extension)) && jarSearcher != null) {
                try {
                    url = new URL("jar:" + url.toString() + "!/");
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
                searcher = jarSearcher;
            }
        }
        if (searcher != null) {
            searcher.setClassLoader(classLoader);
            searcher.setFilter(this.filter);
            this.initialize(searcher);
            return searcher.search(packageName, url, recursive);
        }
        throw new IllegalArgumentException("Unsupported Class Load Protodol[" + protocol + "]");
    }

    protected abstract void initialize(Searcher<T> var1);
}

