/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.db.datatype.DataType;
import com.sqlapp.data.db.datatype.DbDataType;
import com.sqlapp.data.db.datatype.LengthProperties;
import com.sqlapp.data.db.datatype.PrecisionProperties;
import com.sqlapp.data.db.datatype.ScaleProperties;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.DialectUtils;
import com.sqlapp.data.db.sql.TableLockMode;
import com.sqlapp.data.schemas.AbstractColumn;
import com.sqlapp.data.schemas.AbstractNamedObject;
import com.sqlapp.data.schemas.AbstractSchemaObject;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.ColumnCollection;
import com.sqlapp.data.schemas.DimensionLevel;
import com.sqlapp.data.schemas.EnumProperties;
import com.sqlapp.data.schemas.ForeignKeyConstraint;
import com.sqlapp.data.schemas.FunctionReturning;
import com.sqlapp.data.schemas.Index;
import com.sqlapp.data.schemas.IndexType;
import com.sqlapp.data.schemas.NamedArgument;
import com.sqlapp.data.schemas.NamedArgumentCollection;
import com.sqlapp.data.schemas.Order;
import com.sqlapp.data.schemas.ReferenceColumn;
import com.sqlapp.data.schemas.ReferenceColumnCollection;
import com.sqlapp.data.schemas.Routine;
import com.sqlapp.data.schemas.Schema;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.properties.DataTypeProperties;
import com.sqlapp.data.schemas.properties.DataTypeSetProperties;
import com.sqlapp.jdbc.sql.ParameterDirection;
import com.sqlapp.util.CommonUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;

public class AbstractSqlBuilder<T extends AbstractSqlBuilder<?>>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 8626853738386921275L;
    private StringBuilder builder = new StringBuilder(256);
    private String indentString = "\t";
    private int indentSize = 0;
    private Dialect dialect = DialectUtils.getInstance(Dialect.class);
    private boolean quateObjectName = true;
    private boolean quateColumnName = true;
    private boolean withSchemaName = true;
    private boolean appendAutoSpace = true;
    private final Map<String, Boolean> conditionMap = new HashMap<String, Boolean>();
    private static final String COMMA = ",";
    private boolean firstElement = true;

    public boolean isWithSchemaName() {
        return this.withSchemaName;
    }

    public T setWithSchemaName(boolean withSchemaName) {
        this.withSchemaName = withSchemaName;
        return this.instance();
    }

    public boolean isAppendAutoSpace() {
        return this.appendAutoSpace;
    }

    public T setAppendAutoSpace(boolean appendAutoSpace) {
        this.appendAutoSpace = appendAutoSpace;
        return this.instance();
    }

    protected T instance() {
        return (T)this;
    }

    public boolean isQuateObjectName() {
        return this.quateObjectName;
    }

    public T setQuateObjectName(boolean quateObjectName) {
        this.quateObjectName = quateObjectName;
        return this.instance();
    }

    public boolean isQuateColumnName() {
        return this.quateColumnName;
    }

    public T setQuateColumnName(boolean quateColumnName) {
        this.quateColumnName = quateColumnName;
        return this.instance();
    }

    public AbstractSqlBuilder(Dialect dialect) {
        this.dialect = dialect;
    }

    public T create() {
        this.appendElement("CREATE");
        return this.instance();
    }

    public T alter() {
        this.appendElement("ALTER");
        return this.instance();
    }

    public T alterColumn() {
        this.appendElement("ALTER COLUMN");
        return this.instance();
    }

    public T rename() {
        this.appendElement("RENAME");
        return this.instance();
    }

    public T to() {
        this.appendElement("TO");
        return this.instance();
    }

    public T name(AbstractNamedObject<?> object) {
        return this.appendQuoteName(object.getName());
    }

    public T name(Index index) {
        return this.name(index, this.isWithSchemaName());
    }

    public T name(Index index, boolean withSchemaName) {
        if (withSchemaName && !CommonUtils.isEmpty(index.getTable().getSchemaName())) {
            this.appendQuoteName(index.getTable().getSchemaName());
            this._add('.');
        }
        return this.appendQuoteName(index.getName());
    }

    public T name(AbstractSchemaObject<?> abstractSchemaObject) {
        return this.name(abstractSchemaObject, this.isWithSchemaName());
    }

    public T name(AbstractSchemaObject<?> abstractSchemaObject, boolean withSchemaName) {
        if (withSchemaName && !CommonUtils.isEmpty(abstractSchemaObject.getSchemaName())) {
            this.appendQuoteName(abstractSchemaObject.getSchemaName());
            this._add('.');
        }
        return this.appendQuoteName(abstractSchemaObject.getName());
    }

    public T specificName(Routine<?> routine, boolean withSchemaName) {
        if (withSchemaName && !CommonUtils.isEmpty(routine.getSchemaName())) {
            this.appendQuoteName(routine.getSchemaName());
            this._add('.');
        }
        return this.appendQuoteName(routine.getSpecificName());
    }

    public T name(Schema schema) {
        if (CommonUtils.isEmpty(schema)) {
            return this.instance();
        }
        return this.appendQuoteName(schema.getName());
    }

    public T name(Column column) {
        this.appendQuoteColumnName(column.getName());
        return this.instance();
    }

    public T name(String prefix, Column column) {
        this.appendQuoteColumnName(prefix, column.getName());
        return this.instance();
    }

    public T name(String prefix, ReferenceColumn column) {
        this.appendQuoteColumnName(prefix, column.getName());
        return this.instance();
    }

    public T name(DimensionLevel column) {
        this.appendQuoteColumnName(column.getName());
        return this.instance();
    }

    public T name(String name) {
        return this.appendQuoteName(name);
    }

    public T names(String ... names) {
        boolean add = false;
        for (String name : names) {
            if (name == null) continue;
            this._add((Object)".", add);
            this.appendQuoteName(name);
            add = true;
        }
        return this.instance();
    }

    public T columnName(String name) {
        return this.appendQuoteColumnName(name);
    }

    public T columnName(Column column, boolean withTableName) {
        return this.columnName(column, withTableName, false);
    }

    public T columnName(Column column, boolean withTableName, boolean withSchemaName) {
        Table table = column.getTable();
        if (withSchemaName && table != null && !CommonUtils.isEmpty(table.getSchemaName())) {
            this.appendQuoteName(table.getSchemaName());
            this._add(".");
        }
        if (withTableName) {
            if (table == null || CommonUtils.isEmpty(table.getName())) {
                return this.columnName(column.getName());
            }
            this.appendQuoteName(table.getName());
            this._add(".");
            this.appendQuoteName(column.getName());
        } else {
            this.appendQuoteName(column.getName());
        }
        return this.instance();
    }

    public T names(Column ... columns) {
        return this.names((Column c) -> true, columns);
    }

    public T names(Predicate<Column> p, Column ... columns) {
        boolean first = true;
        for (int i = 0; i < columns.length; ++i) {
            Column column = columns[i];
            if (!p.test(column)) continue;
            ((AbstractSqlBuilder)this.comma(!first)).appendQuoteColumnName(column.getName());
            first = false;
        }
        return this.instance();
    }

    public T names(ReferenceColumn ... columns) {
        return this.names((ReferenceColumn c) -> true, columns);
    }

    public T names(Predicate<ReferenceColumn> p, ReferenceColumn ... columns) {
        boolean first = true;
        for (int i = 0; i < columns.length; ++i) {
            ReferenceColumn column = columns[i];
            if (!p.test(column)) continue;
            ((AbstractSqlBuilder)this.comma(!first)).appendQuoteColumnName(column.getName());
            this.order(column.getOrder());
            first = false;
        }
        return this.instance();
    }

    public T names(ColumnCollection columns) {
        return this.names((Column c) -> true, columns);
    }

    public T names(Predicate<Column> p, ColumnCollection columns) {
        boolean first = true;
        for (int i = 0; i < columns.size(); ++i) {
            Column column = (Column)columns.get(i);
            if (!p.test(column)) continue;
            ((AbstractSqlBuilder)this.comma(!first)).appendQuoteColumnName(column.getName());
            first = false;
        }
        return this.instance();
    }

    public T names(ReferenceColumnCollection columns) {
        return this.names((ReferenceColumn c) -> true, columns);
    }

    public T names(Predicate<ReferenceColumn> p, ReferenceColumnCollection columns) {
        boolean first = true;
        for (int i = 0; i < columns.size(); ++i) {
            ReferenceColumn column = (ReferenceColumn)columns.get(i);
            ((AbstractSqlBuilder)this.comma(!first)).appendQuoteColumnName(column.getName());
            this.order(column.getOrder());
            first = false;
        }
        return this.instance();
    }

    protected T order(Order order) {
        if (order == Order.Desc) {
            ((AbstractSqlBuilder)this.space())._add(Order.Desc.toString().toUpperCase());
        }
        return this.instance();
    }

    protected T appendQuoteName(String name) {
        if (this.getDialect() != null && this.getDialect().needQuote(name)) {
            if (this.isQuateObjectName()) {
                this.appendElement(this.getDialect().quote(name));
            } else {
                this.appendElement(name);
            }
            return this.instance();
        }
        this.appendElement(name);
        return this.instance();
    }

    protected T appendQuoteColumnName(String name) {
        return this.appendQuoteColumnName("", name);
    }

    protected T appendQuoteColumnName(String prefix, String name) {
        String _pre;
        String string = _pre = prefix == null ? "" : prefix;
        if (this.getDialect() != null && this.getDialect().needQuote(name)) {
            if (this.isQuateColumnName()) {
                this.appendElement(_pre + this.getDialect().quote(name));
            } else {
                this.appendElement(_pre + name);
            }
            return this.instance();
        }
        this.appendElement(_pre + name);
        return this.instance();
    }

    public T comment(String comment) {
        ((AbstractSqlBuilder)((AbstractSqlBuilder)this.appendElement("/*")).appendElement(comment)).appendElement("*/");
        return this.instance();
    }

    public T dataType(Column column) {
        DbDataType<?> dbDataType = this.getDialect().getDbDataTypes().getDbType(column.getDataType(), column.getLength());
        dbDataType.getColumCreateDefinition(column.getLength(), column.getScale());
        return this.instance();
    }

    public T drop() {
        this.appendElement("DROP");
        return this.instance();
    }

    public T select() {
        this.appendElement("SELECT");
        return this.instance();
    }

    public T count() {
        this.appendElement("COUNT");
        return this.instance();
    }

    public T count(String value) {
        if (!CommonUtils.isEmpty(value)) {
            this.count();
            this._add("(");
            this._add(value);
            this._add(")");
        }
        return this.instance();
    }

    public T count(String value, boolean condition) {
        if (condition) {
            this.count(value);
        }
        return this.instance();
    }

    public T as() {
        this.appendElement("AS");
        return this.instance();
    }

    public T start() {
        this.appendElement("START");
        return this.instance();
    }

    public T transaction() {
        this.appendElement("TRANSACTION");
        return this.instance();
    }

    public T autocommit() {
        this.appendElement("AUTOCOMMIT");
        return this.instance();
    }

    public T with() {
        this.appendElement("WITH");
        return this.instance();
    }

    public T without() {
        this.appendElement("WITHOUT");
        return this.instance();
    }

    public T increment() {
        this.appendElement("INCREMENT");
        return this.instance();
    }

    public T by() {
        this.appendElement("BY");
        return this.instance();
    }

    public T target() {
        this.appendElement("TARGET");
        return this.instance();
    }

    public T source() {
        this.appendElement("SOURCE");
        return this.instance();
    }

    public T maxvalue() {
        this.appendElement("MAXVALUE");
        return this.instance();
    }

    public T minvalue() {
        this.appendElement("MINVALUE");
        return this.instance();
    }

    public T cycle() {
        this.appendElement("CYCLE");
        return this.instance();
    }

    public T cache() {
        this.appendElement("CACHE");
        return this.instance();
    }

    public T order() {
        this.appendElement("ORDER");
        return this.instance();
    }

    public T noOrder() {
        this.appendElement("NO ORDER");
        return this.instance();
    }

    public T values() {
        this.appendElement("VALUES");
        return this.instance();
    }

    public T value() {
        this.appendElement("VALUE");
        return this.instance();
    }

    public T _case() {
        this.appendElement("CASE");
        return this.instance();
    }

    public T _for() {
        this.appendElement("FOR");
        return this.instance();
    }

    public T _return() {
        this.appendElement("RETURN");
        return this.instance();
    }

    public T _public() {
        this.appendElement("PUBLIC");
        return this.instance();
    }

    public T _null() {
        this.appendElement("NULL");
        return this.instance();
    }

    public T _new() {
        this.appendElement("NEW");
        return this.instance();
    }

    public T _default() {
        this.appendElement("DEFAULT");
        return this.instance();
    }

    public T _do() {
        this.appendElement("DO");
        return this.instance();
    }

    public T _package() {
        this.appendElement("PACKAGE");
        return this.instance();
    }

    public T check() {
        this.appendElement("CHECK");
        return this.instance();
    }

    public T call() {
        this.appendElement("CALL");
        return this.instance();
    }

    public T schema() {
        this.appendElement("SCHEMA");
        return this.instance();
    }

    public T unique() {
        this.appendElement("UNIQUE");
        return this.instance();
    }

    public T replication() {
        this.appendElement("REPLICATION");
        return this.instance();
    }

    public T unique(boolean condition) {
        if (condition) {
            return this.unique();
        }
        return this.instance();
    }

    public T into() {
        this.appendElement("INTO");
        return this.instance();
    }

    public T from() {
        this.appendElement("FROM");
        return this.instance();
    }

    public T at() {
        this.appendElement("AT");
        return this.instance();
    }

    public T and() {
        this.appendElement("AND");
        return this.instance();
    }

    public T commit() {
        this.appendElement("COMMIT");
        return this.instance();
    }

    public T lock() {
        this.appendElement("LOCK");
        return this.instance();
    }

    public T and(boolean condition) {
        if (condition) {
            this.appendElement("AND");
        }
        return this.instance();
    }

    public T insert() {
        this.appendElement("INSERT");
        return this.instance();
    }

    public T update() {
        this.appendElement("UPDATE");
        return this.instance();
    }

    public T delete() {
        this.appendElement("DELETE");
        return this.instance();
    }

    public T merge() {
        this.appendElement("MERGE");
        return this.instance();
    }

    public T split() {
        this.appendElement("SPLIT");
        return this.instance();
    }

    public T replace() {
        this.appendElement("REPLACE");
        return this.instance();
    }

    public T table() {
        this.appendElement("TABLE");
        return this.instance();
    }

    public T view() {
        this.appendElement("VIEW");
        return this.instance();
    }

    public T materialized() {
        this.appendElement("MATERIALIZED");
        return this.instance();
    }

    public T log() {
        this.appendElement("LOG");
        return this.instance();
    }

    public T interval() {
        this.appendElement("INTERVAL");
        return this.instance();
    }

    public T specific() {
        this.appendElement("SPECIFIC");
        return this.instance();
    }

    public T synonym() {
        this.appendElement("SYNONYM");
        return this.instance();
    }

    public T index() {
        this.appendElement("INDEX");
        return this.instance();
    }

    public T trigger() {
        this.appendElement("TRIGGER");
        return this.instance();
    }

    public T fulltext() {
        this.appendElement("FULLTEXT");
        return this.instance();
    }

    public T spatial() {
        this.appendElement("SPATIAL");
        return this.instance();
    }

    public T fetch() {
        this.appendElement("FETCH");
        return this.instance();
    }

    public T first() {
        this.appendElement("FIRST");
        return this.instance();
    }

    public T truncate() {
        this.appendElement("TRUNCATE");
        return this.instance();
    }

    public T analyze() {
        this.appendElement("ANALYZE");
        return this.instance();
    }

    public T cascade() {
        this.appendElement("CASCADE");
        return this.instance();
    }

    public T key() {
        this.appendElement("KEY");
        return this.instance();
    }

    public T add() {
        this.appendElement("ADD");
        return this.instance();
    }

    public T modify() {
        this.appendElement("MODIFY");
        return this.instance();
    }

    public T convert() {
        this.appendElement("CONVERT");
        return this.instance();
    }

    public T on() {
        this.appendElement("ON");
        return this.instance();
    }

    public T only() {
        this.appendElement("ONLY");
        return this.instance();
    }

    public T or() {
        this.appendElement("OR");
        return this.instance();
    }

    public T off() {
        this.appendElement("OFF");
        return this.instance();
    }

    public T match() {
        this.appendElement("MATCH");
        return this.instance();
    }

    public T primaryKey() {
        this.appendElement("PRIMARY KEY");
        return this.instance();
    }

    public T foreignKey() {
        this.appendElement("FOREIGN KEY");
        return this.instance();
    }

    public T references() {
        this.appendElement("REFERENCES");
        return this.instance();
    }

    public T where() {
        this.appendElement("WHERE");
        return this.instance();
    }

    public T is() {
        this.appendElement("IS");
        return this.instance();
    }

    public T orderBy() {
        this.appendElement("ORDER BY");
        return this.instance();
    }

    public T groupBy() {
        this.appendElement("GROUP BY");
        return this.instance();
    }

    public T enable() {
        return this.enable(true);
    }

    public T enable(boolean condition) {
        if (condition) {
            this.appendElement("ENABLE");
        }
        return this.instance();
    }

    public T disable() {
        return this.disable(true);
    }

    public T disable(boolean condition) {
        if (condition) {
            this.appendElement("DISABLE");
        }
        return this.instance();
    }

    public T constraints() {
        this.appendElement("CONSTRAINTS");
        return this.instance();
    }

    public T column() {
        this.appendElement("COLUMN");
        return this.instance();
    }

    public T constraint() {
        this.appendElement("CONSTRAINT");
        return this.instance();
    }

    public T ifExists() {
        return this.ifExists(true);
    }

    public T ifExists(boolean bool) {
        if (bool) {
            this.appendElement("IF EXISTS");
        }
        return this.instance();
    }

    public T change() {
        this.appendElement("CHANGE");
        return this.instance();
    }

    public T optimize() {
        this.appendElement("OPTIMIZE");
        return this.instance();
    }

    public T partition() {
        return this.partition(true);
    }

    public T partition(boolean bool) {
        if (bool) {
            this.appendElement("PARTITION");
        }
        return this.instance();
    }

    public T offset() {
        this.appendElement("OFFSET");
        return this.instance();
    }

    public T partitionBy() {
        this.appendElement("PARTITION BY");
        return this.instance();
    }

    public T subpartitionBy() {
        this.appendElement("SUBPARTITION BY");
        return this.instance();
    }

    public T security() {
        this.appendElement("SECURITY");
        return this.instance();
    }

    public T invoker() {
        this.appendElement("INVOKER");
        return this.instance();
    }

    public T definer() {
        this.appendElement("DEFINER");
        return this.instance();
    }

    public T partitions() {
        this.appendElement("PARTITIONS");
        return this.instance();
    }

    public T partitioning() {
        this.appendElement("PARTITIONING");
        return this.instance();
    }

    public T subpartition() {
        return this.subpartition(true);
    }

    public T subpartition(boolean bool) {
        if (bool) {
            this.appendElement("SUBPARTITION");
        }
        return this.instance();
    }

    public T subpartitions() {
        this.appendElement("SUBPARTITIONS");
        return this.instance();
    }

    public T refresh() {
        this.appendElement("REFRESH");
        return this.instance();
    }

    public T remove() {
        this.appendElement("REMOVE");
        return this.instance();
    }

    public T ifNotExists() {
        this.appendElement("IF NOT EXISTS");
        return this.instance();
    }

    public T ifNotExists(boolean condition) {
        if (!condition) {
            return this.instance();
        }
        this.appendElement("IF NOT EXISTS");
        return this.instance();
    }

    public T concurrently(boolean condition) {
        if (!condition) {
            return this.instance();
        }
        this.appendElement("CONCURRENTLY");
        return this.instance();
    }

    public T not() {
        this.appendElement("NOT");
        return this.instance();
    }

    public T no() {
        this.appendElement("NO");
        return this.instance();
    }

    public T next() {
        this.appendElement("NEXT");
        return this.instance();
    }

    public T sql() {
        this.appendElement("SQL");
        return this.instance();
    }

    public T language() {
        this.appendElement("LANGUAGE");
        return this.instance();
    }

    public T left() {
        this.appendElement("LEFT");
        return this.instance();
    }

    public T right() {
        this.appendElement("RIGHT");
        return this.instance();
    }

    public T external() {
        this.appendElement("EXTERNAL");
        return this.instance();
    }

    public T name() {
        this.appendElement("NAME");
        return this.instance();
    }

    public T notNull() {
        return this.notNull(true);
    }

    public T notNull(boolean bool) {
        if (bool) {
            this.appendElement("NOT NULL");
        }
        return this.instance();
    }

    public T end(boolean bool) {
        if (bool) {
            this.appendElement("END");
        }
        return this.instance();
    }

    public T begin(boolean bool) {
        if (bool) {
            this.appendElement("BEGIN");
        }
        return this.instance();
    }

    public T begin() {
        return this.begin(true);
    }

    public T end() {
        return this.end(true);
    }

    public T eq() {
        this.appendElement("=");
        return this.instance();
    }

    public T compressed() {
        this.appendElement("COMPRESSED");
        return this.instance();
    }

    public T compress() {
        this.appendElement("COMPRESS");
        return this.instance();
    }

    public T compression() {
        this.appendElement("COMPRESSION");
        return this.instance();
    }

    public T yes() {
        this.appendElement("YES");
        return this.instance();
    }

    public T gt() {
        this.appendElement(">");
        return this.instance();
    }

    public T gte() {
        this.appendElement(">=");
        return this.instance();
    }

    public T lt() {
        this.appendElement("<");
        return this.instance();
    }

    public T lte() {
        this.appendElement("<=");
        return this.instance();
    }

    public T inherits() {
        this.appendElement("INHERITS");
        return this.instance();
    }

    public T exists() {
        this.appendElement("EXISTS");
        return this.instance();
    }

    public T set() {
        this.appendElement("SET");
        return this.instance();
    }

    public T set(boolean condition) {
        if (condition) {
            this.set();
        }
        return this.instance();
    }

    public T setNull() {
        this.appendElement("SET NULL");
        return this.instance();
    }

    public T setNotNull() {
        this.appendElement("SET NOT NULL");
        return this.instance();
    }

    public T setDefault() {
        this.appendElement("SET DEFAULT");
        return this.instance();
    }

    public T property(String name, String value) {
        if (value != null) {
            ((AbstractSqlBuilder)((AbstractSqlBuilder)this.appendElement(name)).eq())._add(value);
        }
        return this.instance();
    }

    public T property(String name, Object value) {
        return this.property(name, Converters.getDefault().convertString(value));
    }

    public T property(String name, String value, boolean condition) {
        if (condition) {
            return this.property(name, Converters.getDefault().convertString(value));
        }
        return this.instance();
    }

    public T property(String name, Object value, boolean condition) {
        if (condition) {
            return this.property(name, Converters.getDefault().convertString(value));
        }
        return this.instance();
    }

    public T dimension() {
        this.appendElement("DIMENSION");
        return this.instance();
    }

    public T domain() {
        this.appendElement("DOMAIN");
        return this.instance();
    }

    public T event() {
        this.appendElement("EVENT");
        return this.instance();
    }

    public T function() {
        this.appendElement("FUNCTION");
        return this.instance();
    }

    public T procedure() {
        this.appendElement("PROCEDURE");
        return this.instance();
    }

    public T role() {
        this.appendElement("ROLE");
        return this.instance();
    }

    public T sequence() {
        this.appendElement("SEQUENCE");
        return this.instance();
    }

    public T type() {
        this.appendElement("TYPE");
        return this.instance();
    }

    public T body() {
        this.appendElement("BODY");
        return this.instance();
    }

    public T inclusive() {
        return this.inclusive(true);
    }

    public T inclusive(boolean bool) {
        if (bool) {
            this.appendElement("INCLUSIVE");
        }
        return this.instance();
    }

    public T exclusive() {
        return this.exclusive(true);
    }

    public T exclusive(boolean bool) {
        if (bool) {
            this.appendElement("ExCLUSIVE");
        }
        return this.instance();
    }

    public T when() {
        this.appendElement("WHEN");
        return this.instance();
    }

    public T matched() {
        this.appendElement("MATCHED");
        return this.instance();
    }

    public T then() {
        this.appendElement("THEN");
        return this.instance();
    }

    public T user() {
        this.appendElement("USER");
        return this.instance();
    }

    public T generated() {
        this.appendElement("GENERATED");
        return this.instance();
    }

    public T clustered() {
        this.appendElement("CLUSTERED");
        return this.instance();
    }

    public T always() {
        this.appendElement("ALWAYS");
        return this.instance();
    }

    public T identity() {
        this.appendElement("IDENTITY");
        return this.instance();
    }

    public T id() {
        this.appendElement("ID");
        return this.instance();
    }

    public T collate() {
        this.appendElement("COLLATE");
        return this.instance();
    }

    public T coalesce() {
        this.appendElement("COALESCE");
        return this.instance();
    }

    public T coalesce(Runnable run) {
        this.coalesce();
        this.brackets(run);
        return this.instance();
    }

    public T characterSet() {
        this.appendElement("CHARACTER SET");
        return this.instance();
    }

    public T collation() {
        this.appendElement("COLLATION");
        return this.instance();
    }

    public T forEach() {
        this.appendElement("FOR EACH");
        return this.instance();
    }

    public T row() {
        this.appendElement("ROW");
        return this.instance();
    }

    public T using() {
        this.appendElement("USING");
        return this.instance();
    }

    public T rows() {
        this.appendElement("ROWS");
        return this.instance();
    }

    public T _fromSysDummy() {
        return this.instance();
    }

    public T _true() {
        this.appendElement("1=1");
        return this.instance();
    }

    public T lineBreak(char value) {
        this._add(value);
        return this.lineBreak();
    }

    public T lineBreak(String value) {
        this._add(value);
        return this.lineBreak();
    }

    public T comma() {
        this._add(COMMA);
        if (this.isAppendAutoSpace()) {
            this.space();
        }
        return this.instance();
    }

    public T comma(boolean condition) {
        if (condition) {
            this.comma();
        }
        return this.instance();
    }

    public T semicolon() {
        this._add(';');
        return this.instance();
    }

    public T semicolon(boolean condition) {
        if (condition) {
            this.comma();
        }
        return this.instance();
    }

    public boolean isFirstElement() {
        return this.firstElement;
    }

    public T setFirstElement(boolean firstElement) {
        this.firstElement = firstElement;
        return this.instance();
    }

    public T setCondition(String name, boolean condition) {
        this.conditionMap.put(name, condition);
        return this.instance();
    }

    public boolean getCondition(String name) {
        Boolean bool = this.conditionMap.get(name);
        if (bool == null) {
            return false;
        }
        return bool;
    }

    public T lessThan() {
        this.appendElement("LESS THAN");
        return this.instance();
    }

    public T in() {
        this.appendElement("IN");
        return this.instance();
    }

    public T union() {
        this.appendElement("UNION");
        return this.instance();
    }

    public T all() {
        this.appendElement("ALL");
        return this.instance();
    }

    public T all(boolean condition) {
        if (condition) {
            return this.all();
        }
        return this.instance();
    }

    public T returns() {
        this.appendElement("RETURNS");
        return this.instance();
    }

    public T deterministic() {
        this.appendElement("DETERMINISTIC");
        return this.instance();
    }

    public T dynamic() {
        this.appendElement("DYNAMIC");
        return this.instance();
    }

    public T result() {
        this.appendElement("RESULT");
        return this.instance();
    }

    public T join() {
        this.appendElement("JOIN");
        return this.instance();
    }

    public T sets() {
        this.appendElement("SETS");
        return this.instance();
    }

    public T tablespace() {
        this.appendElement("TABLESPACE");
        return this.instance();
    }

    public T comment() {
        this.appendElement("COMMENT");
        return this.instance();
    }

    public T engine() {
        this.appendElement("ENGINE");
        return this.instance();
    }

    public T execute() {
        this.appendElement("EXECUTE");
        return this.instance();
    }

    public T space() {
        this._add(' ');
        return this.instance();
    }

    public T asc() {
        this._add("ASC");
        return this.instance();
    }

    public T desc() {
        this._add("DESC");
        return this.instance();
    }

    public T space(boolean bool) {
        if (bool) {
            this.space();
        }
        return this.instance();
    }

    public T space(int len) {
        for (int i = 0; i < len; ++i) {
            this.space();
        }
        return this.instance();
    }

    public T space(int len, boolean bool) {
        if (bool) {
            this.space(len);
        }
        return this.instance();
    }

    public T like() {
        this.appendElement("LIKE");
        return this.instance();
    }

    public T lineBreak() {
        return this.lineBreak(true);
    }

    public T lineBreak(boolean bool) {
        if (!bool) {
            return this.instance();
        }
        this._add('\n');
        return this.indent();
    }

    protected T indent() {
        for (int i = 0; i < this.getIndentSize(); ++i) {
            this._add(this.indentString);
        }
        return this.instance();
    }

    public T _add(char value) {
        this.builder.append(value);
        return this.instance();
    }

    public T _add(Object value, boolean condition) {
        if (condition) {
            this._add(Converters.getDefault().convertString(value));
        }
        return this.instance();
    }

    public T _add(IndexType value, boolean condition) {
        if (condition && IndexType.BTree != value) {
            this._add(value.toString());
        }
        return this.instance();
    }

    public T sqlChar(String value) {
        if (value != null) {
            ((AbstractSqlBuilder)((AbstractSqlBuilder)this._add("'"))._add(CommonUtils.unwrap(value, "'").replace("'", "''")))._add("'");
        }
        return this.instance();
    }

    public T sqlChar(String ... values) {
        if (CommonUtils.isEmpty(values)) {
            return this.instance();
        }
        for (int i = 0; i < values.length; ++i) {
            ((AbstractSqlBuilder)this.comma(i > 0)).sqlChar(values[i]);
        }
        return this.instance();
    }

    public T sqlChar(Collection<String> values) {
        if (CommonUtils.isEmpty(values)) {
            return this.instance();
        }
        int i = 0;
        for (String value : values) {
            ((AbstractSqlBuilder)this.comma(i > 0)).sqlChar(value);
            ++i;
        }
        return this.instance();
    }

    public T lockMode(TableLockMode tableLockMode) {
        if (tableLockMode != null) {
            this.appendElement(tableLockMode.toString());
        }
        return this.instance();
    }

    public T mode() {
        this.appendElement("MODE");
        return this.instance();
    }

    public T sqlChar(String value, boolean condition) {
        if (condition) {
            this.sqlChar(value);
        }
        return this.instance();
    }

    public T sqlNchar(String value) {
        if (value != null) {
            ((AbstractSqlBuilder)((AbstractSqlBuilder)this._add("N'"))._add(CommonUtils.unwrap(value, "'")))._add("'");
        }
        return this.instance();
    }

    public T sqlNchar(String ... values) {
        if (CommonUtils.isEmpty(values)) {
            return this.instance();
        }
        for (int i = 0; i < values.length; ++i) {
            ((AbstractSqlBuilder)this.comma(i > 0)).sqlNchar(values[i]);
        }
        return this.instance();
    }

    public T sqlNchar(String value, boolean condition) {
        if (condition) {
            this.sqlNchar(value);
        }
        return this.instance();
    }

    public T sqlNchar(Collection<String> values) {
        if (CommonUtils.isEmpty(values)) {
            return this.instance();
        }
        int i = 0;
        for (String value : values) {
            ((AbstractSqlBuilder)this.comma(i > 0)).sqlNchar(value);
            ++i;
        }
        return this.instance();
    }

    public T _add(Object value) {
        if (value != null) {
            this.builder.append(value.toString());
        }
        return this.instance();
    }

    public T plus(char value) {
        return this._add(value);
    }

    public T plus(Object value) {
        return this._add(value);
    }

    public T _add(Collection<String> values) {
        return this._add("\n", values);
    }

    public T _add(String separator, Collection<String> values) {
        if (values != null) {
            boolean needsIndent = "\n".equals(separator);
            boolean first = true;
            for (String obj : values) {
                if (!first) {
                    this._add(separator);
                    if (needsIndent) {
                        this.indent();
                    }
                } else {
                    first = false;
                }
                this._add((Object)obj);
            }
        }
        return this.instance();
    }

    public T _add(String value) {
        if (value != null) {
            this.builder.append(value);
        }
        return this.instance();
    }

    public T brackets(Runnable run) {
        return this.brackets("(", run, ")");
    }

    public T brackets(boolean indent, Runnable run) {
        return this.brackets(indent, "(", run, ")");
    }

    public T brackets(String start, Runnable run, String end) {
        return this.brackets(false, start, run, end);
    }

    public T brackets(boolean indent, String start, Runnable run, String end) {
        if (indent) {
            this._add(start);
            this.indent(() -> {
                this.lineBreak();
                run.run();
                if (!this.endsWithSpace()) {
                    this.space();
                }
            });
            this.lineBreak();
            this._add(end);
            return this.instance();
        }
        this._add(start);
        run.run();
        if (!this.endsWithSpace()) {
            this.space();
        }
        this._add(end);
        return this.instance();
    }

    private boolean endsWithSpace() {
        if (this.builder.length() == 0) {
            return false;
        }
        char c = this.builder.charAt(this.builder.length() - 1);
        return c == ' ' || c == '\n' || c == '\t';
    }

    public T _add(String open, Runnable r, String close) {
        this._add(open);
        r.run();
        this._add(close);
        return this.instance();
    }

    public T _add(char open, Runnable r, char close) {
        this._add(open);
        r.run();
        this._add(close);
        return this.instance();
    }

    public T _add(EnumProperties value) {
        if (value != null) {
            this.builder.append(value.getSqlValue());
        }
        return this.instance();
    }

    public T addTypeDefinition(Column column) {
        this.typeDefinition(column);
        return this.instance();
    }

    public T definition(Column column) {
        return this.definition(column, true);
    }

    public T definition(Column column, boolean withRemarks) {
        if (column.getDataType() == DataType.DOMAIN) {
            this._add(column.getDataTypeName());
        } else {
            this.typeDefinition(column);
            this.characterSetDefinition(column);
            this.collateDefinition(column);
        }
        if (!column.isIdentity() && !CommonUtils.isEmpty(column.getDefaultValue())) {
            this.defaultDefinition(column);
        }
        this.notNullDefinition(column);
        if (column.isIdentity()) {
            this.autoIncrement(column);
        }
        if (!CommonUtils.isEmpty(column.getOnUpdate())) {
            this.onUpdateDefinition(column);
        }
        if (!CommonUtils.isEmpty(column.getCheck())) {
            this.checkConstraintDefinition(column);
        }
        if (withRemarks && !CommonUtils.isEmpty(column.getRemarks())) {
            this.comment(column);
        }
        return this.instance();
    }

    protected void onUpdateDefinition(Column column) {
    }

    protected T defaultDefinition(Column column) {
        if (column.getDefaultValue() == null) {
            return this.instance();
        }
        this._default();
        this.space();
        this._add(column.getDefaultValue());
        return this.instance();
    }

    public T definitionForAlterColumn(Column column) {
        if (column.getDataType() == DataType.DOMAIN) {
            this._add(column.getDataTypeName());
        } else {
            this.typeDefinition(column);
            this.characterSetDefinition(column);
            this.collateDefinition(column);
        }
        if (!column.isIdentity() && !CommonUtils.isEmpty(column.getDefaultValue())) {
            this.defaultDefinitionForAlter(column);
        }
        this.notNullDefinitionForAlter(column);
        if (column.isIdentity()) {
            this.autoIncrement(column);
        }
        if (column.getCheck() != null) {
            this.checkConstraintDefinition(column);
        }
        if (!CommonUtils.isEmpty(column.getRemarks())) {
            this.comment(column);
        }
        return this.instance();
    }

    protected T defaultDefinitionForAlter(Column column) {
        return this.defaultDefinition(column);
    }

    protected T notNullDefinitionForAlter(Column column) {
        return this.notNullDefinition(column);
    }

    protected T notNullDefinition(Column column) {
        if (!column.isIdentity() && column.isNotNull()) {
            ((AbstractSqlBuilder)this.space()).notNull();
        }
        return this.instance();
    }

    protected T typeDefinition(Column column) {
        DbDataType<?> dbDataType = null;
        dbDataType = column.getLength() != null ? this.getDialect().getDbDataTypes().getDbType(column.getDataType(), column.getLength()) : this.getDialect().getDbDataTypes().getDbType(column.getDataType());
        if (column.getDataType() == DataType.ENUM || column.getDataType() == DataType.SET) {
            ((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)this._add((Object)column.getDataType()))._add("(")).sqlChar(column.getValues()))._add(")");
        } else if (column.getDataType() != DataType.OTHER) {
            Long len = null;
            if (dbDataType instanceof LengthProperties) {
                len = ((LengthProperties)((Object)dbDataType)).getLength(column.getLength());
            } else if (dbDataType instanceof PrecisionProperties) {
                len = ((PrecisionProperties)((Object)dbDataType)).getPrecision(column.getLength()).longValue();
            }
            Integer scale = column.getScale();
            if (dbDataType instanceof ScaleProperties) {
                scale = ((ScaleProperties)((Object)dbDataType)).getScale(scale);
            }
            if (dbDataType != null) {
                String def = dbDataType.getColumCreateDefinition(len, scale);
                if (dbDataType.getSupportCharacterSemantics().size() > 1 && column.getCharacterSemantics() != null) {
                    def = def.replace(")", " " + column.getCharacterSemantics() + ")");
                }
                this._add(def);
            } else {
                this._add(column.getDataTypeName());
            }
        } else {
            this._add(column.getDataTypeName());
        }
        return this.instance();
    }

    public T typeDefinition(DataType type, String dataTypeName, Number maxlength, Integer scale) {
        Column column = new Column();
        column.setDataType(type);
        column.setDataTypeName(dataTypeName);
        column.setLength(maxlength);
        column.setScale(scale);
        this.typeDefinition(column);
        return this.instance();
    }

    protected T typeDefinition(AbstractColumn<?> column) {
        return this.typeDefinition(column.getDataType(), column.getDataTypeName(), CommonUtils.notZero(column.getLength(), column.getOctetLength()), column.getScale());
    }

    protected T typeDefinition(DataTypeSetProperties<?> column) {
        return this.typeDefinition(column.getDataType(), column.getDataTypeName(), CommonUtils.notZero(column.getLength(), column.getOctetLength()), column.getScale());
    }

    public T typeDefinition(DataTypeProperties<?> column) {
        return this.typeDefinition(column.getDataType(), column.getDataTypeName(), null, null);
    }

    protected T typeDefinition(FunctionReturning column) {
        return this.typeDefinition(column.getDataType(), column.getDataTypeName(), CommonUtils.notZero(column.getLength(), column.getOctetLength()), column.getScale());
    }

    protected T characterSetDefinition(Column column) {
        return this.instance();
    }

    protected T collateDefinition(Column column) {
        return this.instance();
    }

    protected T checkConstraintDefinition(Column column) {
        ((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)this.check()).space())._add("("))._add(column.getCheck()))._add(")");
        return this.instance();
    }

    protected T autoIncrement(AbstractColumn<?> column) {
        ((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)this.generated()).always()).as()).identity();
        return this.instance();
    }

    protected T comment(AbstractColumn<?> column) {
        return this.instance();
    }

    protected T appendElement(String value) {
        if (CommonUtils.isEmpty(value)) {
            return this.instance();
        }
        if (this.builder.length() != 0) {
            char c = this.builder.charAt(this.builder.length() - 1);
            if (c == ' ' || c == '\t' || c == '\n' || c == '/' || c == '.') {
                this._add(value);
                return this.instance();
            }
            if (this.isAppendAutoSpace()) {
                this.space(this.builder.length() > 0);
            }
        }
        this._add(value);
        return this.instance();
    }

    protected int getIndentSize() {
        return this.indentSize;
    }

    public T appendIndent(int indentSize) {
        this.indentSize += indentSize;
        return this.instance();
    }

    public T indent(Runnable run) {
        this.appendIndent(1);
        try {
            run.run();
        }
        finally {
            this.appendIndent(-1);
        }
        return this.instance();
    }

    public String getIndentString() {
        return this.indentString;
    }

    public T setIndentString(String indentString) {
        this.indentString = indentString;
        return this.instance();
    }

    public String toString() {
        return this.builder.toString();
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public T arguments(NamedArgumentCollection<?> arguments) {
        return this.arguments("(", arguments, ")", ", ");
    }

    public T arguments(String start, NamedArgumentCollection<?> arguments, String end, String separator) {
        this._add(start);
        boolean first = true;
        for (NamedArgument argument : arguments) {
            if (!first) {
                this._add(separator);
            } else {
                first = false;
            }
            this.argument(argument);
        }
        this._add(end);
        return this.instance();
    }

    public T argument(NamedArgument obj) {
        this.argumentBefore(obj);
        if (obj.getName() != null) {
            this._add(obj.getName());
            this.space();
        }
        this.typeDefinition(obj);
        if (obj.getDirection() != null && obj.getDirection() != ParameterDirection.Input) {
            ((AbstractSqlBuilder)this.space())._add((Object)obj.getDirection());
        }
        this.argumentAfter(obj);
        return this.instance();
    }

    protected void argumentBefore(NamedArgument obj) {
        this.argumentDirection(obj);
    }

    protected void argumentAfter(NamedArgument obj) {
    }

    protected void argumentDirection(NamedArgument obj) {
        if (obj.getDirection() != null && obj.getDirection() != ParameterDirection.Input) {
            this._add((Object)obj.getDirection());
            this.space();
        }
    }

    public T _add(FunctionReturning argument) {
        this.typeDefinition(argument);
        return this.instance();
    }

    public T matchOption(ForeignKeyConstraint constraint) {
        if (constraint.getMatchOption() != null) {
            ((AbstractSqlBuilder)((AbstractSqlBuilder)this.match()).space())._add(constraint.getMatchOption());
        }
        return this.instance();
    }

    public T cascadeRule(ForeignKeyConstraint constraint) {
        if (constraint.getDeleteRule() != null) {
            ((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)this.space()).on()).space()).delete()).space())._add(constraint.getDeleteRule());
        }
        if (constraint.getUpdateRule() != null) {
            ((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)this.space()).on()).space()).update()).space())._add(constraint.getUpdateRule());
        }
        return this.instance();
    }

    public T $if(boolean condition, Runnable r) {
        if (condition) {
            r.run();
        }
        return this.instance();
    }

    public T $if(boolean condition, Runnable c1, Runnable c2) {
        if (condition) {
            c1.run();
        } else {
            c2.run();
        }
        return this.instance();
    }

    public T _parameterIn(String columnName, String parameterName) {
        return this._parameterForIn(columnName, () -> this.in(), parameterName, "1");
    }

    private T _parameter(String columnName, Runnable run, String parameterName, String value) {
        ((AbstractSqlBuilder)this.appendElement(columnName)).space();
        run.run();
        this.space();
        this._add("/*" + parameterName + "*/" + value);
        return this.instance();
    }

    private T _parameterForIn(String columnName, Runnable run, String parameterName, String value) {
        ((AbstractSqlBuilder)this.appendElement(columnName)).space();
        run.run();
        this.space();
        this._add("/*" + parameterName + "*/(" + value + ")");
        return this.instance();
    }

    public T _parameterEq(String columnName, String parameterName) {
        return this._parameter(columnName, () -> this.eq(), parameterName, "'1'");
    }

    public T _parameterGt(String columnName, String parameterName) {
        return this._parameter(columnName, () -> this.gt(), parameterName, "'1'");
    }

    public T _parameterGte(String columnName, String parameterName) {
        return this._parameter(columnName, () -> this.gte(), parameterName, "'1'");
    }

    public T _parameterLt(String columnName, String parameterName) {
        return this._parameter(columnName, () -> this.lt(), parameterName, "'1'");
    }

    public T _parameterLte(String columnName, String parameterName) {
        return this._parameter(columnName, () -> this.lte(), parameterName, "'1'");
    }

    public T _parameterLike(String columnName, String parameterName) {
        return this._parameter(columnName, () -> this.like(), parameterName, "'1'");
    }

    public AbstractSqlBuilder<T> clone() {
        try {
            AbstractSqlBuilder clone = (AbstractSqlBuilder)super.clone();
            clone.builder = new StringBuilder(this.builder.length());
            clone.builder.append(this.builder.toString());
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public T _merge(AbstractSqlBuilder<?> builder) {
        this.builder.append(builder.builder.toString());
        return this.instance();
    }

    public T addComment(String value) {
        if (CommonUtils.isEmpty(value)) {
            return this.instance();
        }
        this._add("/*");
        this._add(value);
        this._add("*/");
        return this.instance();
    }

    public T addLineComment(String value) {
        if (CommonUtils.isEmpty(value)) {
            return this.instance();
        }
        this._add("-- ");
        return this.instance();
    }

    public T _clear() {
        this.builder = new StringBuilder();
        return this.instance();
    }
}

