/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import com.sqlapp.util.CaseInsensitiveMap;
import com.sqlapp.util.CommonUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class CaseInsensitiveGetMap<T>
implements Map<String, T>,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1946073595454206975L;
    protected CaseInsensitiveMap<T> caseInsensitiveMap = new CaseInsensitiveMap();
    protected Map<String, T> map = new LinkedHashMap<String, T>();

    public CaseInsensitiveGetMap() {
        this.caseInsensitiveMap = new CaseInsensitiveMap();
        this.map = new LinkedHashMap<String, T>();
    }

    public CaseInsensitiveGetMap(int size) {
        this.caseInsensitiveMap = new CaseInsensitiveMap(size);
        this.map = new LinkedHashMap<String, T>(size);
    }

    @Override
    public T put(String key, T value) {
        T obj = null;
        if (!this.map.containsKey(key)) {
            obj = this.map.put(key, value);
            if (!this.caseInsensitiveMap.containsKey(key)) {
                this.caseInsensitiveMap.put(key, value);
            }
            return obj;
        }
        return obj;
    }

    @Override
    public void clear() {
        this.map.clear();
        this.caseInsensitiveMap.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.map.containsKey(key)) {
            return true;
        }
        return this.caseInsensitiveMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.map.containsValue(value)) {
            return true;
        }
        return this.caseInsensitiveMap.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, T>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public T get(Object key) {
        return this.get(key.toString());
    }

    public T get(String key) {
        if (this.map.containsKey(key)) {
            return this.map.get(key);
        }
        return this.caseInsensitiveMap.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public T remove(Object key) {
        T obj = null;
        if (this.map.containsKey(key)) {
            obj = this.map.remove(key);
            this.caseInsensitiveMap.remove(key);
        }
        return obj;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<T> values() {
        return this.map.values();
    }

    @Override
    public void putAll(Map<? extends String, ? extends T> m) {
        for (Map.Entry<String, T> entry : m.entrySet()) {
            String key = entry.getKey();
            T value = entry.getValue();
            this.put(key, value);
        }
    }

    public CaseInsensitiveGetMap<T> clone() {
        CaseInsensitiveGetMap<T> clone = new CaseInsensitiveGetMap<T>();
        clone.caseInsensitiveMap = this.caseInsensitiveMap.clone();
        clone.map.putAll(this.map);
        return clone;
    }

    public String toString() {
        return this.map.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CaseInsensitiveGetMap)) {
            return false;
        }
        CaseInsensitiveGetMap cst = (CaseInsensitiveGetMap)obj;
        return CommonUtils.eq(this.map, cst.map);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }
}

