/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import com.sqlapp.util.AbstractStringSet;
import com.sqlapp.util.CommonUtils;
import java.util.Map;
import java.util.Set;

public class CaseInsensitiveSet
extends AbstractStringSet {
    private static final long serialVersionUID = 1946073595454206975L;
    private Map<String, String> keyMap = CommonUtils.upperLinkedMap();

    public CaseInsensitiveSet() {
    }

    public CaseInsensitiveSet(int capacity) {
        super(capacity);
    }

    public CaseInsensitiveSet(int capacity, float loadFactor) {
        super(capacity, loadFactor);
    }

    public CaseInsensitiveSet(Set<String> baseSet) {
        super(baseSet);
    }

    @Override
    public boolean add(String e) {
        this.keyMap.putIfAbsent(e, e);
        return super.add(e);
    }

    @Override
    protected String convertKey(String key) {
        return this.keyMap.get(key);
    }

    @Override
    public boolean remove(String o) {
        boolean bool = super.remove(this.convertKey(o));
        this.keyMap.remove(o);
        return bool;
    }

    @Override
    public boolean remove(Object o) {
        boolean bool = super.remove(this.convertKey((String)o));
        this.keyMap.remove(o);
        return bool;
    }

    @Override
    public AbstractStringSet newInstance() {
        return new CaseInsensitiveSet();
    }

    @Override
    public void clear() {
        super.clear();
        this.keyMap.clear();
    }
}

