/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import java.io.IOException;
import java.io.Writer;

public class CompositeWriter
extends Writer {
    private Writer[] writers;

    protected CompositeWriter() {
    }

    public CompositeWriter(Writer ... writers) {
        this.writers = writers;
    }

    protected void setWriters(Writer[] writers) {
        this.writers = writers;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        int size = this.writers.length;
        IOException ioe = null;
        for (int i = 0; i < size; ++i) {
            try {
                this.writers[i].write(cbuf, off, len);
                continue;
            }
            catch (IOException e) {
                if (ioe != null) continue;
                ioe = e;
            }
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    @Override
    public void flush() throws IOException {
        int size = this.writers.length;
        IOException ioe = null;
        for (int i = 0; i < size; ++i) {
            try {
                this.writers[i].flush();
                continue;
            }
            catch (IOException e) {
                if (ioe != null) continue;
                ioe = e;
            }
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    @Override
    public void close() throws IOException {
        int size = this.writers.length;
        IOException ioe = null;
        for (int i = 0; i < size; ++i) {
            try {
                this.writers[i].close();
                continue;
            }
            catch (IOException e) {
                if (ioe != null) continue;
                ioe = e;
            }
        }
        if (ioe != null) {
            throw ioe;
        }
    }
}

