/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import com.sqlapp.data.converter.EnumConvertable;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.DoubleKeyMap;
import com.sqlapp.util.FileUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class EnumUtils {
    private static final DoubleKeyMap<Class<?>, Locale, Properties> PROPERTIES_CHACHE = new DoubleKeyMap();
    private static final ConcurrentMap<Class<?>, Map<Object, Enum<?>>> ENUM_CACHE = new ConcurrentHashMap();

    private EnumUtils() {
    }

    public static <T extends Enum<T>> String getDisplayName(T enm, Locale locale) {
        Properties properties = EnumUtils.getProperty(enm.getClass(), locale);
        return properties.getProperty(enm.toString() + ".displayName");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getProperty(Class<?> clazz, Locale locale) {
        Properties properties = PROPERTIES_CHACHE.get(clazz, locale);
        if (properties != null) {
            return properties;
        }
        InputStream in = null;
        if (locale != null && (in = clazz.getResourceAsStream(EnumUtils.getPropertyPath(clazz, locale.toString()))) == null) {
            in = clazz.getResourceAsStream(EnumUtils.getPropertyPath(clazz, locale.getLanguage()));
        }
        if (in == null) {
            in = clazz.getResourceAsStream(EnumUtils.getPropertyPath(clazz));
        }
        if (in == null) {
            throw new RuntimeException(new FileNotFoundException(EnumUtils.getPropertyPath(clazz)));
        }
        try {
            properties = new Properties();
            properties.load(in);
            PROPERTIES_CHACHE.put(clazz, locale, properties);
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException e) {
            Properties properties3 = null;
            return properties3;
        }
        finally {
            FileUtils.close(in);
        }
    }

    private static String getPropertyPath(Class<?> clazz, String lang) {
        String result = "/" + clazz.getName().replace(".", "/") + "_" + lang + ".properties";
        return result;
    }

    private static String getPropertyPath(Class<?> clazz) {
        String result = "/" + clazz.getName().replace(".", "/") + ".properties";
        return result;
    }

    public static <T extends Enum<?>> Set<T> getValues(Class<T> clazz) {
        Enum[] vals = (Enum[])clazz.getEnumConstants();
        LinkedHashSet<Enum> result = new LinkedHashSet<Enum>(vals.length);
        for (Enum t : (Enum[])clazz.getEnumConstants()) {
            result.add(t);
        }
        return result;
    }

    public static <T extends Enum<?>> T parse(Class<T> clazz, Object value) {
        Enum result;
        Map orgMap;
        if (value == null) {
            return null;
        }
        String lowerKey = value.toString().toLowerCase();
        Map<String, Enum> map = (HashMap)ENUM_CACHE.get(clazz);
        if (map == null && (orgMap = (Map)ENUM_CACHE.putIfAbsent(clazz, map = new HashMap())) != null) {
            map = orgMap;
        }
        if ((result = (Enum)map.get(lowerKey)) != null) {
            return (T)result;
        }
        for (Enum type : (Enum[])clazz.getEnumConstants()) {
            String typeText = type.toString();
            if (type == value) {
                map.put(lowerKey, type);
                return (T)type;
            }
            if (!typeText.equalsIgnoreCase(lowerKey)) continue;
            map.put(lowerKey, type);
            return (T)type;
        }
        return null;
    }

    public static boolean match(EnumConvertable<?> enumConvertable, Object value) {
        if (CommonUtils.eq(enumConvertable.getValue(), value)) {
            return true;
        }
        return enumConvertable.getValue() instanceof String && value instanceof String && enumConvertable.getValue().toString().equalsIgnoreCase((String)value);
    }
}

